/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.shell.hbase.table;

import java.net.URI;
import java.util.concurrent.Callable;
import org.apache.hadoop.gateway.shell.AbstractRequest;
import org.apache.hadoop.gateway.shell.EmptyResponse;
import org.apache.hadoop.gateway.shell.Hadoop;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;

public class TruncateTable {

    public static class Response
    extends EmptyResponse {
        Response(HttpResponse response) {
            super(response);
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        private String tableName;

        public Request(Hadoop session, String tableName) {
            super(session);
            this.tableName = tableName;
        }

        @Override
        protected Callable<Response> callable() {
            return new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    String schema;
                    URI uri = Request.this.uri(new String[]{"/hbase", "/", Request.this.tableName, "/schema"}).build();
                    HttpGet get = new HttpGet(uri);
                    get.setHeader("Accept", "text/xml");
                    try (CloseableHttpResponse getResponse = Request.this.execute((HttpRequest)get);){
                        schema = EntityUtils.toString((HttpEntity)getResponse.getEntity());
                    }
                    HttpDelete delete = new HttpDelete(uri);
                    try (CloseableHttpResponse deleteResponse = Request.this.execute((HttpRequest)delete);){
                        EntityUtils.consumeQuietly((HttpEntity)deleteResponse.getEntity());
                    }
                    HttpPut put = new HttpPut(uri);
                    StringEntity entity = new StringEntity(schema, ContentType.create((String)"text/xml", (String)"UTF-8"));
                    put.setEntity((HttpEntity)entity);
                    return new Response((HttpResponse)Request.this.execute((HttpRequest)put));
                }
            };
        }
    }
}

