/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class ColOrCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int[] colNums;
    private int outputColumn;
    private int[] mapToChildExpression;
    private int[] orSelected;
    private boolean[] intermediateNulls;

    public ColOrCol(int[] colNums, int outputColumn) {
        this();
        this.colNums = colNums;
        this.outputColumn = outputColumn;
        this.mapToChildExpression = null;
        this.orSelected = new int[1024];
        this.intermediateNulls = new boolean[1024];
    }

    public ColOrCol() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        int i;
        int i2;
        int j;
        int childExpressionIndex;
        int n;
        Preconditions.checkState((this.colNums.length >= 2 ? 1 : 0) != 0);
        if (this.childExpressions != null && this.mapToChildExpression == null) {
            this.mapToChildExpression = new int[this.colNums.length];
            Arrays.fill(this.mapToChildExpression, -1);
            int c = 0;
            while (c < this.childExpressions.length) {
                VectorExpression ve = this.childExpressions[c];
                int outputColumn = ve.getOutputColumn();
                int i3 = 0;
                while (true) {
                    if (i3 >= this.colNums.length) {
                        throw new RuntimeException("Vectorized child expression output not found");
                    }
                    if (this.colNums[i3] == outputColumn) break;
                    ++i3;
                }
                this.mapToChildExpression[i3] = c++;
            }
        }
        if ((n = batch.size) <= 0) {
            return;
        }
        if (this.childExpressions != null && (childExpressionIndex = this.mapToChildExpression[0]) != -1) {
            VectorExpression ve = this.childExpressions[childExpressionIndex];
            Preconditions.checkState((ve.getOutputColumn() == this.colNums[0] ? 1 : 0) != 0);
            ve.evaluate(batch);
        }
        int[] sel = batch.selected;
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumn];
        long[] outputVector = outV.vector;
        boolean orRepeating = false;
        boolean orRepeatingHasNulls = false;
        int orSel = 0;
        Arrays.fill(this.intermediateNulls, 0, 1024, false);
        outV.reset();
        if (batch.selectedInUse) {
            for (int j2 = 0; j2 != n; ++j2) {
                int i4 = sel[j2];
                outputVector[i4] = 0L;
            }
        } else {
            Arrays.fill(outputVector, 0, n, 0L);
        }
        LongColumnVector firstColVector = (LongColumnVector)batch.cols[this.colNums[0]];
        long[] firstVector = firstColVector.vector;
        if (firstColVector.isRepeating) {
            if (firstColVector.noNulls || !firstColVector.isNull[0]) {
                if (firstVector[0] == 1L) {
                    outV.isRepeating = true;
                    outputVector[0] = 1L;
                    return;
                }
            } else {
                Preconditions.checkState((boolean)firstColVector.isNull[0]);
                orRepeatingHasNulls = true;
            }
            orRepeating = true;
        } else if (firstColVector.noNulls) {
            if (batch.selectedInUse) {
                for (j = 0; j != n; ++j) {
                    i2 = sel[j];
                    if (firstVector[i2] == 0L) {
                        this.orSelected[orSel++] = i2;
                        continue;
                    }
                    outputVector[i2] = 1L;
                }
            } else {
                for (i = 0; i != n; ++i) {
                    if (firstVector[i] == 0L) {
                        this.orSelected[orSel++] = i;
                        continue;
                    }
                    outputVector[i] = 1L;
                }
            }
        } else if (batch.selectedInUse) {
            for (j = 0; j != n; ++j) {
                i2 = sel[j];
                if (firstColVector.isNull[i2]) {
                    this.intermediateNulls[i2] = true;
                    this.orSelected[orSel++] = i2;
                    continue;
                }
                if (firstVector[i2] == 0L) {
                    this.orSelected[orSel++] = i2;
                    continue;
                }
                outputVector[i2] = 1L;
            }
        } else {
            for (i = 0; i != n; ++i) {
                if (firstColVector.isNull[i]) {
                    this.intermediateNulls[i] = true;
                    this.orSelected[orSel++] = i;
                    continue;
                }
                if (firstVector[i] == 0L) {
                    this.orSelected[orSel++] = i;
                    continue;
                }
                outputVector[i] = 1L;
            }
        }
        int colNum = 1;
        while (orRepeating || orSel != 0) {
            int j3;
            int i5;
            int childExpressionIndex2;
            if (this.childExpressions != null && (childExpressionIndex2 = this.mapToChildExpression[colNum]) != -1) {
                if (orRepeating) {
                    VectorExpression ve = this.childExpressions[childExpressionIndex2];
                    Preconditions.checkState((ve.getOutputColumn() == this.colNums[colNum] ? 1 : 0) != 0);
                    ve.evaluate(batch);
                } else {
                    boolean saveSelectedInUse = batch.selectedInUse;
                    int[] saveSelected = sel;
                    int saveSize = batch.size;
                    batch.selectedInUse = true;
                    batch.selected = this.orSelected;
                    batch.size = orSel;
                    VectorExpression ve = this.childExpressions[childExpressionIndex2];
                    Preconditions.checkState((ve.getOutputColumn() == this.colNums[colNum] ? 1 : 0) != 0);
                    ve.evaluate(batch);
                    batch.selectedInUse = saveSelectedInUse;
                    batch.selected = saveSelected;
                    batch.size = saveSize;
                }
            }
            LongColumnVector nextColVector = (LongColumnVector)batch.cols[this.colNums[colNum]];
            long[] nextVector = nextColVector.vector;
            if (orRepeating) {
                if (nextColVector.isRepeating) {
                    if (nextColVector.noNulls || !nextColVector.isNull[0]) {
                        if (nextVector[0] == 1L) {
                            outV.isRepeating = true;
                            outputVector[0] = 1L;
                            return;
                        }
                    } else {
                        Preconditions.checkState((boolean)nextColVector.isNull[0]);
                        orRepeatingHasNulls = true;
                    }
                } else if (nextColVector.noNulls) {
                    Preconditions.checkState((orSel == 0 ? 1 : 0) != 0);
                    orRepeating = false;
                    if (orRepeatingHasNulls) {
                        if (batch.selectedInUse) {
                            for (int j4 = 0; j4 != n; ++j4) {
                                i5 = sel[j4];
                                if (nextVector[i5] == 0L) {
                                    this.intermediateNulls[i5] = true;
                                    this.orSelected[orSel++] = i5;
                                    continue;
                                }
                                outputVector[i5] = 1L;
                            }
                        } else {
                            for (int i6 = 0; i6 != n; ++i6) {
                                if (nextVector[i6] == 0L) {
                                    this.intermediateNulls[i6] = true;
                                    this.orSelected[orSel++] = i6;
                                    continue;
                                }
                                outputVector[i6] = 1L;
                            }
                        }
                        orRepeatingHasNulls = false;
                    } else if (batch.selectedInUse) {
                        for (int j5 = 0; j5 != n; ++j5) {
                            i5 = sel[j5];
                            if (nextVector[i5] == 0L) {
                                this.orSelected[orSel++] = i5;
                                continue;
                            }
                            outputVector[i5] = 1L;
                        }
                    } else {
                        for (int i7 = 0; i7 != n; ++i7) {
                            if (nextVector[i7] == 0L) {
                                this.orSelected[orSel++] = i7;
                                continue;
                            }
                            outputVector[i7] = 1L;
                        }
                    }
                } else {
                    Preconditions.checkState((orSel == 0 ? 1 : 0) != 0);
                    orRepeating = false;
                    if (orRepeatingHasNulls) {
                        if (batch.selectedInUse) {
                            for (int j6 = 0; j6 != n; ++j6) {
                                i5 = sel[j6];
                                if (nextColVector.isNull[i5] || nextVector[i5] == 0L) {
                                    this.intermediateNulls[i5] = true;
                                    this.orSelected[orSel++] = i5;
                                    continue;
                                }
                                outputVector[i5] = 1L;
                            }
                        } else {
                            for (int i8 = 0; i8 != n; ++i8) {
                                if (nextColVector.isNull[i8] || nextVector[i8] == 0L) {
                                    this.intermediateNulls[i8] = true;
                                    this.orSelected[orSel++] = i8;
                                    continue;
                                }
                                outputVector[i8] = 1L;
                            }
                        }
                        orRepeatingHasNulls = false;
                    } else if (batch.selectedInUse) {
                        for (int j7 = 0; j7 != n; ++j7) {
                            i5 = sel[j7];
                            if (nextColVector.isNull[i5]) {
                                this.intermediateNulls[i5] = true;
                                this.orSelected[orSel++] = i5;
                                continue;
                            }
                            if (nextVector[i5] == 0L) {
                                this.orSelected[orSel++] = i5;
                                continue;
                            }
                            outputVector[i5] = 1L;
                        }
                    } else {
                        for (int i9 = 0; i9 != n; ++i9) {
                            if (nextColVector.isNull[i9]) {
                                this.intermediateNulls[i9] = true;
                                this.orSelected[orSel++] = i9;
                                continue;
                            }
                            if (nextVector[i9] == 0L) {
                                this.orSelected[orSel++] = i9;
                                continue;
                            }
                            outputVector[i9] = 1L;
                        }
                    }
                }
            } else if (nextColVector.isRepeating) {
                if (nextColVector.noNulls || !nextColVector.isNull[0]) {
                    if (nextVector[0] == 1L) {
                        outV.isRepeating = true;
                        outputVector[0] = 1L;
                        return;
                    }
                } else {
                    Preconditions.checkState((boolean)nextColVector.isNull[0]);
                    for (int j8 = 0; j8 < orSel; ++j8) {
                        i5 = this.orSelected[j8];
                        this.intermediateNulls[i5] = true;
                    }
                }
            } else if (nextColVector.noNulls) {
                int newSel = 0;
                for (j3 = 0; j3 < orSel; ++j3) {
                    int i10 = this.orSelected[j3];
                    if (nextVector[i10] == 0L) {
                        this.orSelected[newSel++] = i10;
                        continue;
                    }
                    outputVector[i10] = 1L;
                }
                orSel = newSel;
            } else {
                int newSel = 0;
                for (j3 = 0; j3 < orSel; ++j3) {
                    int i11 = this.orSelected[j3];
                    if (nextColVector.isNull[i11]) {
                        this.intermediateNulls[i11] = true;
                        this.orSelected[newSel++] = i11;
                        continue;
                    }
                    if (nextVector[i11] == 0L) {
                        this.orSelected[newSel++] = i11;
                        continue;
                    }
                    outputVector[i11] = 1L;
                }
                orSel = newSel;
            }
            if (++colNum < this.colNums.length) continue;
        }
        if (orRepeating) {
            outV.isRepeating = true;
            if (orRepeatingHasNulls) {
                outV.noNulls = false;
                outV.isNull[0] = true;
            } else {
                outputVector[0] = 0L;
            }
        } else {
            for (int j9 = 0; j9 < orSel; ++j9) {
                int i12 = this.orSelected[j9];
                Preconditions.checkState((outputVector[i12] == 0L ? 1 : 0) != 0);
                if (!this.intermediateNulls[i12]) continue;
                outV.noNulls = false;
                outV.isNull[i12] = true;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("long"), VectorExpressionDescriptor.ArgumentType.getType("long")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

