/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.persistence.HybridHashTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinBytesTableContainer;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorDeserializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorSerializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinCommonOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinRowBytesContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTableResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedCreateHashTable;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.WriteBuffers;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinaryDeserializeRead;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinarySerializeWrite;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorMapJoinGenerateResultOperator
extends VectorMapJoinCommonOperator {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorMapJoinGenerateResultOperator.class.getName());
    private static final String CLASS_NAME = VectorMapJoinGenerateResultOperator.class.getName();
    private transient TypeInfo[] bigTableTypeInfos;
    private transient VectorSerializeRow bigTableVectorSerializeRow;
    private transient VectorDeserializeRow bigTableVectorDeserializeRow;
    protected transient long batchCounter;

    protected VectorMapJoinGenerateResultOperator() {
    }

    public VectorMapJoinGenerateResultOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorMapJoinGenerateResultOperator(CompilationOpContext ctx, VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        super(ctx, vContext, conf);
    }

    @Override
    protected void commonSetup(VectorizedRowBatch batch) throws HiveException {
        super.commonSetup(batch);
        this.batchCounter = 0L;
    }

    protected void performValueExpressions(VectorizedRowBatch batch, int[] allMatchs, int allMatchCount) {
        int[] saveSelected = batch.selected;
        batch.selected = allMatchs;
        boolean saveSelectedInUse = batch.selectedInUse;
        batch.selectedInUse = true;
        batch.size = allMatchCount;
        for (VectorExpression ve : this.bigTableValueExpressions) {
            ve.evaluate(batch);
        }
        batch.selected = saveSelected;
        batch.selectedInUse = saveSelectedInUse;
    }

    protected void doSmallTableDeserializeRow(VectorizedRowBatch batch, int batchIndex, WriteBuffers.ByteSegmentRef byteSegmentRef, VectorMapJoinHashMapResult hashMapResult) throws HiveException {
        byte[] bytes = byteSegmentRef.getBytes();
        int offset = (int)byteSegmentRef.getOffset();
        int length = byteSegmentRef.getLength();
        this.smallTableVectorDeserializeRow.setBytes(bytes, offset, length);
        try {
            this.smallTableVectorDeserializeRow.deserialize(batch, batchIndex);
        }
        catch (Exception e) {
            throw new HiveException("\nHashMapResult detail: " + hashMapResult.getDetailedHashMapResultPositionString() + "\nDeserializeRead detail: " + this.smallTableVectorDeserializeRow.getDetailedReadPositionString(), e);
        }
    }

    protected int generateHashMapResultSingleValue(VectorizedRowBatch batch, VectorMapJoinHashMapResult hashMapResult, int[] allMatchs, int allMatchesIndex, int duplicateCount, int numSel) throws HiveException, IOException {
        WriteBuffers.ByteSegmentRef byteSegmentRef = hashMapResult.first();
        for (int i = 0; i < duplicateCount; ++i) {
            int batchIndex = allMatchs[allMatchesIndex + i];
            if (this.bigTableVectorCopyOuterKeys != null) {
                this.bigTableVectorCopyOuterKeys.copyByReference(batch, batchIndex, batch, batchIndex);
            }
            if (this.smallTableVectorDeserializeRow != null) {
                this.doSmallTableDeserializeRow(batch, batchIndex, byteSegmentRef, hashMapResult);
            }
            batch.selected[numSel++] = batchIndex;
        }
        return numSel;
    }

    protected void generateHashMapResultMultiValue(VectorizedRowBatch batch, VectorMapJoinHashMapResult hashMapResult, int[] allMatchs, int allMatchesIndex, int duplicateCount) throws HiveException, IOException {
        if (this.useOverflowRepeatedThreshold && hashMapResult.isCappedCountAvailable() && hashMapResult.cappedCount() > this.overflowRepeatedThreshold) {
            this.generateHashMapResultLargeMultiValue(batch, hashMapResult, allMatchs, allMatchesIndex, duplicateCount);
            return;
        }
        for (int i = 0; i < duplicateCount; ++i) {
            int batchIndex = allMatchs[allMatchesIndex + i];
            WriteBuffers.ByteSegmentRef byteSegmentRef = hashMapResult.first();
            while (byteSegmentRef != null) {
                if (this.bigTableRetainedVectorCopy != null) {
                    this.bigTableRetainedVectorCopy.copyByValue(batch, batchIndex, this.overflowBatch, this.overflowBatch.size);
                }
                if (this.smallTableVectorDeserializeRow != null) {
                    this.doSmallTableDeserializeRow(this.overflowBatch, this.overflowBatch.size, byteSegmentRef, hashMapResult);
                }
                ++this.overflowBatch.size;
                if (this.overflowBatch.size == 1024) {
                    this.forwardOverflow();
                }
                byteSegmentRef = hashMapResult.next();
            }
        }
    }

    private void generateHashMapResultLargeMultiValue(VectorizedRowBatch batch, VectorMapJoinHashMapResult hashMapResult, int[] allMatchs, int allMatchesIndex, int duplicateCount) throws HiveException, IOException {
        if (this.overflowBatch.size > 0) {
            this.forwardOverflow();
        }
        WriteBuffers.ByteSegmentRef byteSegmentRef = hashMapResult.first();
        while (byteSegmentRef != null) {
            while (byteSegmentRef != null) {
                if (this.smallTableVectorDeserializeRow != null) {
                    this.doSmallTableDeserializeRow(this.overflowBatch, this.overflowBatch.size, byteSegmentRef, hashMapResult);
                }
                ++this.overflowBatch.size;
                if (this.overflowBatch.size == 1024) break;
                byteSegmentRef = hashMapResult.next();
            }
            for (int i = 0; i < duplicateCount; ++i) {
                int batchIndex = allMatchs[allMatchesIndex + i];
                if (this.bigTableRetainedVectorCopy != null) {
                    this.bigTableRetainedVectorCopy.copyByReference(batch, batchIndex, this.overflowBatch, 0);
                    for (int column : this.bigTableRetainedMapping.getOutputColumns()) {
                        this.overflowBatch.cols[column].isRepeating = true;
                    }
                }
                this.forwardOverflowNoReset();
                for (int column : this.bigTableRetainedMapping.getOutputColumns()) {
                    ColumnVector colVector = this.overflowBatch.cols[column];
                    colVector.reset();
                }
            }
            byteSegmentRef = hashMapResult.next();
            if (byteSegmentRef == null) break;
            this.overflowBatch.reset();
        }
        this.overflowBatch.reset();
    }

    protected void generateHashMapResultRepeatedAll(VectorizedRowBatch batch, VectorMapJoinHashMapResult hashMapResult) throws IOException, HiveException {
        int[] selected = batch.selected;
        if (!batch.selectedInUse) {
            for (int i = 0; i < batch.size; ++i) {
                selected[i] = i;
            }
            batch.selectedInUse = true;
        }
        int numSel = 0;
        if (hashMapResult.isSingleRow()) {
            numSel = this.generateHashMapResultSingleValue(batch, hashMapResult, batch.selected, 0, batch.size, numSel);
        } else {
            this.generateHashMapResultMultiValue(batch, hashMapResult, batch.selected, 0, batch.size);
        }
        batch.size = numSel;
    }

    private void setupSpillSerDe(VectorizedRowBatch batch) throws HiveException {
        TypeInfo[] inputObjInspectorsTypeInfos = VectorizedBatchUtil.typeInfosFromStructObjectInspector((StructObjectInspector)this.inputObjInspectors[this.posBigTable]);
        List<Integer> projectedColumns = this.vContext.getProjectedColumns();
        int projectionSize = this.vContext.getProjectedColumns().size();
        ArrayList<TypeInfo> typeInfoList = new ArrayList<TypeInfo>();
        ArrayList<Integer> noNullsProjectionList = new ArrayList<Integer>();
        for (int i = 0; i < projectionSize; ++i) {
            int projectedColumn = projectedColumns.get(i);
            if (batch.cols[projectedColumn] == null || inputObjInspectorsTypeInfos[i].getCategory() != ObjectInspector.Category.PRIMITIVE) continue;
            typeInfoList.add(inputObjInspectorsTypeInfos[i]);
            noNullsProjectionList.add(projectedColumn);
        }
        int[] noNullsProjection = ArrayUtils.toPrimitive((Integer[])noNullsProjectionList.toArray(new Integer[0]));
        int noNullsProjectionSize = noNullsProjection.length;
        this.bigTableTypeInfos = typeInfoList.toArray(new TypeInfo[0]);
        this.bigTableVectorSerializeRow = new VectorSerializeRow<LazyBinarySerializeWrite>(new LazyBinarySerializeWrite(noNullsProjectionSize));
        this.bigTableVectorSerializeRow.init(this.bigTableTypeInfos, noNullsProjection);
        this.bigTableVectorDeserializeRow = new VectorDeserializeRow<LazyBinaryDeserializeRead>(new LazyBinaryDeserializeRead(this.bigTableTypeInfos));
        this.bigTableVectorDeserializeRow.init(noNullsProjection);
    }

    private void spillSerializeRow(VectorizedRowBatch batch, int batchIndex, VectorMapJoinHashTableResult hashTableResult) throws IOException {
        int partitionId = hashTableResult.spillPartitionId();
        HybridHashTableContainer ht = (HybridHashTableContainer)this.mapJoinTables[this.posSingleVectorMapJoinSmallTable];
        HybridHashTableContainer.HashPartition hp = ht.getHashPartitions()[partitionId];
        VectorMapJoinRowBytesContainer rowBytesContainer = hp.getMatchfileRowBytesContainer();
        ByteStream.Output output = rowBytesContainer.getOuputForRowBytes();
        this.bigTableVectorSerializeRow.setOutputAppend(output);
        this.bigTableVectorSerializeRow.serializeWrite(batch, batchIndex);
        rowBytesContainer.finishRow();
    }

    protected void spillHashMapBatch(VectorizedRowBatch batch, VectorMapJoinHashTableResult[] hashTableResults, int[] spills, int[] spillHashTableResultIndices, int spillCount) throws HiveException, IOException {
        if (this.bigTableVectorSerializeRow == null) {
            this.setupSpillSerDe(batch);
        }
        for (int i = 0; i < spillCount; ++i) {
            int batchIndex = spills[i];
            int hashTableResultIndex = spillHashTableResultIndices[i];
            VectorMapJoinHashTableResult hashTableResult = hashTableResults[hashTableResultIndex];
            this.spillSerializeRow(batch, batchIndex, hashTableResult);
        }
    }

    protected void spillBatchRepeated(VectorizedRowBatch batch, VectorMapJoinHashTableResult hashTableResult) throws HiveException, IOException {
        if (this.bigTableVectorSerializeRow == null) {
            this.setupSpillSerDe(batch);
        }
        int[] selected = batch.selected;
        boolean selectedInUse = batch.selectedInUse;
        for (int logical = 0; logical < batch.size; ++logical) {
            int batchIndex = selectedInUse ? selected[logical] : logical;
            this.spillSerializeRow(batch, batchIndex, hashTableResult);
        }
    }

    @Override
    protected void reloadHashTable(byte pos, int partitionId) throws IOException, HiveException, SerDeException, ClassNotFoundException {
        super.reloadHashTable(pos, partitionId);
        MapJoinBytesTableContainer smallTable = this.spilledMapJoinTables[pos];
        this.vectorMapJoinHashTable = VectorMapJoinOptimizedCreateHashTable.createHashTable((MapJoinDesc)this.conf, smallTable);
        this.needHashTableSetup = true;
        LOG.info("Created " + this.vectorMapJoinHashTable.getClass().getSimpleName() + " from " + this.getClass().getSimpleName());
        if (this.isLogDebugEnabled) {
            LOG.debug(CLASS_NAME + " reloadHashTable!");
        }
    }

    @Override
    protected void reProcessBigTable(int partitionId) throws HiveException {
        if (this.isLogDebugEnabled) {
            LOG.debug(CLASS_NAME + " reProcessBigTable enter...");
        }
        if (this.spillReplayBatch == null) {
            return;
        }
        HybridHashTableContainer.HashPartition partition = this.firstSmallTable.getHashPartitions()[partitionId];
        int rowCount = 0;
        int batchCount = 0;
        try {
            VectorMapJoinRowBytesContainer bigTable = partition.getMatchfileRowBytesContainer();
            bigTable.prepareForReading();
            while (bigTable.readNext()) {
                ++rowCount;
                byte[] bytes = bigTable.currentBytes();
                int offset = bigTable.currentOffset();
                int length = bigTable.currentLength();
                this.bigTableVectorDeserializeRow.setBytes(bytes, offset, length);
                try {
                    this.bigTableVectorDeserializeRow.deserialize(this.spillReplayBatch, this.spillReplayBatch.size);
                }
                catch (Exception e) {
                    throw new HiveException("\nDeserializeRead detail: " + this.bigTableVectorDeserializeRow.getDetailedReadPositionString(), e);
                }
                ++this.spillReplayBatch.size;
                if (this.spillReplayBatch.size != 1024) continue;
                this.process(this.spillReplayBatch, this.posBigTable);
                this.spillReplayBatch.reset();
                ++batchCount;
            }
            if (this.spillReplayBatch.size > 0) {
                this.process(this.spillReplayBatch, this.posBigTable);
                this.spillReplayBatch.reset();
                ++batchCount;
            }
            bigTable.clear();
        }
        catch (Exception e) {
            LOG.info(CLASS_NAME + " reProcessBigTable exception! " + e);
            throw new HiveException(e);
        }
        if (this.isLogDebugEnabled) {
            LOG.debug(CLASS_NAME + " reProcessBigTable exit! " + rowCount + " row processed and " + batchCount + " batches processed");
        }
    }

    public void forwardBigTableBatch(VectorizedRowBatch batch) throws HiveException {
        int[] originalProjections = batch.projectedColumns;
        int originalProjectionSize = batch.projectionSize;
        batch.projectionSize = this.outputProjection.length;
        batch.projectedColumns = this.outputProjection;
        this.forward(batch, null);
        batch.projectionSize = originalProjectionSize;
        batch.projectedColumns = originalProjections;
    }

    protected void forwardOverflow() throws HiveException {
        this.forward(this.overflowBatch, null);
        this.overflowBatch.reset();
    }

    private void forwardOverflowNoReset() throws HiveException {
        this.forward(this.overflowBatch, null);
    }

    @Override
    public void closeOp(boolean aborted) throws HiveException {
        super.closeOp(aborted);
        if (!aborted && this.overflowBatch.size > 0) {
            this.forwardOverflow();
        }
        if (this.isLogDebugEnabled) {
            LOG.debug("VectorMapJoinInnerLongOperator closeOp " + this.batchCounter + " batches processed");
        }
    }

    public boolean verifyMonotonicallyIncreasing(int[] selected, int size) {
        if (size == 0) {
            return true;
        }
        int prevBatchIndex = selected[0];
        for (int i = 1; i < size; ++i) {
            int batchIndex = selected[i];
            if (batchIndex <= prevBatchIndex) {
                return false;
            }
            prevBatchIndex = batchIndex;
        }
        return true;
    }

    public static String intArrayToRangesString(int[] selection, int size) {
        int i;
        if (size == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int firstIndex = 0;
        int firstValue = selection[0];
        boolean duplicates = false;
        for (i = 1; i < size; ++i) {
            int priorRangeLength;
            int newValue = selection[i];
            if (newValue == selection[i - 1]) {
                duplicates = true;
                if (newValue == firstValue || (priorRangeLength = i - 1 - firstIndex) == 0) continue;
                if (firstIndex > 0) {
                    sb.append(",");
                }
                sb.append(firstValue);
                if (priorRangeLength > 1) {
                    sb.append(".." + selection[i - 2]);
                }
                firstIndex = i - 1;
                firstValue = newValue;
                continue;
            }
            if (duplicates) {
                int numDuplicates = i - firstIndex;
                if (firstIndex > 0) {
                    sb.append(",");
                }
                sb.append(numDuplicates + "*" + firstValue);
                duplicates = false;
                firstIndex = i;
                firstValue = newValue;
                continue;
            }
            if (newValue == selection[i - 1] + 1) continue;
            priorRangeLength = i - firstIndex;
            if (firstIndex > 0) {
                sb.append(",");
            }
            sb.append(firstValue);
            if (priorRangeLength > 1) {
                sb.append(".." + selection[i - 1]);
            }
            firstIndex = i;
            firstValue = newValue;
        }
        if (duplicates) {
            int numDuplicates = i - firstIndex;
            if (firstIndex > 0) {
                sb.append(",");
            }
            sb.append(numDuplicates + "*" + firstValue);
        } else {
            int priorRangeLength = i - firstIndex;
            if (firstIndex > 0) {
                sb.append(",");
            }
            sb.append(firstValue);
            if (priorRangeLength > 1) {
                sb.append(".." + selection[i - 1]);
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static String longArrayToRangesString(long[] selection, int size) {
        int i;
        if (size == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int firstIndex = 0;
        long firstValue = selection[0];
        boolean duplicates = false;
        for (i = 1; i < size; ++i) {
            int priorRangeLength;
            long newValue = selection[i];
            if (newValue == selection[i - 1]) {
                duplicates = true;
                if (newValue == firstValue || (priorRangeLength = i - 1 - firstIndex) == 0) continue;
                if (firstIndex > 0) {
                    sb.append(",");
                }
                sb.append(firstValue);
                if (priorRangeLength > 1) {
                    sb.append(".." + selection[i - 2]);
                }
                firstIndex = i - 1;
                firstValue = newValue;
                continue;
            }
            if (duplicates) {
                int numDuplicates = i - firstIndex;
                if (firstIndex > 0) {
                    sb.append(",");
                }
                sb.append(numDuplicates + "*" + firstValue);
                duplicates = false;
                firstIndex = i;
                firstValue = newValue;
                continue;
            }
            if (newValue == selection[i - 1] + 1L) continue;
            priorRangeLength = i - firstIndex;
            if (firstIndex > 0) {
                sb.append(",");
            }
            sb.append(firstValue);
            if (priorRangeLength > 1) {
                sb.append(".." + selection[i - 1]);
            }
            firstIndex = i;
            firstValue = newValue;
        }
        if (duplicates) {
            int numDuplicates = i - firstIndex;
            if (firstIndex > 0) {
                sb.append(",");
            }
            sb.append(numDuplicates + "*" + firstValue);
        } else {
            int priorRangeLength = i - firstIndex;
            if (firstIndex > 0) {
                sb.append(",");
            }
            sb.append(firstValue);
            if (priorRangeLength > 1) {
                sb.append(".." + selection[i - 1]);
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

