/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorMapJoinFastHashTable
implements VectorMapJoinHashTable {
    public static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastHashTable.class);
    protected int logicalHashBucketCount;
    protected int logicalHashBucketMask;
    protected float loadFactor;
    protected final int writeBuffersSize;
    protected int metricPutConflict;
    protected int largestNumberOfSteps;
    protected int keysAssigned;
    protected int resizeThreshold;
    protected int metricExpands;

    private static void validateCapacity(long capacity) {
        if (Long.bitCount(capacity) != 1) {
            throw new AssertionError((Object)"Capacity must be a power of two");
        }
        if (capacity <= 0L) {
            throw new AssertionError((Object)("Invalid capacity " + capacity));
        }
    }

    private static int nextHighestPowerOfTwo(int v) {
        return Integer.highestOneBit(v) << 1;
    }

    public VectorMapJoinFastHashTable(int initialCapacity, float loadFactor, int writeBuffersSize) {
        initialCapacity = Long.bitCount(initialCapacity) == 1 ? initialCapacity : VectorMapJoinFastHashTable.nextHighestPowerOfTwo(initialCapacity);
        VectorMapJoinFastHashTable.validateCapacity(initialCapacity);
        this.logicalHashBucketCount = initialCapacity;
        this.logicalHashBucketMask = this.logicalHashBucketCount - 1;
        this.resizeThreshold = (int)((float)this.logicalHashBucketCount * loadFactor);
        this.loadFactor = loadFactor;
        this.writeBuffersSize = writeBuffersSize;
    }

    @Override
    public int size() {
        return this.keysAssigned;
    }
}

