/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.plan.RelOptAbstractTable;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelCollation;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelDistribution;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ExprNodeConverter;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelOptHiveTable
extends RelOptAbstractTable {
    private final Table hiveTblMetadata;
    private final ImmutableList<ColumnInfo> hiveNonPartitionCols;
    private final ImmutableList<ColumnInfo> hivePartitionCols;
    private final ImmutableMap<Integer, ColumnInfo> hiveNonPartitionColsMap;
    private final ImmutableMap<Integer, ColumnInfo> hivePartitionColsMap;
    private final ImmutableList<VirtualColumn> hiveVirtualCols;
    private final int noOfNonVirtualCols;
    final HiveConf hiveConf;
    private double rowCount = -1.0;
    Map<Integer, ColStatistics> hiveColStatsMap = new HashMap<Integer, ColStatistics>();
    PrunedPartitionList partitionList;
    Map<String, PrunedPartitionList> partitionCache;
    AtomicInteger noColsMissingStats;
    protected static final Logger LOG = LoggerFactory.getLogger((String)RelOptHiveTable.class.getName());

    public RelOptHiveTable(RelOptSchema calciteSchema, String qualifiedTblName, RelDataType rowType, Table hiveTblMetadata, List<ColumnInfo> hiveNonPartitionCols, List<ColumnInfo> hivePartitionCols, List<VirtualColumn> hiveVirtualCols, HiveConf hconf, Map<String, PrunedPartitionList> partitionCache, AtomicInteger noColsMissingStats) {
        super(calciteSchema, qualifiedTblName, rowType);
        this.hiveTblMetadata = hiveTblMetadata;
        this.hiveNonPartitionCols = ImmutableList.copyOf(hiveNonPartitionCols);
        this.hiveNonPartitionColsMap = HiveCalciteUtil.getColInfoMap(hiveNonPartitionCols, 0);
        this.hivePartitionCols = ImmutableList.copyOf(hivePartitionCols);
        this.hivePartitionColsMap = HiveCalciteUtil.getColInfoMap(hivePartitionCols, this.hiveNonPartitionColsMap.size());
        this.noOfNonVirtualCols = hiveNonPartitionCols.size() + hivePartitionCols.size();
        this.hiveVirtualCols = ImmutableList.copyOf(hiveVirtualCols);
        this.hiveConf = hconf;
        this.partitionCache = partitionCache;
        this.noColsMissingStats = noColsMissingStats;
    }

    public RelOptHiveTable copy(RelDataType newRowType) {
        HashMap<String, Integer> nameToColIndxMap = new HashMap<String, Integer>();
        for (RelDataTypeField f : this.rowType.getFieldList()) {
            nameToColIndxMap.put(f.getName(), f.getIndex());
        }
        ArrayList<ColumnInfo> newHiveNonPartitionCols = new ArrayList<ColumnInfo>();
        ArrayList<ColumnInfo> newHivePartitionCols = new ArrayList<ColumnInfo>();
        ArrayList<VirtualColumn> newHiveVirtualCols = new ArrayList<VirtualColumn>();
        ImmutableMap<Integer, VirtualColumn> virtualColInfoMap = HiveCalciteUtil.getVColsMap(this.hiveVirtualCols, this.noOfNonVirtualCols);
        for (RelDataTypeField f : newRowType.getFieldList()) {
            Integer originalColIndx = (Integer)nameToColIndxMap.get(f.getName());
            ColumnInfo cInfo = (ColumnInfo)this.hiveNonPartitionColsMap.get((Object)originalColIndx);
            if (cInfo != null) {
                newHiveNonPartitionCols.add(new ColumnInfo(cInfo));
                continue;
            }
            cInfo = (ColumnInfo)this.hivePartitionColsMap.get((Object)originalColIndx);
            if (cInfo != null) {
                newHivePartitionCols.add(new ColumnInfo(cInfo));
                continue;
            }
            VirtualColumn vc = (VirtualColumn)virtualColInfoMap.get(originalColIndx);
            if (vc != null) {
                newHiveVirtualCols.add(vc);
                continue;
            }
            throw new RuntimeException("Copy encountered a column not seen in original TS");
        }
        return new RelOptHiveTable(this.schema, this.name, newRowType, this.hiveTblMetadata, newHiveNonPartitionCols, newHivePartitionCols, newHiveVirtualCols, this.hiveConf, this.partitionCache, this.noColsMissingStats);
    }

    public boolean isKey(ImmutableBitSet arg0) {
        return false;
    }

    public RelNode toRel(RelOptTable.ToRelContext context) {
        return new LogicalTableScan(context.getCluster(), (RelOptTable)this);
    }

    public <T> T unwrap(Class<T> arg0) {
        return arg0.isInstance((Object)this) ? (T)arg0.cast((Object)this) : null;
    }

    public List<RelCollation> getCollationList() {
        ImmutableList.Builder collationList = new ImmutableList.Builder();
        block0: for (Order sortColumn : this.hiveTblMetadata.getSortCols()) {
            for (int i = 0; i < this.hiveTblMetadata.getSd().getCols().size(); ++i) {
                RelFieldCollation.NullDirection nullDirection;
                RelFieldCollation.Direction direction;
                FieldSchema field = (FieldSchema)this.hiveTblMetadata.getSd().getCols().get(i);
                if (!field.getName().equals(sortColumn.getCol())) continue;
                if (sortColumn.getOrder() == BaseSemanticAnalyzer.HIVE_COLUMN_ORDER_ASC) {
                    direction = RelFieldCollation.Direction.ASCENDING;
                    nullDirection = RelFieldCollation.NullDirection.FIRST;
                } else {
                    direction = RelFieldCollation.Direction.DESCENDING;
                    nullDirection = RelFieldCollation.NullDirection.LAST;
                }
                collationList.add((Object)new RelFieldCollation(i, direction, nullDirection));
                continue block0;
            }
        }
        return new ImmutableList.Builder().add((Object)RelCollationTraitDef.INSTANCE.canonize((RelTrait)new HiveRelCollation((ImmutableList<RelFieldCollation>)collationList.build()))).build();
    }

    public RelDistribution getDistribution() {
        ImmutableList.Builder columnPositions = new ImmutableList.Builder();
        block0: for (String bucketColumn : this.hiveTblMetadata.getBucketCols()) {
            for (int i = 0; i < this.hiveTblMetadata.getSd().getCols().size(); ++i) {
                FieldSchema field = (FieldSchema)this.hiveTblMetadata.getSd().getCols().get(i);
                if (!field.getName().equals(bucketColumn)) continue;
                columnPositions.add((Object)i);
                continue block0;
            }
        }
        return new HiveRelDistribution(RelDistribution.Type.HASH_DISTRIBUTED, (List<Integer>)columnPositions.build());
    }

    public double getRowCount() {
        if (this.rowCount == -1.0) {
            if (null == this.partitionList) {
                this.computePartitionList(this.hiveConf, null, new HashSet<Integer>());
            }
            if (this.hiveTblMetadata.isPartitioned()) {
                List<Long> rowCounts = StatsUtils.getBasicStatForPartitions(this.hiveTblMetadata, this.partitionList.getNotDeniedPartns(), "numRows");
                this.rowCount = StatsUtils.getSumIgnoreNegatives(rowCounts);
            } else {
                this.rowCount = StatsUtils.getNumRows(this.hiveTblMetadata);
            }
        }
        if (this.rowCount == -1.0) {
            this.noColsMissingStats.getAndIncrement();
        }
        return this.rowCount;
    }

    public Table getHiveTableMD() {
        return this.hiveTblMetadata;
    }

    private String getColNamesForLogging(Set<String> colLst) {
        StringBuilder sb = new StringBuilder();
        boolean firstEntry = true;
        for (String colName : colLst) {
            if (firstEntry) {
                sb.append(colName);
                firstEntry = false;
                continue;
            }
            sb.append(", " + colName);
        }
        return sb.toString();
    }

    public void computePartitionList(HiveConf conf, RexNode pruneNode, Set<Integer> partOrVirtualCols) {
        try {
            if (!this.hiveTblMetadata.isPartitioned() || pruneNode == null || RelOptUtil.InputFinder.bits((RexNode)pruneNode).length() == 0) {
                this.partitionList = PartitionPruner.prune(this.hiveTblMetadata, null, conf, this.getName(), this.partitionCache);
                return;
            }
            ExprNodeDesc pruneExpr = (ExprNodeDesc)pruneNode.accept((RexVisitor)new ExprNodeConverter(this.getName(), this.getRowType(), partOrVirtualCols, this.getRelOptSchema().getTypeFactory()));
            this.partitionList = PartitionPruner.prune(this.hiveTblMetadata, pruneExpr, conf, this.getName(), this.partitionCache);
        }
        catch (HiveException he) {
            throw new RuntimeException(he);
        }
    }

    private void updateColStats(Set<Integer> projIndxLst, boolean allowNullColumnForMissingStats) {
        ArrayList<String> nonPartColNamesThatRqrStats = new ArrayList<String>();
        ArrayList<Integer> nonPartColIndxsThatRqrStats = new ArrayList<Integer>();
        ArrayList<String> partColNamesThatRqrStats = new ArrayList<String>();
        ArrayList<Integer> partColIndxsThatRqrStats = new ArrayList<Integer>();
        HashSet<String> colNamesFailedStats = new HashSet<String>();
        for (Integer pi : projIndxLst) {
            if (this.hiveColStatsMap.get(pi) != null) continue;
            ColumnInfo tmp = (ColumnInfo)this.hiveNonPartitionColsMap.get((Object)pi);
            if (tmp != null) {
                nonPartColNamesThatRqrStats.add(tmp.getInternalName());
                nonPartColIndxsThatRqrStats.add(pi);
                continue;
            }
            tmp = (ColumnInfo)this.hivePartitionColsMap.get((Object)pi);
            if (tmp != null) {
                partColNamesThatRqrStats.add(tmp.getInternalName());
                partColIndxsThatRqrStats.add(pi);
                continue;
            }
            this.noColsMissingStats.getAndIncrement();
            String string = "Unable to find Column Index: " + pi + ", in " + this.hiveTblMetadata.getCompleteName();
            LOG.error(string);
            throw new RuntimeException(string);
        }
        if (null == this.partitionList) {
            this.computePartitionList(this.hiveConf, null, new HashSet<Integer>());
        }
        if (nonPartColNamesThatRqrStats.size() > 0) {
            List<ColStatistics> hiveColStats;
            if (!this.hiveTblMetadata.isPartitioned()) {
                hiveColStats = StatsUtils.getTableColumnStats(this.hiveTblMetadata, this.hiveNonPartitionCols, nonPartColNamesThatRqrStats);
                if (hiveColStats == null) {
                    colNamesFailedStats.addAll(nonPartColNamesThatRqrStats);
                } else if (hiveColStats.size() != nonPartColNamesThatRqrStats.size()) {
                    HashSet<String> setOfFiledCols = new HashSet<String>(nonPartColNamesThatRqrStats);
                    HashSet<String> hashSet = new HashSet<String>();
                    for (ColStatistics cs : hiveColStats) {
                        hashSet.add(cs.getColumnName());
                    }
                    setOfFiledCols.removeAll(hashSet);
                    colNamesFailedStats.addAll(setOfFiledCols);
                } else {
                    HashMap columnStatsMap = new HashMap(hiveColStats.size());
                    for (ColStatistics cs : hiveColStats) {
                        columnStatsMap.put(cs.getColumnName(), cs);
                    }
                    hiveColStats.clear();
                    for (String colName : nonPartColNamesThatRqrStats) {
                        hiveColStats.add((ColStatistics)columnStatsMap.get(colName));
                    }
                }
            } else {
                try {
                    if (this.partitionList.getNotDeniedPartns().isEmpty()) {
                        this.rowCount = 0.0;
                        hiveColStats = new ArrayList<ColStatistics>();
                        for (String string : nonPartColNamesThatRqrStats) {
                            hiveColStats.add(new ColStatistics(string, null));
                        }
                        colNamesFailedStats.clear();
                    }
                    Statistics stats = StatsUtils.collectStatistics(this.hiveConf, this.partitionList, this.hiveTblMetadata, this.hiveNonPartitionCols, nonPartColNamesThatRqrStats, nonPartColNamesThatRqrStats, true, true);
                    this.rowCount = stats.getNumRows();
                    hiveColStats = new ArrayList<ColStatistics>();
                    for (String c : nonPartColNamesThatRqrStats) {
                        ColStatistics cs;
                        cs = stats.getColumnStatisticsFromColName(c);
                        if (cs != null) {
                            hiveColStats.add(cs);
                            continue;
                        }
                        colNamesFailedStats.add(c);
                    }
                }
                catch (HiveException e) {
                    String string = "Collecting stats failed.";
                    LOG.error(string, (Throwable)e);
                    throw new RuntimeException(string, e);
                }
            }
            if (hiveColStats != null && hiveColStats.size() == nonPartColNamesThatRqrStats.size()) {
                for (int i = 0; i < hiveColStats.size(); ++i) {
                    this.hiveColStatsMap.put((Integer)nonPartColIndxsThatRqrStats.get(i), hiveColStats.get(i));
                }
            }
        }
        if (colNamesFailedStats.isEmpty() && !partColNamesThatRqrStats.isEmpty()) {
            ColStatistics cStats = null;
            for (int i = 0; i < partColNamesThatRqrStats.size(); ++i) {
                cStats = new ColStatistics((String)partColNamesThatRqrStats.get(i), ((ColumnInfo)this.hivePartitionColsMap.get(partColIndxsThatRqrStats.get(i))).getTypeName());
                cStats.setCountDistint(this.getDistinctCount(this.partitionList.getPartitions(), (String)partColNamesThatRqrStats.get(i)));
                this.hiveColStatsMap.put((Integer)partColIndxsThatRqrStats.get(i), cStats);
            }
        }
        if (!colNamesFailedStats.isEmpty()) {
            String logMsg = "No Stats for " + this.hiveTblMetadata.getCompleteName() + ", Columns: " + this.getColNamesForLogging(colNamesFailedStats);
            this.noColsMissingStats.getAndAdd(colNamesFailedStats.size());
            if (allowNullColumnForMissingStats) {
                LOG.warn(logMsg);
            } else {
                LOG.error(logMsg);
                throw new RuntimeException(logMsg);
            }
        }
    }

    private int getDistinctCount(Set<Partition> partitions, String partColName) {
        HashSet<String> distinctVals = new HashSet<String>(partitions.size());
        for (Partition partition : partitions) {
            distinctVals.add(partition.getSpec().get(partColName));
        }
        return distinctVals.size();
    }

    public List<ColStatistics> getColStat(List<Integer> projIndxLst) {
        return this.getColStat(projIndxLst, false);
    }

    public List<ColStatistics> getColStat(List<Integer> projIndxLst, boolean allowNullColumnForMissingStats) {
        ArrayList colStatsBldr = Lists.newArrayList();
        if (projIndxLst != null) {
            this.updateColStats(new HashSet<Integer>(projIndxLst), allowNullColumnForMissingStats);
            for (Integer i : projIndxLst) {
                colStatsBldr.add(this.hiveColStatsMap.get(i));
            }
        } else {
            ArrayList<Integer> pILst = new ArrayList<Integer>();
            Integer i = 0;
            while (i < this.noOfNonVirtualCols) {
                pILst.add(i);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            this.updateColStats(new HashSet<Integer>(pILst), allowNullColumnForMissingStats);
            for (Integer pi : pILst) {
                colStatsBldr.add(this.hiveColStatsMap.get(pi));
            }
        }
        return colStatsBldr;
    }

    public boolean containsPartitionColumnsOnly(ImmutableBitSet cols) {
        int i = cols.nextSetBit(0);
        while (i >= 0) {
            if (!this.hivePartitionColsMap.containsKey((Object)i)) {
                return false;
            }
            ++i;
            i = cols.nextSetBit(i + 1);
        }
        return true;
    }

    public List<VirtualColumn> getVirtualCols() {
        return this.hiveVirtualCols;
    }

    public List<ColumnInfo> getPartColumns() {
        return this.hivePartitionCols;
    }

    public List<ColumnInfo> getNonPartColumns() {
        return this.hiveNonPartitionCols;
    }

    public int getNoOfNonVirtualCols() {
        return this.noOfNonVirtualCols;
    }

    public Map<Integer, ColumnInfo> getPartColInfoMap() {
        return this.hivePartitionColsMap;
    }

    public Map<Integer, ColumnInfo> getNonPartColInfoMap() {
        return this.hiveNonPartitionColsMap;
    }
}

