/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.util.DependencyResolver;
import org.apache.hadoop.hive.ql.util.DosToUnix;
import org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDownloader {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceDownloader.class);
    private final DependencyResolver dependencyResolver = new DependencyResolver();
    private final Configuration conf;
    private final File resourceDir;

    public ResourceDownloader(Configuration conf, String resourceDirPath) {
        this.conf = conf;
        this.resourceDir = new File(resourceDirPath);
        ResourceDownloader.ensureDirectory(this.resourceDir);
    }

    public static URI createURI(String path) throws URISyntaxException {
        if (!Shell.WINDOWS) {
            return new URI(path);
        }
        return new Path(path).toUri();
    }

    public static boolean isIvyUri(String value) throws URISyntaxException {
        return "ivy".equalsIgnoreCase(ResourceDownloader.createURI(value).getScheme());
    }

    public static boolean isFileUri(String value) {
        String scheme = null;
        try {
            scheme = ResourceDownloader.createURI(value).getScheme();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        return scheme == null || scheme.equalsIgnoreCase("file");
    }

    public List<URI> resolveAndDownload(String source, boolean convertToUnix) throws URISyntaxException, IOException {
        return this.resolveAndDownloadInternal(ResourceDownloader.createURI(source), null, convertToUnix, true);
    }

    public List<URI> downloadExternal(URI source, String subDir, boolean convertToUnix) throws URISyntaxException, IOException {
        return this.resolveAndDownloadInternal(source, subDir, convertToUnix, false);
    }

    private List<URI> resolveAndDownloadInternal(URI source, String subDir, boolean convertToUnix, boolean isLocalAllowed) throws URISyntaxException, IOException {
        switch (ResourceDownloader.getURLType(source)) {
            case FILE: {
                return isLocalAllowed ? Lists.newArrayList((Object[])new URI[]{source}) : null;
            }
            case IVY: {
                return this.dependencyResolver.downloadDependencies(source);
            }
            case OTHER: {
                return Lists.newArrayList((Object[])new URI[]{ResourceDownloader.createURI(this.downloadResource(source, subDir, convertToUnix))});
            }
        }
        throw new AssertionError((Object)ResourceDownloader.getURLType(source));
    }

    private String downloadResource(URI srcUri, String subDir, boolean convertToUnix) throws IOException, URISyntaxException {
        LOG.info("converting to local " + srcUri);
        File destinationDir = subDir == null ? this.resourceDir : new File(this.resourceDir, subDir);
        ResourceDownloader.ensureDirectory(destinationDir);
        File destinationFile = new File(destinationDir, new Path(srcUri.toString()).getName());
        String dest = destinationFile.getCanonicalPath();
        if (destinationFile.exists()) {
            return dest;
        }
        FileSystem fs = FileSystem.get((URI)srcUri, (Configuration)this.conf);
        fs.copyToLocalFile(new Path(srcUri.toString()), new Path(dest));
        FileUtil.chmod((String)dest, (String)"ugo+rx", (boolean)true);
        if (convertToUnix && DosToUnix.isWindowsScript(destinationFile)) {
            DosToUnix.convertWindowsScriptToUnix(destinationFile);
        }
        return dest;
    }

    private static void ensureDirectory(File resourceDir) {
        boolean doesExist = resourceDir.exists();
        if (doesExist && !resourceDir.isDirectory()) {
            throw new RuntimeException(resourceDir + " is not a directory");
        }
        if (!doesExist && !resourceDir.mkdirs()) {
            throw new RuntimeException("Couldn't create directory " + resourceDir);
        }
    }

    private static UriType getURLType(URI value) throws URISyntaxException {
        String scheme = value.getScheme();
        if (scheme == null) {
            return UriType.FILE;
        }
        if ("ivy".equals(scheme = scheme.toLowerCase())) {
            return UriType.IVY;
        }
        if ("file".equals(scheme)) {
            return UriType.FILE;
        }
        return UriType.OTHER;
    }

    private static enum UriType {
        IVY,
        FILE,
        OTHER;

    }
}

