/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart;

import org.pentaho.chart.ChartData;
import org.pentaho.chart.ChartDefinition;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ChartDefinitionImpl
implements ChartDefinition {
    private ResourceKey chartKey;
    private ResourceManager resourceManager;
    private ChartDocument chartDocument;
    private ChartData data;

    public ChartDefinitionImpl(ChartData data, ChartDocument doc) throws IllegalArgumentException {
        if (doc == null) {
            throw new IllegalArgumentException();
        }
        this.chartDocument = doc;
        this.data = data;
        this.chartKey = this.chartDocument.getResourceKey();
        this.resourceManager = this.chartDocument.getResourceManager();
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceManager();
            this.resourceManager.registerDefaults();
        }
    }

    public ChartDefinitionImpl(ChartDocument doc) throws IllegalArgumentException {
        this(null, doc);
    }

    public ChartDefinitionImpl(ChartData data, ResourceManager manager, ResourceKey key) throws IllegalArgumentException, ResourceException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        this.data = data;
        this.chartKey = key;
        this.resourceManager = manager;
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceManager();
            this.resourceManager.registerDefaults();
        }
        Resource resource = this.resourceManager.create(this.chartKey, null, ChartDocument.class);
        this.chartDocument = (ChartDocument)resource.getResource();
    }

    public ChartDefinitionImpl(ResourceManager manager, ResourceKey key) throws IllegalArgumentException, ResourceException {
        this(null, manager, key);
    }

    @Override
    public void setData(ChartData data) {
        this.data = data;
    }

    @Override
    public ChartData getData() {
        return this.data;
    }

    @Override
    public ResourceKey getChartResourceKey() {
        return this.chartKey;
    }

    @Override
    public ResourceManager getChartResourceManager() {
        return this.resourceManager;
    }

    @Override
    public ChartDocument getChartDocument() {
        return this.chartDocument;
    }
}

