/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart;

import java.awt.Image;
import java.util.ArrayList;
import org.pentaho.chart.ChartNamespaceDefinition;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.core.ChartSeriesDataLinkInfo;
import org.pentaho.reporting.libraries.css.dom.DocumentContext;
import org.pentaho.reporting.libraries.css.dom.LayoutOutputMetaData;
import org.pentaho.reporting.libraries.css.dom.StyleReference;
import org.pentaho.reporting.libraries.css.model.StyleKeyRegistry;
import org.pentaho.reporting.libraries.css.namespace.DefaultNamespaceCollection;
import org.pentaho.reporting.libraries.css.namespace.NamespaceCollection;
import org.pentaho.reporting.libraries.css.namespace.NamespaceDefinition;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ChartDocumentContext
implements DocumentContext {
    private final ResourceManager resourceManager;
    private final ChartDocument chartDocument;
    private final ResourceKey resourceKey;
    private final DefaultNamespaceCollection namespaceCollection;
    private ChartSeriesDataLinkInfo dataLinkInfo;
    private static final Class[] SUPPORTED_TYPES = new Class[]{Image.class};

    public ChartDocumentContext(ChartDocument chart) throws ResourceKeyCreationException {
        this.chartDocument = chart;
        this.resourceManager = chart.getResourceManager();
        this.resourceKey = chart.getResourceKey();
        this.namespaceCollection = new DefaultNamespaceCollection();
        this.namespaceCollection.addDefinition((NamespaceDefinition)new ChartNamespaceDefinition(this.resourceManager));
    }

    public ChartDocument getChartDocument() {
        return this.chartDocument;
    }

    public StyleReference[] getStyleReferences() {
        return this.createStyleReferences(this.chartDocument);
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public ResourceKey getContextKey() {
        return this.resourceKey;
    }

    public Class[] getSupportedResourceTypes() {
        return (Class[])SUPPORTED_TYPES.clone();
    }

    public NamespaceCollection getNamespaces() {
        return this.namespaceCollection;
    }

    public StyleKeyRegistry getStyleKeyRegistry() {
        return StyleKeyRegistry.getRegistry();
    }

    public LayoutOutputMetaData getOutputMetaData() {
        return null;
    }

    protected StyleReference[] createStyleReferences(ChartDocument chartDoc) {
        ChartElement[] styleSheetElements = chartDoc.getRootElement().findChildrenByName("stylesheet");
        ArrayList<StyleReference> styleReferenceList = new ArrayList<StyleReference>(styleSheetElements.length);
        int elementsLength = styleSheetElements.length;
        for (int i = 0; i < elementsLength; ++i) {
            String styleSheetText;
            String hrefText = (String)styleSheetElements[i].getAttribute("href");
            if (hrefText != null) {
                StyleReference linkStyleReference = new StyleReference(0, hrefText);
                styleReferenceList.add(linkStyleReference);
            }
            if ((styleSheetText = styleSheetElements[i].getText()) == null) continue;
            StyleReference inlineStyleReference = new StyleReference(1, styleSheetText);
            styleReferenceList.add(inlineStyleReference);
        }
        return styleReferenceList.toArray(new StyleReference[styleReferenceList.size()]);
    }

    public ChartSeriesDataLinkInfo getDataLinkInfo() {
        return this.dataLinkInfo;
    }

    public void setDataLinkInfo(ChartSeriesDataLinkInfo dataLinkInfo) {
        this.dataLinkInfo = dataLinkInfo;
    }
}

