/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class ChartDocumentValidator {
    private ChartDocument chartDoc;
    private final List<String> messages = new ArrayList<String>();

    public ChartDocumentValidator(ChartDocument chartDoc) {
        this();
        this.chartDoc = chartDoc;
        this.revalidate();
    }

    ChartDocumentValidator() {
    }

    public void revalidate() {
        this.messages.clear();
        if (this.messages.isEmpty()) {
            this.validateChartTag();
        }
        if (this.messages.isEmpty()) {
            this.validateSeriesTags();
        }
        if (this.messages.isEmpty()) {
            this.validateGroupTags(this.chartDoc.getGroupChartElements());
        }
    }

    private void validateSeriesTags() {
        ChartElement[] seriesElements = this.chartDoc.getSeriesChartElements();
        if (seriesElements.length == 0) {
            this.messages.add("Could not find any <series> tags as children of the <chart> tag");
        }
    }

    private void validateChartTag() {
        if (this.chartDoc == null || this.chartDoc.getRootElement() == null) {
            this.messages.add("Chart Document is empty");
        } else if (!"chart".equals(this.chartDoc.getRootElement().getTagName())) {
            this.messages.add("<chart> must be the root chart element");
        }
    }

    void validateGroupTags(ChartElement[] groupElements) {
        if (groupElements.length > 0) {
            ChartElement groupElement = groupElements[0];
            ChartElement parentGroupElement = null;
            boolean isStacked = false;
            while (groupElement != null) {
                String stacked = (String)groupElement.getAttribute("stacked");
                boolean elementStacked = StringUtils.toBoolean((String)stacked);
                if (isStacked && !elementStacked) {
                    groupElement.setAttribute("stacked", Boolean.TRUE.toString());
                }
                isStacked = isStacked || elementStacked;
                parentGroupElement = groupElement;
                for (groupElement = groupElement.getFirstChildItem(); groupElement != null && !"group".equals(groupElement.getTagName()); groupElement = groupElement.getNextItem()) {
                }
                if (groupElement != null || isStacked) continue;
                parentGroupElement.setAttribute("stacked", Boolean.TRUE.toString());
            }
        }
    }

    public int getMessageCount() {
        return this.messages.size();
    }
}

