/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.data;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.chart.data.FormattableName;
import org.pentaho.chart.data.IChartDataModel;
import org.pentaho.chart.data.XYDataModel;
import org.pentaho.chart.data.XYDataPoint;

public class MultiSeriesXYDataModel
implements IChartDataModel {
    LinkedHashMap<FormattableName, Series> chartData = new LinkedHashMap();

    public void addDataPoint(String seriesKey, Number domainValue, Number rangeValue) {
        this.addDataPoint(seriesKey, null, domainValue, rangeValue);
    }

    public void addDataPoint(String seriesKey, String seriesFormatted, Number domainValue, Number rangeValue) {
        FormattableName seriesName = new FormattableName(seriesKey, seriesFormatted);
        Series seriesData = this.chartData.get(seriesName);
        if (seriesData == null) {
            seriesData = new Series(seriesName);
            this.chartData.put(seriesName, seriesData);
        }
        seriesData.add(new XYDataPoint(domainValue, rangeValue));
    }

    public Series getSeries(String seriesKey) {
        Series seriesData = null;
        Series existingSeriesData = this.chartData.get(new FormattableName(seriesKey));
        if (existingSeriesData != null) {
            seriesData = new Series(existingSeriesData.seriesName);
            seriesData.addAll(existingSeriesData);
        }
        return seriesData;
    }

    public List<Series> getSeries() {
        ArrayList<Series> seriesDataList = new ArrayList<Series>();
        for (Map.Entry<FormattableName, Series> mapEntry : this.chartData.entrySet()) {
            Series series = new Series(mapEntry.getKey());
            series.addAll(mapEntry.getValue());
            seriesDataList.add(series);
        }
        return seriesDataList;
    }

    public class Series
    extends XYDataModel {
        FormattableName seriesName;

        Series() {
        }

        Series(FormattableName seriesName) {
            this.seriesName = seriesName;
        }

        Series(String seriesKey) {
            this.seriesName = new FormattableName(seriesKey);
        }

        public FormattableName getSeriesNameInstance() {
            return this.seriesName;
        }

        public String getSeriesName() {
            return this.seriesName.getKey();
        }

        public String getSeriesFormattedName() {
            return this.seriesName.getFormatted();
        }

        public void setSeriesName(String seriesKey) {
            this.seriesName.setKey(seriesKey);
        }

        public void setSeriesFormattedName(String seriesFormattedName) {
            this.seriesName.setFormatted(seriesFormattedName);
        }
    }
}

