/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.model;

import java.io.Serializable;
import org.pentaho.chart.model.CssStyle;
import org.pentaho.chart.model.Gradient;
import org.pentaho.chart.model.Palette;
import org.pentaho.chart.model.Texture;

public abstract class Plot
implements Serializable {
    public static final Palette DEFAULT_PALETTE = new Palette(26214, 26316, 39321, 0x336699, 0x339966, 0x3399FF, 0x663366, 0x666666, 0x666699, 0x669999, 0x6699CC, 0x66CCCC, 0x993300, 0x990033, 0x999966, 0x999999, 0x9999CC, 0x9999FF, 0x99CC33, 0x99CCCC, 0x99CCFF, 0xCC6600, 0xCC9933, 0xCCCC33, 0xCCCC66, 0xCCCC99, 0xCCCCCC, 0xFF9900, 0xFFCC00, 0xFFCC66);
    Palette palette = new Palette(DEFAULT_PALETTE);
    protected Orientation orientation = Orientation.VERTICAL;
    protected String backgroundImageLocation;
    protected Texture backgroundTexture;
    protected Gradient backgroundGradient;
    protected CssStyle style = new CssStyle();

    public Object getBackground() {
        Object background = null;
        if (this.style.getBackgroundColor() != null) {
            background = this.style.getBackgroundColor();
        } else if (this.backgroundGradient != null) {
            background = this.backgroundGradient;
        } else if (this.backgroundImageLocation != null) {
            background = this.backgroundImageLocation;
        } else if (this.backgroundTexture != null) {
            background = this.backgroundTexture;
        }
        return background;
    }

    public void setBackground(Integer backgroundColor) {
        this.style.setBackgroundColor(backgroundColor);
        if (backgroundColor != null) {
            this.backgroundGradient = null;
            this.backgroundImageLocation = null;
            this.backgroundTexture = null;
        }
    }

    public void setBackground(String backgroundImageLocation) {
        this.backgroundImageLocation = backgroundImageLocation;
        if (backgroundImageLocation != null) {
            this.backgroundGradient = null;
            this.setBackground((Integer)null);
            this.backgroundTexture = null;
        }
    }

    public void setBackground(Gradient backgroundGradient) {
        this.backgroundGradient = backgroundGradient;
        if (backgroundGradient != null) {
            this.setBackground((Integer)null);
            this.backgroundImageLocation = null;
            this.backgroundTexture = null;
        }
    }

    public void setBackground(Texture backgroundTexture) {
        this.backgroundTexture = backgroundTexture;
        if (backgroundTexture != null) {
            this.backgroundGradient = null;
            this.setBackground((Integer)null);
            this.backgroundImageLocation = null;
        }
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public Palette getPalette() {
        return this.palette;
    }

    public void setPalette(Palette colorPalette) {
        this.palette = colorPalette;
    }

    public Float getOpacity() {
        return this.style.getOpacity();
    }

    public void setOpacity(Float opacity) {
        this.style.setOpacity(opacity);
    }

    public CssStyle getStyle() {
        return this.style;
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

