/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.model.util;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.pentaho.chart.model.AreaPlot;
import org.pentaho.chart.model.Axis;
import org.pentaho.chart.model.BarPlot;
import org.pentaho.chart.model.ChartModel;
import org.pentaho.chart.model.ChartTitle;
import org.pentaho.chart.model.CssStyle;
import org.pentaho.chart.model.DialPlot;
import org.pentaho.chart.model.Grid;
import org.pentaho.chart.model.LinePlot;
import org.pentaho.chart.model.NumericAxis;
import org.pentaho.chart.model.Palette;
import org.pentaho.chart.model.PiePlot;
import org.pentaho.chart.model.Plot;
import org.pentaho.chart.model.ScatterPlot;
import org.pentaho.chart.model.StyledText;
import org.pentaho.chart.model.Theme;
import org.pentaho.chart.model.TwoAxisPlot;

public class ChartModelConverter
implements Converter {
    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        ChartModel chartModel = (ChartModel)value;
        if (chartModel.getChartEngineId() != null) {
            writer.addAttribute("chartEngine", chartModel.getChartEngineId());
        }
        if (chartModel.getTheme() != null) {
            writer.addAttribute("theme", chartModel.getTheme().toString());
        }
        if (chartModel.getStyle().size() > 0) {
            writer.addAttribute("style", chartModel.getStyle().getStyleString());
        }
        if (chartModel.getTitle() != null && chartModel.getTitle().getText() != null && chartModel.getTitle().getText().length() > 0) {
            ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)"title", chartModel.getTitle().getClass());
            context.convertAnother((Object)chartModel.getTitle());
            writer.endNode();
        }
        for (StyledText subtitle : chartModel.getSubtitles()) {
            if (subtitle.getText() == null || subtitle.getText().trim().length() <= 0) continue;
            ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)"subtitle", subtitle.getClass());
            context.convertAnother((Object)subtitle);
            writer.endNode();
        }
        if (chartModel.getLegend() != null && chartModel.getLegend().getVisible()) {
            ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)"legend", chartModel.getLegend().getClass());
            context.convertAnother((Object)chartModel.getLegend());
            writer.endNode();
        }
        if (chartModel.getPlot() != null) {
            PiePlot piePlot;
            String plotType = chartModel.getPlot().getClass().getSimpleName();
            plotType = plotType.substring(0, 1).toLowerCase() + plotType.substring(1);
            ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)plotType, chartModel.getPlot().getClass());
            context.convertAnother((Object)chartModel.getPlot());
            if (chartModel.getPlot() instanceof PiePlot && (piePlot = (PiePlot)chartModel.getPlot()).getLabels().getVisible()) {
                ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)"labels", piePlot.getLabels().getClass());
                context.convertAnother((Object)piePlot.getLabels());
                writer.endNode();
            }
            if (chartModel.getPlot() instanceof TwoAxisPlot) {
                TwoAxisPlot twoAxisPlot = (TwoAxisPlot)chartModel.getPlot();
                Axis xAxis = twoAxisPlot.getHorizontalAxis();
                ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)"horizontalAxis", xAxis.getClass());
                context.convertAnother((Object)xAxis);
                writer.endNode();
                Axis yAxis = twoAxisPlot.getVerticalAxis();
                ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)"verticalAxis", yAxis.getClass());
                context.convertAnother((Object)yAxis);
                writer.endNode();
                Grid grid = twoAxisPlot.getGrid();
                if (grid.getVisible()) {
                    ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)"grid", grid.getClass());
                    context.convertAnother((Object)grid);
                    writer.endNode();
                }
            }
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String cssStyle;
        ChartModel chartModel = new ChartModel();
        chartModel.setChartEngineId(reader.getAttribute("chartEngine"));
        String attribute = reader.getAttribute("theme");
        if (attribute != null) {
            try {
                chartModel.setTheme(Enum.valueOf(Theme.ChartTheme.class, attribute.toUpperCase()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((cssStyle = reader.getAttribute("style")) != null) {
            chartModel.getStyle().setStyleString(cssStyle);
        }
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            if (reader.getNodeName().equals("title")) {
                String title = reader.getValue();
                if (title != null) {
                    chartModel.getTitle().setText(title);
                }
                if ((cssStyle = reader.getAttribute("style")) != null) {
                    chartModel.getTitle().getStyle().setStyleString(cssStyle);
                }
                if ((attribute = reader.getAttribute("location")) != null) {
                    try {
                        chartModel.getTitle().setLocation(Enum.valueOf(ChartTitle.TitleLocation.class, attribute.toUpperCase()));
                    }
                    catch (Exception exception) {}
                }
            } else if (reader.getNodeName().equals("subtitle")) {
                String subtitle = reader.getValue();
                if (subtitle != null && subtitle.trim().length() > 0) {
                    StyledText styledText = new StyledText(subtitle);
                    cssStyle = reader.getAttribute("style");
                    if (cssStyle != null) {
                        styledText.getStyle().setStyleString(cssStyle);
                    }
                    chartModel.getSubtitles().add(styledText);
                }
            } else if (reader.getNodeName().equals("legend")) {
                chartModel.getLegend().setVisible(true);
                cssStyle = reader.getAttribute("style");
                if (cssStyle != null) {
                    chartModel.getLegend().getStyle().setStyleString(cssStyle);
                }
            } else if (reader.getNodeName().equals("barPlot") || reader.getNodeName().equals("linePlot") || reader.getNodeName().equals("areaPlot") || reader.getNodeName().equals("piePlot") || reader.getNodeName().equals("dialPlot") || reader.getNodeName().equals("scatterPlot")) {
                chartModel.setPlot(this.createPlot(reader));
            }
            reader.moveUp();
        }
        return chartModel;
    }

    private Plot createPlot(HierarchicalStreamReader reader) {
        String cssStyle;
        String flavor;
        Plot plot = null;
        if (reader.getNodeName().equals("barPlot")) {
            BarPlot barPlot = new BarPlot();
            barPlot.getGrid().setVisible(false);
            flavor = reader.getAttribute("flavor");
            if (flavor != null) {
                try {
                    barPlot.setFlavor(Enum.valueOf(BarPlot.BarPlotFlavor.class, flavor.toUpperCase()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            plot = barPlot;
        } else if (reader.getNodeName().equals("linePlot")) {
            LinePlot linePlot = new LinePlot();
            linePlot.getGrid().setVisible(false);
            flavor = reader.getAttribute("flavor");
            if (flavor != null) {
                try {
                    linePlot.setFlavor(Enum.valueOf(LinePlot.LinePlotFlavor.class, flavor.toUpperCase()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            plot = linePlot;
        } else if (reader.getNodeName().equals("areaPlot")) {
            AreaPlot areaPlot = new AreaPlot();
            areaPlot.getGrid().setVisible(false);
            plot = areaPlot;
        } else if (reader.getNodeName().equals("scatterPlot")) {
            ScatterPlot scatterPlot = new ScatterPlot();
            scatterPlot.getGrid().setVisible(false);
            plot = scatterPlot;
        } else if (reader.getNodeName().equals("piePlot")) {
            PiePlot piePlot = new PiePlot();
            piePlot.getLabels().setVisible(false);
            piePlot.setAnimate(Boolean.parseBoolean(reader.getAttribute("animate")));
            try {
                piePlot.setStartAngle(Integer.parseInt(reader.getAttribute("startAngle")));
            }
            catch (Exception flavor2) {
                // empty catch block
            }
            plot = piePlot;
        } else if (reader.getNodeName().equals("dialPlot")) {
            DialPlot dialPlot = new DialPlot();
            dialPlot.setAnimate(Boolean.parseBoolean(reader.getAttribute("animate")));
            plot = dialPlot;
        }
        String orientation = reader.getAttribute("orientation");
        if (orientation != null) {
            try {
                plot.setOrientation(Enum.valueOf(Plot.Orientation.class, orientation.toUpperCase()));
            }
            catch (Exception flavor2) {
                // empty catch block
            }
        }
        if ((cssStyle = reader.getAttribute("style")) != null) {
            plot.getStyle().setStyleString(cssStyle);
        }
        while (reader.hasMoreChildren()) {
            TwoAxisPlot twoAxisPlot;
            reader.moveDown();
            if (reader.getNodeName().equals("palette")) {
                CssStyle paintStyle = new CssStyle();
                Palette palette = new Palette();
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    if (reader.getNodeName().equals("paint") && (cssStyle = reader.getAttribute("style")) != null) {
                        paintStyle.setStyleString(cssStyle);
                        Integer color = paintStyle.getColor();
                        if (color != null) {
                            palette.add(color);
                        }
                    }
                    reader.moveUp();
                }
                if (palette.size() > 0) {
                    plot.setPalette(palette);
                }
            }
            if ((reader.getNodeName().equals("verticalAxis") || reader.getNodeName().equals("horizontalAxis")) && plot instanceof TwoAxisPlot) {
                twoAxisPlot = (TwoAxisPlot)plot;
                Axis axis = reader.getNodeName().equals("verticalAxis") ? twoAxisPlot.getVerticalAxis() : twoAxisPlot.getHorizontalAxis();
                String axisLabelOrientation = reader.getAttribute("labelOrientation");
                try {
                    axis.setLabelOrientation(Enum.valueOf(Axis.LabelOrientation.class, axisLabelOrientation.toUpperCase()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (axis instanceof NumericAxis) {
                    String maxValueStr;
                    NumericAxis numericAxis = (NumericAxis)axis;
                    String minValueStr = reader.getAttribute("minValue");
                    if (minValueStr != null) {
                        try {
                            numericAxis.setMinValue(Integer.parseInt(minValueStr));
                        }
                        catch (NumberFormatException ex) {
                            try {
                                numericAxis.setMinValue(Double.parseDouble(minValueStr));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    if ((maxValueStr = reader.getAttribute("maxValue")) != null && maxValueStr != null) {
                        try {
                            numericAxis.setMaxValue(Integer.parseInt(maxValueStr));
                        }
                        catch (NumberFormatException ex) {
                            try {
                                numericAxis.setMaxValue(Double.parseDouble(maxValueStr));
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                }
                if ((cssStyle = reader.getAttribute("style")) != null) {
                    axis.getStyle().setStyleString(cssStyle);
                }
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    String legend = reader.getValue();
                    if (legend != null) {
                        axis.getLegend().setText(legend);
                    }
                    if ((cssStyle = reader.getAttribute("style")) != null) {
                        axis.getLegend().getStyle().setStyleString(cssStyle);
                    }
                    reader.moveUp();
                }
            }
            if (reader.getNodeName().equals("grid") && plot instanceof TwoAxisPlot) {
                twoAxisPlot = (TwoAxisPlot)plot;
                Grid grid = twoAxisPlot.getGrid();
                grid.setVisible(true);
                while (reader.hasMoreChildren()) {
                    reader.moveDown();
                    if (reader.getNodeName().equals("verticalLines")) {
                        cssStyle = reader.getAttribute("style");
                        if (cssStyle != null) {
                            grid.getVerticalLineStyle().setStyleString(cssStyle);
                        }
                    } else if (reader.getNodeName().equals("horizontalLines") && (cssStyle = reader.getAttribute("style")) != null) {
                        grid.getHorizontalLineStyle().setStyleString(cssStyle);
                    }
                    reader.moveUp();
                }
            }
            if (reader.getNodeName().equals("scale") && plot instanceof DialPlot) {
                while (reader.hasMoreChildren()) {
                    CssStyle rangeStyle = new CssStyle();
                    Integer color = null;
                    Double rangeMin = null;
                    Double rangeMax = null;
                    reader.moveDown();
                    if (reader.getNodeName().equals("range")) {
                        String str;
                        cssStyle = reader.getAttribute("style");
                        if (cssStyle != null) {
                            rangeStyle.setStyleString(cssStyle);
                            color = rangeStyle.getColor();
                        }
                        if ((str = reader.getAttribute("min")) != null) {
                            rangeMin = new Double(str);
                        }
                        if ((str = reader.getAttribute("max")) != null) {
                            rangeMax = new Double(str);
                        }
                        ((DialPlot)plot).getScale().addRange(new DialPlot.DialRange(rangeMin, rangeMax, color));
                    }
                    reader.moveUp();
                }
            }
            if (reader.getNodeName().equals("labels") && plot instanceof PiePlot) {
                PiePlot piePlot = (PiePlot)plot;
                piePlot.getLabels().setVisible(true);
                cssStyle = reader.getAttribute("style");
                if (cssStyle != null) {
                    piePlot.getLabels().getStyle().setStyleString(cssStyle);
                }
            }
            if (reader.getNodeName().equals("annotation") && plot instanceof DialPlot) {
                DialPlot dialPlot = (DialPlot)plot;
                String annotation = reader.getValue();
                if (annotation != null) {
                    dialPlot.getAnnotation().setText(annotation);
                }
                if ((cssStyle = reader.getAttribute("style")) != null) {
                    dialPlot.getAnnotation().getStyle().setStyleString(cssStyle);
                }
            }
            reader.moveUp();
        }
        return plot;
    }

    public boolean canConvert(Class clazz) {
        return clazz.equals(ChartModel.class);
    }
}

