/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.api;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.data.category.CategoryDataset;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.css.keys.ChartStyleKeys;
import org.pentaho.chart.data.ChartTableModel;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.font.FontStyleKeys;
import org.pentaho.reporting.libraries.css.keys.font.FontVariant;
import org.pentaho.reporting.libraries.css.values.CSSStringValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public class ChartItemLabelGenerator
extends StandardCategoryItemLabelGenerator {
    private ChartElement[] chartElements;
    private Map<Integer, ChartElement> map;
    private Map<String, Integer> columnPositions;
    private static final long serialVersionUID = -1787452968861210575L;

    public ChartItemLabelGenerator(ChartElement[] chartElements, ChartTableModel chartData) {
        this.chartElements = chartElements;
        this.map = new HashMap<Integer, ChartElement>();
        this.columnPositions = new HashMap<String, Integer>();
        this.mapSeriesToColumnNumber();
        if (chartData != null) {
            for (int i = 0; i < chartData.getColumnCount(); ++i) {
                String columnName = chartData.getColumnName(i);
                this.columnPositions.put(columnName, i);
            }
        }
    }

    public String generateLabel(CategoryDataset dataset, int row, int column) {
        if (dataset == null) {
            return null;
        }
        try {
            ChartElement ce;
            Number data = dataset.getValue(row, column);
            if (data != null && (ce = this.map.get(column)) != null) {
                LayoutStyle layoutStyle = ce.getLayoutStyle();
                String messageFormat = ((CSSStringValue)layoutStyle.getValue(ChartStyleKeys.ITEM_LABEL_TEXT)).getValue();
                String result = MessageFormat.format(messageFormat, data, dataset.getColumnKey(column));
                CSSValue variant = layoutStyle.getValue(FontStyleKeys.FONT_VARIANT);
                if (FontVariant.SMALL_CAPS.equals((Object)variant)) {
                    result = result.toUpperCase();
                }
                return result;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    private void mapSeriesToColumnNumber() {
        if (this.chartElements != null) {
            for (int i = 0; i < this.chartElements.length; ++i) {
                ChartElement element = this.chartElements[i];
                int columnNum = this.getSeriesColumn(element, i);
                this.map.put(columnNum, element);
            }
        }
    }

    private int getSeriesColumn(ChartElement seriesElement, int columnDefault) {
        int column = columnDefault;
        if (seriesElement != null) {
            Object positionAttr = seriesElement.getAttribute("column-pos");
            if (positionAttr != null) {
                column = Integer.parseInt(positionAttr.toString());
            } else {
                positionAttr = seriesElement.getAttribute("column-name");
                if (positionAttr != null) {
                    column = this.lookupPosition(positionAttr.toString());
                }
            }
        }
        return column;
    }

    private int lookupPosition(String columnName) {
        Integer integer = this.columnPositions.get(columnName.toLowerCase());
        if (integer == null) {
            return -1;
        }
        return integer;
    }
}

