/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.jfreechart.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Arrays;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.GroupedStackedBarRenderer;
import org.jfree.chart.renderer.category.LayeredBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.jfree.ui.TextAnchor;
import org.pentaho.chart.ChartDocumentContext;
import org.pentaho.chart.ChartUtils;
import org.pentaho.chart.core.AxisSeriesLinkInfo;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.core.ChartSeriesDataLinkInfo;
import org.pentaho.chart.css.keys.ChartStyleKeys;
import org.pentaho.chart.css.styles.ChartAxisLocationType;
import org.pentaho.chart.css.styles.ChartOrientationStyle;
import org.pentaho.chart.data.ChartTableModel;
import org.pentaho.chart.plugin.api.ChartItemLabelGenerator;
import org.pentaho.chart.plugin.jfreechart.chart.IJFreeChartGenerator;
import org.pentaho.chart.plugin.jfreechart.dataset.DatasetGeneratorFactory;
import org.pentaho.chart.plugin.jfreechart.utils.ColorFactory;
import org.pentaho.chart.plugin.jfreechart.utils.CylinderRenderer;
import org.pentaho.chart.plugin.jfreechart.utils.JFreeChartUtils;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.border.BorderStyleKeys;
import org.pentaho.reporting.libraries.css.keys.color.ColorStyleKeys;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSStringValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;

public abstract class JFreeChartGenerator
implements IJFreeChartGenerator {
    protected final DatasetGeneratorFactory datasetGeneratorFactory = new DatasetGeneratorFactory();

    public static String getTitle(ChartDocument chartDocument) {
        ChartElement[] children = chartDocument.getRootElement().findChildrenByName("title");
        if (children != null && children.length > 0) {
            return children[0].getText();
        }
        return null;
    }

    public static boolean getShowToolTips(ChartDocument chartDocument) {
        return true;
    }

    public static String getValueCategoryLabel(ChartDocument chartDocument) {
        ChartElement[] children = chartDocument.getRootElement().findChildrenByName("domainLabel");
        if (children != null && children.length > 0) {
            return children[0].getText();
        }
        return null;
    }

    public static String getValueAxisLabel(ChartDocument chartDocument) {
        ChartElement[] children = chartDocument.getRootElement().findChildrenByName("rangeLabel");
        if (children != null && children.length > 0) {
            return children[0].getText();
        }
        return null;
    }

    public static boolean getShowLegend(ChartDocument chartDocument) {
        ChartElement[] children = chartDocument.getRootElement().findChildrenByName("legend");
        return children != null && children.length > 0;
    }

    public PlotOrientation getPlotOrientation(ChartDocument chartDocument) {
        PlotOrientation plotOrient = null;
        ChartElement plotElement = chartDocument.getPlotElement();
        if (plotElement != null) {
            LayoutStyle layoutStyle = plotElement.getLayoutStyle();
            CSSValue value = layoutStyle.getValue(ChartStyleKeys.ORIENTATION);
            if (ChartOrientationStyle.VERTICAL.equals((Object)value)) {
                plotOrient = PlotOrientation.VERTICAL;
            } else if (ChartOrientationStyle.HORIZONTAL.equals((Object)value)) {
                plotOrient = PlotOrientation.HORIZONTAL;
            }
        }
        return plotOrient;
    }

    public Integer[] getColumPositions(ChartDocumentContext chartDocContext, ChartElement axisElement, AxisSeriesLinkInfo axisSeriesLinkInfo) {
        ArrayList<ChartElement> seriesElementsList;
        ChartSeriesDataLinkInfo seriesDataLinkInfo;
        Object axisID = axisElement.getAttribute("id");
        Object[] columnPosArr = null;
        if (axisSeriesLinkInfo != null && axisID != null && (seriesDataLinkInfo = chartDocContext.getDataLinkInfo()) != null && (seriesElementsList = axisSeriesLinkInfo.getSeriesElements(axisID)) != null) {
            int size = seriesElementsList.size();
            ArrayList<Integer> columnPosList = new ArrayList<Integer>();
            for (int i = 0; i < size; ++i) {
                ChartElement seriesElement = seriesElementsList.get(i);
                Integer columnPos = seriesDataLinkInfo.getColumnNum(seriesElement);
                columnPosList.add(columnPos);
            }
            int listLength = columnPosList.size();
            columnPosArr = new Integer[listLength];
            System.arraycopy(columnPosList.toArray(), 0, columnPosArr, 0, listLength);
            Arrays.sort(columnPosArr);
        }
        return columnPosArr;
    }

    private void setRangeAxisLocation(CategoryPlot plot, ChartElement axisElement, int axisCounter) {
        CSSValue cssValue = axisElement.getLayoutStyle().getValue(ChartStyleKeys.AXIS_LOCATION);
        String side = cssValue.getCSSText();
        if (side != null && cssValue.equals(ChartAxisLocationType.PRIMARY)) {
            plot.setRangeAxisLocation(axisCounter, AxisLocation.BOTTOM_OR_LEFT);
        } else {
            plot.setRangeAxisLocation(axisCounter, AxisLocation.TOP_OR_RIGHT);
        }
    }

    private void setAxisColor(ChartElement axisElement, ValueAxis valueAxis, String labelType) {
        CSSValue colorCSSValue;
        Color axisLabelColor;
        ChartElement[] labelElements = axisElement.findChildrenByName(labelType);
        if (labelElements != null && labelElements.length > 0 && (axisLabelColor = JFreeChartUtils.getColorFromCSSValue(colorCSSValue = labelElements[0].getLayoutStyle().getValue(ColorStyleKeys.COLOR))) != null) {
            if ("label".equalsIgnoreCase(labelType)) {
                valueAxis.setLabelPaint((Paint)axisLabelColor);
            } else if ("ticklabel".equalsIgnoreCase(labelType)) {
                valueAxis.setTickLabelPaint((Paint)axisLabelColor);
            }
        }
    }

    public void createRangeAxis(ChartDocumentContext chartDocContext, ChartTableModel data, JFreeChart chart) {
        ChartDocument chartDocument = chartDocContext.getChartDocument();
        AxisSeriesLinkInfo axisSeriesLinkInfo = chartDocument.getAxisSeriesLinkInfo();
        ArrayList<ChartElement> rangeAxisArrayList = axisSeriesLinkInfo.getRangeAxisElements();
        int rangeAxisCount = rangeAxisArrayList.size();
        if (chart != null && rangeAxisCount > 0) {
            CategoryPlot plot = (CategoryPlot)chart.getPlot();
            for (int i = 0; i < rangeAxisCount; ++i) {
                ValueAxis valueAxis;
                ChartElement axisElement = rangeAxisArrayList.get(i);
                if (rangeAxisCount > 1) {
                    Integer[] columnPosArr = this.getColumPositions(chartDocContext, axisElement, axisSeriesLinkInfo);
                    DefaultCategoryDataset currDataset = this.datasetGeneratorFactory.createDefaultCategoryDataset(chartDocContext, data, columnPosArr);
                    plot.setDataset(i, (CategoryDataset)currDataset);
                    plot.mapDatasetToRangeAxis(i, i);
                }
                if ((valueAxis = this.createRangeAxis(axisElement)) == null) continue;
                plot.setRangeAxis(i, valueAxis);
                this.setAxisColor(axisElement, valueAxis, "label");
                this.setAxisColor(axisElement, valueAxis, "ticklabel");
                this.setRangeAxisLocation(plot, axisElement, i);
                this.setRenderer(plot, i);
            }
        }
    }

    private ValueAxis createRangeAxis(ChartElement axisElement) {
        String axisLabel = (String)axisElement.getAttribute("label");
        NumberAxis valueAxis = axisLabel != null ? new NumberAxis(axisLabel) : new NumberAxis();
        return valueAxis;
    }

    private void setRenderer(CategoryPlot plot, int index) {
        if (!(plot.getRenderer() instanceof GroupedStackedBarRenderer || plot.getRenderer() instanceof CylinderRenderer || plot.getRenderer() instanceof BarRenderer3D || plot.getRenderer() instanceof LayeredBarRenderer)) {
            if (plot.getRenderer() instanceof BarRenderer) {
                BarRenderer barRenderer = new BarRenderer();
                plot.setRenderer(index, (CategoryItemRenderer)barRenderer);
            } else if (plot.getRenderer() instanceof AreaRenderer) {
                AreaRenderer areaRenderer = new AreaRenderer();
                plot.setRenderer(index, (CategoryItemRenderer)areaRenderer);
            }
        }
    }

    protected void setSeriesPaint(CategoryPlot categoryPlot, ChartElement[] seriesElements, ChartTableModel data) {
        StandardGradientPaintTransformer st = null;
        int length = seriesElements.length;
        for (int i = 0; i < length; ++i) {
            ChartElement seriesElement = seriesElements[i];
            Paint paint = this.getPaintFromSeries(seriesElement);
            if (paint == null) continue;
            int column = JFreeChartUtils.getSeriesColumn(seriesElement, data, i);
            int datasetCount = categoryPlot.getDatasetCount();
            for (int datasetCounter = 0; datasetCounter < datasetCount; ++datasetCounter) {
                categoryPlot.getRenderer(datasetCounter).setSeriesPaint(column, paint);
            }
            if (st != null) continue;
            st = JFreeChartUtils.getStandardGradientPaintTrans(seriesElements[i]);
            float barWidthPercent = JFreeChartUtils.getMaximumBarWidth(seriesElements[i]);
            for (int datasetCounter = 0; datasetCounter < datasetCount; ++datasetCounter) {
                CategoryItemRenderer itemRenderer = categoryPlot.getRenderer(datasetCounter);
                if (!(itemRenderer instanceof BarRenderer)) continue;
                BarRenderer barRender = (BarRenderer)categoryPlot.getRenderer(datasetCounter);
                barRender.setGradientPaintTransformer((GradientPaintTransformer)st);
                if (!(barWidthPercent > 0.0f)) continue;
                barRender.setMaximumBarWidth((double)barWidthPercent);
            }
        }
    }

    protected void setSeriesItemLabel(CategoryPlot categoryPlot, ChartElement[] seriesElements, ChartTableModel data) {
        int numOfDatasets = categoryPlot.getDatasetCount();
        for (int datasetCounter = 0; datasetCounter < numOfDatasets; ++datasetCounter) {
            categoryPlot.getRenderer(datasetCounter).setBaseItemLabelGenerator((CategoryItemLabelGenerator)new ChartItemLabelGenerator(seriesElements, data));
            int numOfSeriesElements = seriesElements.length;
            for (int seriesCounter = 0; seriesCounter < numOfSeriesElements; ++seriesCounter) {
                if (!JFreeChartUtils.showItemLabel(seriesElements[seriesCounter])) continue;
                Font font = JFreeChartUtils.getFont(seriesElements[seriesCounter]);
                CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer(datasetCounter);
                if (categoryItemRenderer instanceof BarRenderer) {
                    BarRenderer barRender = (BarRenderer)categoryItemRenderer;
                    barRender.setSeriesItemLabelFont(seriesCounter, font, true);
                    barRender.setSeriesItemLabelsVisible(seriesCounter, Boolean.TRUE, true);
                    continue;
                }
                if (!(categoryItemRenderer instanceof AreaRenderer)) continue;
                AreaRenderer areaRender = (AreaRenderer)categoryItemRenderer;
                areaRender.setSeriesItemLabelFont(seriesCounter, font, true);
                areaRender.setSeriesPositiveItemLabelPosition(seriesCounter, new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.TOP_CENTER));
                areaRender.setSeriesNegativeItemLabelPosition(seriesCounter, new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.BOTTOM_CENTER));
                areaRender.setSeriesItemLabelsVisible(seriesCounter, Boolean.TRUE, true);
            }
        }
    }

    public Paint getPaintFromSeries(ChartElement seriesElement) {
        CSSValue cssValue = seriesElement.getLayoutStyle().getValue(ChartStyleKeys.GRADIENT_TYPE);
        String gradientType = cssValue != null ? cssValue.getCSSText() : null;
        Paint paint = gradientType != null && !gradientType.equalsIgnoreCase("none") ? JFreeChartUtils.getGradientPaint(seriesElement) : (Paint)seriesElement.getLayoutStyle().getValue(ColorStyleKeys.COLOR);
        return paint;
    }

    @Override
    public JFreeChart createChart(ChartDocumentContext chartDocContext, ChartTableModel data) {
        Plot plot;
        CSSValue borderWidth;
        Font font;
        ChartElement rootElement;
        ChartElement[] children;
        CSSNumericValue opacity;
        JFreeChart chart = this.doCreateChart(chartDocContext, data);
        chart.setBackgroundPaint((Paint)this.getChartBackgroundColor(chartDocContext.getChartDocument()));
        Color chartBackgroundPaint = ColorFactory.getInstance().getColor(chartDocContext.getChartDocument().getPlotElement(), BorderStyleKeys.BACKGROUND_COLOR);
        if (chartBackgroundPaint != null) {
            chart.getPlot().setBackgroundPaint((Paint)chartBackgroundPaint);
        }
        if ((opacity = (CSSNumericValue)chartDocContext.getChartDocument().getPlotElement().getLayoutStyle().getValue(ColorStyleKeys.OPACITY)) != null) {
            chart.getPlot().setForegroundAlpha((float)opacity.getValue());
        }
        if ((children = (rootElement = chartDocContext.getChartDocument().getRootElement()).findChildrenByName("title")) != null && children.length > 0 && (font = ChartUtils.getFont(children[0])) != null) {
            chart.getTitle().setFont(font);
        }
        if (JFreeChartGenerator.getShowLegend(chartDocContext.getChartDocument()) && (children = chartDocContext.getChartDocument().getRootElement().findChildrenByName("legend")) != null && children.length > 0) {
            CSSNumericValue value;
            ChartElement legendElement = children[0];
            Font font2 = JFreeChartUtils.getFont(legendElement);
            if (font2 != null) {
                chart.getLegend().setItemFont(font2);
            }
            if ((value = (CSSNumericValue)legendElement.getLayoutStyle().getValue(BorderStyleKeys.BORDER_TOP_WIDTH)) == null || value.getValue() <= 0.0) {
                chart.getLegend().setBorder(BlockBorder.NONE);
            }
        }
        if ((borderWidth = rootElement.getLayoutStyle().getValue(BorderStyleKeys.BORDER_TOP_WIDTH)) != null && borderWidth instanceof CSSNumericValue && ((CSSNumericValue)borderWidth).getValue() > 0.0) {
            chart.setBorderVisible(true);
        } else if (borderWidth != null && borderWidth instanceof CSSStringValue) {
            chart.setBorderVisible(true);
        }
        Color borderColor = ColorFactory.getInstance().getColor(rootElement, BorderStyleKeys.BORDER_TOP_COLOR);
        if (borderColor != null) {
            chart.setBorderPaint((Paint)borderColor);
        }
        if ((plot = chart.getPlot()) instanceof CategoryPlot) {
            Font font3;
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            children = chartDocContext.getChartDocument().getRootElement().findChildrenByName("rangeLabel");
            if (children != null && children.length > 0 && (font3 = ChartUtils.getFont(children[0])) != null) {
                categoryPlot.getRangeAxis().setLabelFont(font3);
            }
            if ((children = chartDocContext.getChartDocument().getRootElement().findChildrenByName("domainLabel")) != null && children.length > 0 && (font3 = ChartUtils.getFont(children[0])) != null) {
                categoryPlot.getDomainAxis().setLabelFont(font3);
            }
        }
        return chart;
    }

    protected Color getChartBackgroundColor(ChartDocument chartDoc) {
        Color chartBackgroundPaint = Color.white;
        ChartElement rootElement = chartDoc.getRootElement();
        Color chartBackgroundPaintTmp = ColorFactory.getInstance().getColor(rootElement, BorderStyleKeys.BACKGROUND_COLOR);
        if (!Color.black.equals(chartBackgroundPaintTmp)) {
            chartBackgroundPaint = chartBackgroundPaintTmp;
        }
        return chartBackgroundPaint;
    }

    protected abstract JFreeChart doCreateChart(ChartDocumentContext var1, ChartTableModel var2);
}

