/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.jfreechart.chart.pie;

import java.awt.Font;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.pentaho.chart.ChartDocumentContext;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.css.keys.ChartStyleKeys;
import org.pentaho.chart.css.styles.ChartItemLabelVisibleType;
import org.pentaho.chart.data.ChartTableModel;
import org.pentaho.chart.plugin.jfreechart.chart.JFreeChartGenerator;
import org.pentaho.chart.plugin.jfreechart.utils.JFreeChartUtils;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSStringValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.util.messages.Messages;

public class JFreePieChartGenerator
extends JFreeChartGenerator {
    private static final Log logger = LogFactory.getLog(JFreePieChartGenerator.class);

    @Override
    protected JFreeChart doCreateChart(ChartDocumentContext chartDocContext, ChartTableModel data) {
        ChartDocument chartDocument = chartDocContext.getChartDocument();
        String title = JFreePieChartGenerator.getTitle(chartDocument);
        boolean legend = JFreePieChartGenerator.getShowLegend(chartDocument);
        boolean toolTips = JFreePieChartGenerator.getShowToolTips(chartDocument);
        DefaultPieDataset defaultPieDataset = this.datasetGeneratorFactory.createDefaultPieDataset(chartDocContext, data);
        if (defaultPieDataset == null) {
            logger.error((Object)Messages.getErrorString("JFreeChartFactoryEngine.ERROR_0001_DATASET_IS_NULL"));
            return null;
        }
        JFreeChart chart = ChartFactory.createPieChart((String)title, (PieDataset)defaultPieDataset, (boolean)legend, (boolean)toolTips, (boolean)false);
        PiePlot piePlot = (PiePlot)chart.getPlot();
        this.setPlotAttributes(piePlot, chartDocument, data);
        return chart;
    }

    private void setPlotAttributes(PiePlot piePlot, ChartDocument chartDocument, ChartTableModel data) {
        piePlot.setNoDataMessage("No data available");
        piePlot.setCircular(false);
        piePlot.setLabelGap(0.02);
        ChartElement plotElement = chartDocument.getPlotElement();
        this.setLabelPlacingInsideChart(piePlot, plotElement);
        this.setSeriesAttributes(piePlot, chartDocument, data);
        this.setStartAngle(piePlot, chartDocument.getPlotElement());
    }

    private void setSeriesAttributes(PiePlot piePlot, ChartDocument chartDocument, ChartTableModel data) {
        ChartElement[] seriesElements = chartDocument.getRootElement().findChildrenByName("series");
        this.setSeriesPaint(piePlot, seriesElements, data);
        this.setLabelFont(piePlot, seriesElements);
        this.setExplode(piePlot, seriesElements, data);
        this.generateSectionLabels(piePlot, seriesElements);
    }

    private void setSeriesPaint(PiePlot plot, ChartElement[] seriesElements, ChartTableModel data) {
        int length = seriesElements.length;
        for (int i = 0; i < length; ++i) {
            String rowName;
            ChartElement seriesElement = seriesElements[i];
            Paint paint = this.getPaintFromSeries(seriesElement);
            if (paint == null || (rowName = data.getRowName(i)) == null) continue;
            plot.setSectionPaint((Comparable)((Object)rowName), paint);
        }
    }

    private void setLabelFont(PiePlot piePlot, ChartElement[] seriesElements) {
        for (ChartElement seriesElement : seriesElements) {
            Font font = JFreeChartUtils.getFont(seriesElement);
            if (font == null) continue;
            piePlot.setLabelFont(font);
            break;
        }
    }

    private void generateSectionLabels(PiePlot piePlot, ChartElement[] seriesElements) {
        int length = seriesElements.length;
        StandardPieSectionLabelGenerator generator = null;
        for (int i = 0; i < length; ++i) {
            String messageFormat;
            ChartElement seriesElement = seriesElements[i];
            LayoutStyle layoutStyle = seriesElement.getLayoutStyle();
            CSSValue cssValue = layoutStyle.getValue(ChartStyleKeys.ITEM_LABEL_TEXT);
            String string = messageFormat = cssValue != null ? ((CSSStringValue)cssValue).getValue() : null;
            if (messageFormat != null) {
                generator = new StandardPieSectionLabelGenerator(messageFormat, (NumberFormat)new DecimalFormat("0.00"), (NumberFormat)new DecimalFormat("0.00%"));
                break;
            }
            generator = new StandardPieSectionLabelGenerator();
        }
        if (generator != null) {
            piePlot.setLabelGenerator(generator);
        }
    }

    private void setLabelPlacingInsideChart(PiePlot piePlot, ChartElement plotElement) {
        LayoutStyle layoutStyle = plotElement.getLayoutStyle();
        CSSValue inside = layoutStyle.getValue(ChartStyleKeys.PIE_LABELS_INSIDE_CHART);
        if (ChartItemLabelVisibleType.VISIBLE.equals((Object)inside)) {
            piePlot.setSimpleLabels(true);
        }
    }

    private void setStartAngle(PiePlot piePlot, ChartElement plotElement) {
        LayoutStyle layoutStyle = plotElement.getLayoutStyle();
        CSSValue startAngle = layoutStyle.getValue(ChartStyleKeys.PIE_START_ANGLE);
        if (startAngle instanceof CSSNumericValue) {
            piePlot.setStartAngle(((CSSNumericValue)startAngle).getValue());
        }
    }

    private void setExplode(PiePlot piePlot, ChartElement[] seriesElements, ChartTableModel data) {
        int length = seriesElements.length;
        for (int i = 0; i < length; ++i) {
            int rowPos;
            String key;
            double percent;
            ChartElement seriesElement = seriesElements[i];
            LayoutStyle layoutStyle = seriesElement.getLayoutStyle();
            CSSValue pieExplodePercent = layoutStyle.getValue(ChartStyleKeys.PIE_EXPLODE_PERCENT);
            if (pieExplodePercent == null) continue;
            String percentStr = pieExplodePercent.getCSSText();
            percentStr = percentStr.substring(0, percentStr.indexOf("%"));
            try {
                percent = Double.parseDouble(percentStr) / 100.0;
            }
            catch (NumberFormatException ne) {
                logger.warn((Object)Messages.getString("JFreePieChartGenerator.WARN_EXPLODE_PERCENT_NOT_DEFINED_CORRECTLY", percentStr, null));
                percent = 0.1;
            }
            if (!(percent > 0.0) || (key = data.getRowName(rowPos = JFreeChartUtils.getSeriesRow(seriesElement, i))) == null) continue;
            piePlot.setExplodePercent((Comparable)((Object)key), percent);
        }
    }
}

