/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.jfreechart.dataset;

import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;
import org.pentaho.chart.ChartBoot;
import org.pentaho.chart.ChartDocumentContext;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.data.ChartTableModel;
import org.pentaho.chart.plugin.jfreechart.dataset.IJFreeDatasetGenerator;
import org.pentaho.chart.plugin.jfreechart.utils.JFreeChartUtils;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class JFreeDefaultCategoryDatasetGenerator
implements IJFreeDatasetGenerator,
Dataset {
    public DefaultCategoryDataset createDataset(ChartDocumentContext chartDocContext, ChartTableModel data) {
        return this.createDefaultCategoryDataset(chartDocContext, data, null);
    }

    public DefaultCategoryDataset createDataset(ChartDocumentContext chartDocContext, ChartTableModel data, Integer[] columnPosArr) {
        return this.createDefaultCategoryDataset(chartDocContext, data, columnPosArr);
    }

    private DefaultCategoryDataset createDefaultCategoryDataset(ChartDocumentContext chartDocContext, ChartTableModel data, Integer[] columnIndexArr) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        int rowCount = data.getRowCount();
        int colCount = data.getColumnCount();
        Configuration config = ChartBoot.getInstance().getGlobalConfig();
        String noRowNameSpecified = config.getConfigProperty("org.pentaho.chart.namespace.row_name_not_defined");
        String noColumnName = config.getConfigProperty("org.pentaho.chart.namespace.column_name_not_defined");
        ChartDocument chartDocument = chartDocContext.getChartDocument();
        double scale = JFreeChartUtils.getScale(chartDocument);
        if (columnIndexArr != null) {
            int columnIndexArrLength = columnIndexArr.length;
            for (int row = 0; row < rowCount; ++row) {
                int columnIndexArrCounter = 0;
                for (int column = 0; column < colCount && columnIndexArrCounter < columnIndexArrLength; ++column) {
                    if (column != columnIndexArr[columnIndexArrCounter]) continue;
                    this.updateDatasetBasedOnScale(chartDocument, data, dataset, row, column, noRowNameSpecified, noColumnName, scale);
                    ++columnIndexArrCounter;
                }
            }
        } else {
            for (int row = 0; row < rowCount; ++row) {
                for (int column = 0; column < colCount; ++column) {
                    this.updateDatasetBasedOnScale(chartDocument, data, dataset, row, column, noRowNameSpecified, noColumnName, scale);
                }
            }
        }
        return dataset;
    }

    private void updateDatasetBasedOnScale(ChartDocument chartDocument, ChartTableModel data, DefaultCategoryDataset dataset, int row, int column, String noRowNameSpecified, String noColumnName, double scale) {
        String rawColumnName = JFreeChartUtils.getColumnName(data, column);
        String columnName = rawColumnName != null ? rawColumnName : noColumnName + column;
        Object rawRowName = JFreeChartUtils.getRawRowName(data, chartDocument, row);
        String rowName = rawRowName != null ? String.valueOf(rawRowName) : noRowNameSpecified + row;
        Object rawValue = data.getValueAt(row, column);
        if (rawValue instanceof Number) {
            Number number = (Number)rawValue;
            double value = number.doubleValue();
            dataset.setValue(value *= scale, (Comparable)((Object)rowName), (Comparable)((Object)columnName));
        }
    }

    public void addChangeListener(DatasetChangeListener datasetChangeListener) {
    }

    public void removeChangeListener(DatasetChangeListener datasetChangeListener) {
    }

    public DatasetGroup getGroup() {
        return null;
    }

    public void setGroup(DatasetGroup datasetGroup) {
    }
}

