/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.jfreechart.dataset;

import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;
import org.pentaho.chart.ChartBoot;
import org.pentaho.chart.ChartDocumentContext;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.data.ChartTableModel;
import org.pentaho.chart.plugin.jfreechart.dataset.IJFreeDatasetGenerator;
import org.pentaho.chart.plugin.jfreechart.utils.JFreeChartUtils;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class JFreeDefaultPieDatasetGenerator
implements IJFreeDatasetGenerator {
    @Override
    public Dataset createDataset(ChartDocumentContext chartDocContext, ChartTableModel data) {
        DefaultPieDataset dataset = new DefaultPieDataset();
        int rowCount = data.getRowCount();
        Configuration config = ChartBoot.getInstance().getGlobalConfig();
        String noRowNameSpecified = config.getConfigProperty("org.pentaho.chart.namespace.row_name_not_defined");
        ChartDocument chartDocument = chartDocContext.getChartDocument();
        double scale = JFreeChartUtils.getScale(chartDocument);
        for (int row = 0; row < rowCount; ++row) {
            Object rawRowName = JFreeChartUtils.getRawRowName(data, chartDocument, row);
            this.updateDatasetBasedOnScale(data, dataset, row, rawRowName, noRowNameSpecified, scale);
        }
        return dataset;
    }

    private void updateDatasetBasedOnScale(ChartTableModel data, DefaultPieDataset dataset, int row, Object rawRowName, String noRowNameSpecified, double scale) {
        String rowName = rawRowName != null ? String.valueOf(rawRowName) : noRowNameSpecified + row;
        Object rawValue = data.getValueAt(row, 0);
        if (rawValue instanceof Number) {
            Number number = (Number)rawValue;
            double value = number.doubleValue();
            dataset.setValue((Comparable)((Object)rowName), value *= scale);
        }
    }

    @Override
    public Dataset createDataset(ChartDocumentContext chartDocContext, ChartTableModel data, Integer[] columnPosArr) {
        return null;
    }
}

