/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.jfreechart.outputs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.pentaho.chart.plugin.api.IOutput;
import org.pentaho.chart.plugin.api.PersistenceException;

public class JFreeChartOutput
implements IOutput {
    private JFreeChart chart;
    private ChartRenderingInfo info;

    public JFreeChartOutput(JFreeChart chart) {
        if (chart == null) {
            throw new NullPointerException();
        }
        this.chart = chart;
    }

    @Override
    public OutputStream persistChart(OutputStream outputStream, IOutput.OutputTypes fileType, int width, int height) throws PersistenceException {
        this.info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
        if (outputStream == null) {
            outputStream = new ByteArrayOutputStream();
        }
        try {
            outputStream.flush();
        }
        catch (IOException e1) {
            throw new PersistenceException(e1);
        }
        if (fileType == IOutput.OutputTypes.FILE_TYPE_JPEG) {
            try {
                ChartUtilities.writeChartAsJPEG((OutputStream)outputStream, (JFreeChart)this.chart, (int)width, (int)height, (ChartRenderingInfo)this.info);
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        if (fileType == IOutput.OutputTypes.FILE_TYPE_PNG || fileType == null) {
            try {
                ChartUtilities.writeChartAsPNG((OutputStream)outputStream, (JFreeChart)this.chart, (int)width, (int)height, (ChartRenderingInfo)this.info);
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        return outputStream;
    }

    @Override
    public Writer persistMap(Writer outputStream, String mapName) throws PersistenceException {
        if (outputStream == null) {
            outputStream = new StringWriter();
        }
        String mapString = this.getMap(mapName);
        try {
            outputStream.write(mapString);
            outputStream.flush();
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        return outputStream;
    }

    public String getMap(String mapName) {
        return ImageMapUtilities.getImageMap((String)mapName, (ChartRenderingInfo)this.info);
    }

    @Override
    public Object getDrawable() {
        return this.chart;
    }
}

