/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.chart.plugin.openflashchart;

import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ofc4j.model.Chart;
import ofc4j.model.Text;
import ofc4j.model.Tooltip;
import ofc4j.model.axis.Label;
import ofc4j.model.axis.XAxis;
import ofc4j.model.axis.YAxis;
import ofc4j.model.elements.AreaHollowChart;
import ofc4j.model.elements.BarChart;
import ofc4j.model.elements.Element;
import ofc4j.model.elements.HorizontalBarChart;
import ofc4j.model.elements.LineChart;
import ofc4j.model.elements.PieChart;
import ofc4j.model.elements.ScatterChart;
import ofc4j.model.elements.SketchBarChart;
import ofc4j.model.elements.StackedBarChart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.chart.ChartDocumentContext;
import org.pentaho.chart.ChartUtils;
import org.pentaho.chart.IChartLinkGenerator;
import org.pentaho.chart.core.ChartDocument;
import org.pentaho.chart.core.ChartElement;
import org.pentaho.chart.css.keys.ChartStyleKeys;
import org.pentaho.chart.css.styles.ChartOrientationStyle;
import org.pentaho.chart.css.styles.ChartSeriesType;
import org.pentaho.chart.data.ChartTableModel;
import org.pentaho.chart.data.IChartDataModel;
import org.pentaho.chart.data.MultiSeriesDataModel;
import org.pentaho.chart.data.MultiSeriesXYDataModel;
import org.pentaho.chart.data.NamedValue;
import org.pentaho.chart.data.NamedValuesDataModel;
import org.pentaho.chart.data.XYDataModel;
import org.pentaho.chart.data.XYDataPoint;
import org.pentaho.chart.model.AreaPlot;
import org.pentaho.chart.model.Axis;
import org.pentaho.chart.model.BarPlot;
import org.pentaho.chart.model.ChartModel;
import org.pentaho.chart.model.Grid;
import org.pentaho.chart.model.LinePlot;
import org.pentaho.chart.model.NumericAxis;
import org.pentaho.chart.model.Palette;
import org.pentaho.chart.model.PiePlot;
import org.pentaho.chart.model.Plot;
import org.pentaho.chart.model.ScatterPlot;
import org.pentaho.chart.model.StyledText;
import org.pentaho.chart.model.TwoAxisPlot;
import org.pentaho.chart.plugin.api.ChartResult;
import org.pentaho.chart.plugin.api.IOutput;
import org.pentaho.chart.plugin.jfreechart.utils.ColorFactory;
import org.pentaho.chart.plugin.openflashchart.outputs.OpenFlashChartOutput;
import org.pentaho.reporting.libraries.css.dom.LayoutStyle;
import org.pentaho.reporting.libraries.css.keys.border.BorderStyleKeys;
import org.pentaho.reporting.libraries.css.keys.color.ColorStyleKeys;
import org.pentaho.reporting.libraries.css.values.CSSConstant;
import org.pentaho.reporting.libraries.css.values.CSSNumericValue;
import org.pentaho.reporting.libraries.css.values.CSSValue;
import org.pentaho.util.messages.Messages;

public class OpenFlashChartFactoryEngine
implements Serializable {
    private static final Log logger = LogFactory.getLog(OpenFlashChartFactoryEngine.class);
    private static final long serialVersionUID = -1079376910255750394L;
    private static final int STACK_MIN_INDEX = 0;
    private static final int STACK_MAX_INDEX = 1;

    public IOutput makeChart(ChartModel chartModel, IChartDataModel chartTableModel) {
        return this.makeChart(chartModel, chartTableModel, null);
    }

    public IOutput makeChart(ChartModel chartModel, IChartDataModel chartTableModel, IChartLinkGenerator chartLinkGenerator) {
        OpenFlashChartOutput chartOutput = null;
        if (chartModel.getPlot() instanceof BarPlot) {
            chartOutput = new OpenFlashChartOutput(this.makeBarChart(chartModel, (MultiSeriesDataModel)chartTableModel, chartLinkGenerator));
        } else if (chartModel.getPlot() instanceof LinePlot) {
            chartOutput = new OpenFlashChartOutput(this.makeLineChart(chartModel, (MultiSeriesDataModel)chartTableModel, chartLinkGenerator));
        } else if (chartModel.getPlot() instanceof AreaPlot) {
            chartOutput = new OpenFlashChartOutput(this.makeAreaChart(chartModel, (MultiSeriesDataModel)chartTableModel, chartLinkGenerator));
        } else if (chartModel.getPlot() instanceof ScatterPlot) {
            chartOutput = chartTableModel instanceof MultiSeriesXYDataModel ? new OpenFlashChartOutput(this.makeScatterChart(chartModel, (MultiSeriesXYDataModel)chartTableModel)) : new OpenFlashChartOutput(this.makeScatterChart(chartModel, (XYDataModel)chartTableModel));
        } else if (chartModel.getPlot() instanceof PiePlot) {
            chartOutput = new OpenFlashChartOutput(this.makePieChart(chartModel, (NamedValuesDataModel)chartTableModel, chartLinkGenerator));
        }
        return chartOutput;
    }

    public Text getText(StyledText styledText) {
        Text text = null;
        if (styledText != null && styledText.getText() != null && styledText.getText().trim().length() > 0) {
            text = styledText.getStyle().getStyleString().length() > 0 ? new Text(styledText.getText(), styledText.getStyle().getStyleString()) : new Text(styledText.getText());
        }
        return text;
    }

    private Chart createBasicGraphChart(ChartModel chartModel) {
        Chart chart = this.createBasicChart(chartModel);
        Text horizontalAxisLabel = this.getText(((TwoAxisPlot)chartModel.getPlot()).getHorizontalAxis().getLegend());
        Text verticalAxisLabel = this.getText(((TwoAxisPlot)chartModel.getPlot()).getVerticalAxis().getLegend());
        if (horizontalAxisLabel != null) {
            chart.setXLegend(horizontalAxisLabel);
        }
        if (verticalAxisLabel != null) {
            chart.setYLegend(verticalAxisLabel);
        }
        return chart;
    }

    private Chart createBasicChart(ChartModel chartModel) {
        String cssFontStyleString;
        Chart chart = null;
        chart = chartModel.getTitle() != null && chartModel.getTitle().getText() != null && chartModel.getTitle().getText().trim().length() > 0 ? ((cssFontStyleString = chartModel.getTitle().getStyle().getStyleString()).trim().length() > 0 ? new Chart(chartModel.getTitle().getText(), cssFontStyleString) : new Chart(chartModel.getTitle().getText())) : new Chart();
        if (chartModel.getBackground() instanceof Integer) {
            chart.setBackgroundColour("#" + Integer.toHexString(0xFFFFFF & (Integer)chartModel.getBackground()));
        } else {
            chart.setBackgroundColour("#" + Integer.toHexString(0xFFFFFF & Color.WHITE.getRGB()));
        }
        if (chartModel.getPlot().getBackground() instanceof Integer) {
            chart.setInnerBackgroundColour("#" + Integer.toHexString(0xFFFFFF & (Integer)chartModel.getPlot().getBackground()));
        }
        return chart;
    }

    private YAxis createYAxis(TwoAxisPlot twoAxisPlot, AxisConfiguration rangeDescription) {
        YAxis ya = this.createYAxis(twoAxisPlot);
        ya.setRange(Integer.valueOf(rangeDescription.minValue), Integer.valueOf(rangeDescription.maxValue), Integer.valueOf(rangeDescription.stepSize));
        return ya;
    }

    private YAxis createYAxis(TwoAxisPlot twoAxisPlot, List<MultiSeriesDataModel.DomainData> categories) {
        YAxis ya = this.createYAxis(twoAxisPlot);
        ArrayList<String> labels = new ArrayList<String>();
        for (MultiSeriesDataModel.DomainData category : categories) {
            labels.add(category.getDomainFormattedName());
        }
        ya.setLabels(labels.toArray(new String[0]));
        ya.setOffset(Boolean.valueOf(true));
        return ya;
    }

    private YAxis createYAxis(TwoAxisPlot twoAxisPlot) {
        YAxis ya = new YAxis();
        Grid grid = twoAxisPlot.getGrid();
        if (twoAxisPlot.getGrid().getHorizontalLinesVisible()) {
            Integer color = grid.getHorizontalLineColor();
            if (color == null) {
                color = 0xDFDFDF;
            }
            ya.setGridColour("#" + Integer.toHexString(0xFFFFFF & color));
        } else if (twoAxisPlot.getBackground() instanceof Integer) {
            ya.setGridColour("#" + Integer.toHexString(0xFFFFFF & (Integer)twoAxisPlot.getBackground()));
        } else {
            ya.setGridColour("#" + Integer.toHexString(Color.WHITE.getRGB()));
        }
        if (twoAxisPlot.getVerticalAxis().getColor() != null) {
            ya.setColour("#" + Integer.toHexString(twoAxisPlot.getVerticalAxis().getColor()));
        }
        return ya;
    }

    private XAxis createXAxis(TwoAxisPlot twoAxisPlot, AxisConfiguration rangeDescription) {
        XAxis xa = this.createXAxis(twoAxisPlot);
        xa.setRange(Integer.valueOf(rangeDescription.minValue), Integer.valueOf(rangeDescription.maxValue), Integer.valueOf(rangeDescription.stepSize));
        xa.getLabels().setRotation(this.getLabelRotation(twoAxisPlot.getHorizontalAxis()));
        return xa;
    }

    private XAxis createXAxis(TwoAxisPlot twoAxisPlot, List<MultiSeriesDataModel.DomainData> categories) {
        XAxis xa = this.createXAxis(twoAxisPlot);
        ArrayList<String> labels = new ArrayList<String>();
        for (MultiSeriesDataModel.DomainData category : categories) {
            labels.add(category.getDomainFormattedName());
        }
        xa.setLabels(labels);
        xa.getLabels().setRotation(this.getLabelRotation(twoAxisPlot.getHorizontalAxis()));
        return xa;
    }

    private Label.Rotation getLabelRotation(Axis axis) {
        Label.Rotation rotation = Label.Rotation.HORIZONTAL;
        Axis.LabelOrientation labelOrientation = axis.getLabelOrientation();
        if (labelOrientation != null && labelOrientation != Axis.LabelOrientation.HORIZONTAL) {
            switch (labelOrientation) {
                case DIAGONAL: {
                    rotation = Label.Rotation.DIAGONAL;
                    break;
                }
                case VERTICAL: {
                    rotation = Label.Rotation.VERTICAL;
                }
            }
        }
        return rotation;
    }

    private XAxis createXAxis(TwoAxisPlot twoAxisPlot) {
        XAxis xa = new XAxis();
        Grid grid = twoAxisPlot.getGrid();
        if (grid.getVerticalLinesVisible()) {
            Integer color = grid.getVerticalLineColor();
            if (color == null) {
                color = 0xDFDFDF;
            }
            xa.setGridColour("#" + Integer.toHexString(0xFFFFFF & color));
        } else if (twoAxisPlot.getBackground() instanceof Integer) {
            xa.setGridColour("#" + Integer.toHexString(0xFFFFFF & (Integer)twoAxisPlot.getBackground()));
        } else {
            xa.setGridColour("#" + Integer.toHexString(Color.WHITE.getRGB()));
        }
        if (twoAxisPlot.getHorizontalAxis().getColor() != null) {
            xa.setColour("#" + Integer.toHexString(twoAxisPlot.getHorizontalAxis().getColor()));
        }
        return xa;
    }

    public Chart makeAreaChart(ChartModel chartModel, MultiSeriesDataModel chartTableModel, IChartLinkGenerator linkGenerator) {
        Chart chart = this.createBasicGraphChart(chartModel);
        AreaPlot areaPlot = (AreaPlot)chartModel.getPlot();
        chart.setXAxis(this.createXAxis((TwoAxisPlot)areaPlot, chartTableModel.getDomainData()));
        Palette palette = this.getPalette(areaPlot);
        int idx = 0;
        for (MultiSeriesDataModel.SeriesData series : chartTableModel.getSeriesData()) {
            AreaHollowChart areaChart = new AreaHollowChart();
            areaChart.setHaloSize(Integer.valueOf(0));
            areaChart.setWidth(Integer.valueOf(2));
            areaChart.setDotSize(Integer.valueOf(4));
            if (areaPlot.getOpacity() != null) {
                areaChart.setAlpha(areaPlot.getOpacity());
            }
            if (chartModel.getLegend() != null && chartModel.getLegend().getVisible()) {
                areaChart.setText(series.getSeriesFormattedName());
                Integer legendSize = chartModel.getLegend().getFontSize();
                if (legendSize != null && legendSize > 0) {
                    areaChart.setFontSize(legendSize);
                }
            }
            areaChart.setTooltip("#val#");
            if (palette.size() > idx) {
                String colorString = "#" + Integer.toHexString(0xFFFFFF & (Integer)palette.get(idx));
                areaChart.setFill(colorString);
                areaChart.setColour(colorString);
            }
            ArrayList<LineChart.Dot> dots = new ArrayList<LineChart.Dot>();
            for (NamedValue namedValue : series) {
                String dotLink;
                Number value = namedValue.getValue();
                if (value == null) {
                    dots.add(null);
                    continue;
                }
                LineChart.Dot dot = new LineChart.Dot(this.scaleNumber(value, chartTableModel.getScalingFactor()));
                if (linkGenerator != null && (dotLink = linkGenerator.generateLink(series.getSeriesName(), namedValue.getName(), namedValue.getValue())) != null) {
                    dot.setOnClick(dotLink.replaceAll("javascript:", ""));
                }
                dots.add(dot);
            }
            areaChart.addDots(dots);
            chart.addElements(new Element[]{areaChart});
            ++idx;
        }
        AxisConfiguration rangeDescription = this.getAxisConfiguration(areaPlot, chartTableModel);
        if (rangeDescription != null) {
            chart.setYAxis(this.createYAxis((TwoAxisPlot)areaPlot, rangeDescription));
        }
        return chart;
    }

    public Chart makePieChart(ChartModel chartModel, NamedValuesDataModel chartTableModel, IChartLinkGenerator chartLinkGenerator) {
        PieChart pieChart = new PieChart();
        PiePlot piePlot = (PiePlot)chartModel.getPlot();
        pieChart.setAnimate(piePlot.getAnimate());
        pieChart.setBorder(Integer.valueOf(2));
        if (piePlot.getLabels().getVisible() && piePlot.getLabels().getFontSize() != null) {
            pieChart.setFontSize(piePlot.getLabels().getFontSize());
        }
        if (piePlot.getStartAngle() != null) {
            pieChart.setStartAngle(piePlot.getStartAngle());
        }
        if (piePlot.getOpacity() != null) {
            pieChart.setAlpha(piePlot.getOpacity());
        }
        ArrayList<PieChart.Slice> slices = new ArrayList<PieChart.Slice>();
        for (NamedValue chartDataPoint : chartTableModel) {
            String sliceLink;
            Number value = chartDataPoint.getValue();
            if (value == null) continue;
            PieChart.Slice slice = null;
            if (piePlot.getLabels().getVisible()) {
                slice = new PieChart.Slice(this.scaleNumber(value, chartTableModel.getScalingFactor()), "", chartDataPoint.getFormattedName());
            } else {
                slice = new PieChart.Slice(this.scaleNumber(value, chartTableModel.getScalingFactor()), "");
                slice.setTooltip(chartDataPoint.getFormattedName() + " - " + value.toString());
            }
            if (chartLinkGenerator != null && (sliceLink = chartLinkGenerator.generateLink(chartDataPoint.getName(), chartDataPoint.getName(), chartDataPoint.getValue())) != null) {
                slice.setOnClick(sliceLink.replaceAll("javascript:", ""));
            }
            slices.add(slice);
        }
        pieChart.addSlices(slices);
        Palette palette = this.getPalette(piePlot);
        ArrayList<String> strColors = new ArrayList<String>();
        for (Integer color : palette) {
            strColors.add("#" + Integer.toHexString(0xFFFFFF & color));
        }
        pieChart.setColours(strColors);
        Chart chart = this.createBasicChart(chartModel);
        chart.addElements(new Element[]{pieChart});
        return chart;
    }

    private Palette getPalette(Plot plot) {
        Palette palette = new Palette();
        if (plot.getPalette() != null) {
            palette.addAll(plot.getPalette());
        }
        ArrayList<Integer> defaultColors = new ArrayList<Integer>(Plot.DEFAULT_PALETTE);
        defaultColors.removeAll(palette);
        palette.addAll(defaultColors);
        return palette;
    }

    private AxisConfiguration getAxisConfiguration(NumericAxis axis, List<Number> axisValues) {
        Number minValue = axis.getMinValue();
        Number maxValue = axis.getMaxValue();
        boolean calculateMinValue = minValue == null;
        boolean calculateMaxValue = maxValue == null;
        boolean hasChartData = false;
        for (Number value : axisValues) {
            if (calculateMaxValue) {
                if (maxValue == null) {
                    maxValue = value;
                } else if (value != null) {
                    maxValue = Math.max(maxValue.doubleValue(), value.doubleValue());
                }
            }
            if (calculateMinValue) {
                if (minValue == null) {
                    minValue = value;
                } else if (value != null) {
                    minValue = Math.min(minValue.doubleValue(), value.doubleValue());
                }
            }
            hasChartData = hasChartData || value != null;
        }
        AxisConfiguration rangeDescription = null;
        if (hasChartData) {
            if (calculateMinValue) {
                minValue = Math.min(0.0, minValue.doubleValue());
            }
            minValue = Math.floor(minValue.doubleValue());
            if ((maxValue = Double.valueOf(Math.ceil(maxValue.doubleValue()))).equals(minValue)) {
                maxValue = maxValue.intValue() + 1;
            }
            Double spread = maxValue.doubleValue() - minValue.doubleValue();
            int exponent = Integer.toString(Math.abs(((Number)spread).intValue())).length() - 1;
            int stepSize = (int)((double)((long)((double)((Number)spread).intValue() / Math.pow(10.0, exponent))) * Math.pow(10.0, exponent - 1)) * 2;
            if (stepSize < 1) {
                stepSize = 1;
            }
            if (maxValue.doubleValue() % (double)stepSize != 0.0) {
                maxValue = maxValue.doubleValue() - maxValue.doubleValue() % (double)stepSize + (double)stepSize;
            }
            rangeDescription = new AxisConfiguration(minValue.intValue(), maxValue.intValue(), stepSize);
        }
        return rangeDescription;
    }

    private AxisConfiguration getAxisConfiguration(TwoAxisPlot twoAxisPlot, MultiSeriesDataModel chartTableModel) {
        Number minValue = twoAxisPlot.getRangeAxis().getMinValue();
        Number maxValue = twoAxisPlot.getRangeAxis().getMaxValue();
        boolean calculateMinValue = minValue == null;
        boolean calculateMaxValue = maxValue == null;
        boolean hasChartData = false;
        List<MultiSeriesDataModel.SeriesData> seriesList = chartTableModel.getSeriesData();
        if (twoAxisPlot instanceof BarPlot && ((BarPlot)twoAxisPlot).getFlavor() == BarPlot.BarPlotFlavor.STACKED) {
            int numCategories = chartTableModel.getDomainData().size();
            Number[][] stackRanges = new Number[numCategories][];
            for (MultiSeriesDataModel.SeriesData series : seriesList) {
                int index = 0;
                for (NamedValue namedValue : series) {
                    Number value = namedValue.getValue();
                    boolean bl = hasChartData = hasChartData || value != null;
                    if (value != null) {
                        value = this.scaleNumber(value, chartTableModel.getScalingFactor());
                        Number[] stackRange = stackRanges[index];
                        if (stackRange == null) {
                            stackRanges[index] = value.doubleValue() < 0.0 ? new Number[]{value, 0} : new Number[]{0, value};
                        } else if (value.doubleValue() < 0.0) {
                            stackRange[0] = stackRange[0].doubleValue() + value.doubleValue();
                        } else {
                            stackRange[1] = stackRange[1].doubleValue() + value.doubleValue();
                        }
                    }
                    ++index;
                }
            }
            if (hasChartData) {
                for (int column = 0; column < numCategories; ++column) {
                    Number[] stackRange = stackRanges[column];
                    if (calculateMaxValue) {
                        if (maxValue == null) {
                            maxValue = stackRange[1];
                        } else if (stackRange[1] != null) {
                            maxValue = Math.max(maxValue.doubleValue(), stackRange[1].doubleValue());
                        }
                    }
                    if (!calculateMinValue) continue;
                    if (minValue == null) {
                        minValue = stackRange[0];
                        continue;
                    }
                    if (stackRange[0] == null) continue;
                    minValue = Math.min(minValue.doubleValue(), stackRange[0].doubleValue());
                }
            }
        } else {
            for (MultiSeriesDataModel.SeriesData series : seriesList) {
                for (NamedValue namedValue : series) {
                    Number value = namedValue.getValue();
                    boolean bl = hasChartData = hasChartData || value != null;
                    if (value != null) {
                        value = this.scaleNumber(value, chartTableModel.getScalingFactor());
                    }
                    if (calculateMaxValue) {
                        if (maxValue == null) {
                            maxValue = value;
                        } else if (value != null) {
                            maxValue = Math.max(maxValue.doubleValue(), value.doubleValue());
                        }
                    }
                    if (!calculateMinValue) continue;
                    if (minValue == null) {
                        minValue = value;
                        continue;
                    }
                    if (value == null) continue;
                    minValue = Math.min(minValue.doubleValue(), value.doubleValue());
                }
            }
        }
        AxisConfiguration rangeDescription = null;
        if (hasChartData) {
            if (calculateMinValue) {
                minValue = Math.min(0.0, minValue.doubleValue());
            }
            minValue = Math.floor(minValue.doubleValue());
            if ((maxValue = Double.valueOf(Math.ceil(maxValue.doubleValue()))).equals(minValue)) {
                maxValue = maxValue.intValue() + 1;
            }
            Double spread = maxValue.doubleValue() - minValue.doubleValue();
            int exponent = Integer.toString(Math.abs(((Number)spread).intValue())).length() - 1;
            int stepSize = (int)((double)((long)((double)((Number)spread).intValue() / Math.pow(10.0, exponent))) * Math.pow(10.0, exponent - 1)) * 2;
            if (stepSize < 1) {
                stepSize = 1;
            }
            if (maxValue.doubleValue() % (double)stepSize != 0.0) {
                maxValue = maxValue.doubleValue() - maxValue.doubleValue() % (double)stepSize + (double)stepSize;
            }
            rangeDescription = new AxisConfiguration(minValue.intValue(), maxValue.intValue(), stepSize);
        }
        return rangeDescription;
    }

    private StackedBarChart makeStackedBarChart(ChartModel chartModel, MultiSeriesDataModel chartTableModel, IChartLinkGenerator chartLinkGenerator) {
        StackedBarChart stackedBarChart = new StackedBarChart();
        BarPlot barPlot = (BarPlot)chartModel.getPlot();
        Palette palette = this.getPalette(barPlot);
        if (barPlot.getOpacity() != null) {
            stackedBarChart.setAlpha(barPlot.getOpacity());
        }
        boolean firstCategory = true;
        for (MultiSeriesDataModel.DomainData category : chartTableModel.getDomainData()) {
            StackedBarChart.Stack stack = stackedBarChart.newStack();
            int index = 0;
            for (NamedValue namedValue : category) {
                Number value;
                String color = "#" + Integer.toHexString(0xFFFFFF & (Integer)palette.get(index));
                if (firstCategory && chartModel.getLegend() != null && chartModel.getLegend().getVisible()) {
                    StackedBarChart.StackKey key = new StackedBarChart.StackKey();
                    key.setText(namedValue.getFormattedName());
                    key.setColour(color);
                    Integer legendSize = chartModel.getLegend().getFontSize();
                    if (legendSize != null && legendSize > 0) {
                        stackedBarChart.setFontSize(legendSize);
                    }
                    stackedBarChart.addKeys(new StackedBarChart.StackKey[]{key});
                }
                if ((value = namedValue.getValue()) != null && !value.equals(0)) {
                    String barLink;
                    StackedBarChart.StackValue stackValue = new StackedBarChart.StackValue(this.scaleNumber(value, chartTableModel.getScalingFactor()), color);
                    if (chartLinkGenerator != null && (barLink = chartLinkGenerator.generateLink(namedValue.getName(), category.getDomainName(), namedValue.getValue())) != null) {
                        stackValue.setOnClick(barLink.replaceAll("javascript:", ""));
                    }
                    stack.addStackValues(new StackedBarChart.StackValue[]{stackValue});
                }
                ++index;
            }
            firstCategory = false;
        }
        return stackedBarChart;
    }

    private Chart makeScatterChart(ChartModel chartModel, XYDataModel chartTableModel) {
        ScatterPlot scatterPlot = (ScatterPlot)chartModel.getPlot();
        Chart chart = null;
        ArrayList<Number> axisValues = new ArrayList<Number>();
        for (Object xyDataPoint : chartTableModel) {
            axisValues.add(((XYDataPoint)xyDataPoint).getX());
        }
        AxisConfiguration xAxisConfiguration = this.getAxisConfiguration(scatterPlot.getXAxis(), axisValues);
        axisValues.clear();
        for (XYDataPoint xyDataPoint : chartTableModel) {
            axisValues.add(xyDataPoint.getY());
        }
        AxisConfiguration yAxisConfiguration = this.getAxisConfiguration(scatterPlot.getYAxis(), axisValues);
        if (xAxisConfiguration != null && yAxisConfiguration != null) {
            chart = this.createBasicGraphChart(chartModel);
            chart.setXAxis(this.createXAxis((TwoAxisPlot)scatterPlot, xAxisConfiguration));
            chart.setYAxis(this.createYAxis((TwoAxisPlot)scatterPlot, yAxisConfiguration));
            ScatterChart sc = new ScatterChart("");
            String color = "#000000";
            if (scatterPlot.getPalette().size() > 0) {
                color = "#" + Integer.toHexString(0xFFFFFF & (Integer)scatterPlot.getPalette().get(0));
            }
            sc.setColour(color);
            sc.setDotSize(Integer.valueOf(3));
            if (scatterPlot.getOpacity() != null) {
                sc.setAlpha(scatterPlot.getOpacity());
            }
            for (XYDataPoint xyDataPoint : chartTableModel) {
                sc.addPoint(xyDataPoint.getX(), xyDataPoint.getY());
            }
            chart.addElements(new Element[]{sc});
        }
        return chart;
    }

    private Chart makeScatterChart(ChartModel chartModel, MultiSeriesXYDataModel chartTableModel) {
        ScatterPlot scatterPlot = (ScatterPlot)chartModel.getPlot();
        Chart chart = null;
        ArrayList<Number> xAxisValues = new ArrayList<Number>();
        ArrayList<Number> yAxisValues = new ArrayList<Number>();
        for (MultiSeriesXYDataModel.Series series : chartTableModel.getSeries()) {
            for (XYDataPoint xyDataPoint : series) {
                xAxisValues.add(xyDataPoint.getX());
                yAxisValues.add(xyDataPoint.getY());
            }
        }
        AxisConfiguration xAxisConfiguration = this.getAxisConfiguration(scatterPlot.getXAxis(), xAxisValues);
        AxisConfiguration yAxisConfiguration = this.getAxisConfiguration(scatterPlot.getXAxis(), yAxisValues);
        if (xAxisConfiguration != null && yAxisConfiguration != null) {
            chart = this.createBasicGraphChart(chartModel);
            int index = 0;
            for (MultiSeriesXYDataModel.Series series : chartTableModel.getSeries()) {
                chart.setXAxis(this.createXAxis((TwoAxisPlot)scatterPlot, xAxisConfiguration));
                chart.setYAxis(this.createYAxis((TwoAxisPlot)scatterPlot, yAxisConfiguration));
                ScatterChart sc = new ScatterChart(series.getSeriesName());
                sc.setText(series.getSeriesName());
                String color = "#000000";
                if (scatterPlot.getPalette().size() > index) {
                    color = "#" + Integer.toHexString(0xFFFFFF & (Integer)scatterPlot.getPalette().get(index));
                }
                sc.setColour(color);
                sc.setDotSize(Integer.valueOf(3));
                if (scatterPlot.getOpacity() != null) {
                    sc.setAlpha(scatterPlot.getOpacity());
                }
                for (XYDataPoint xyDataPoint : series) {
                    sc.addPoint(xyDataPoint.getX(), xyDataPoint.getY());
                }
                chart.addElements(new Element[]{sc});
                ++index;
            }
        }
        return chart;
    }

    private HorizontalBarChart makeHorizontalBarChart(ChartModel chartModel, MultiSeriesDataModel.SeriesData dataSeries, int seriesIdx, Number scalingFactor, IChartLinkGenerator chartLinkGenerator) {
        HorizontalBarChart horizontalBarChart = new HorizontalBarChart();
        if (chartModel.getLegend() != null && chartModel.getLegend().getVisible()) {
            horizontalBarChart.setText(dataSeries.getSeriesFormattedName());
            Integer legendSize = chartModel.getLegend().getFontSize();
            if (legendSize != null && legendSize > 0) {
                horizontalBarChart.setFontSize(legendSize);
            }
        }
        horizontalBarChart.setTooltip("#val#");
        BarPlot barPlot = (BarPlot)chartModel.getPlot();
        Palette palette = this.getPalette(barPlot);
        if (barPlot.getOpacity() != null) {
            horizontalBarChart.setAlpha(barPlot.getOpacity());
        }
        if (palette.size() > seriesIdx) {
            horizontalBarChart.setColour("#" + Integer.toHexString(0xFFFFFF & (Integer)palette.get(seriesIdx)));
        }
        ArrayList<HorizontalBarChart.Bar> bars = new ArrayList<HorizontalBarChart.Bar>();
        for (NamedValue namedValue : dataSeries) {
            Number value = namedValue.getValue();
            HorizontalBarChart.Bar bar = null;
            if (value == null) {
                bar = null;
            } else {
                String barLink;
                bar = new HorizontalBarChart.Bar(this.scaleNumber(value, scalingFactor));
                if (chartLinkGenerator != null && (barLink = chartLinkGenerator.generateLink(dataSeries.getSeriesName(), namedValue.getName(), namedValue.getValue())) != null) {
                    bar.setOnClick(barLink.replaceAll("javascript:", ""));
                }
            }
            bars.add(bar);
        }
        horizontalBarChart.addBars(bars);
        return horizontalBarChart;
    }

    private BarChart makeVerticalBarChart(ChartModel chartModel, MultiSeriesDataModel.SeriesData dataSeries, int seriesIdx, Number scalingFactor, IChartLinkGenerator chartLinkGenerator) {
        BarChart verticalBarChart = null;
        BarPlot barPlot = (BarPlot)chartModel.getPlot();
        Palette palette = this.getPalette(barPlot);
        if (barPlot.getFlavor() != null) {
            switch (barPlot.getFlavor()) {
                case THREED: {
                    verticalBarChart = new BarChart(BarChart.Style.THREED);
                    break;
                }
                case GLASS: {
                    verticalBarChart = new BarChart(BarChart.Style.GLASS);
                    break;
                }
                case SKETCH: {
                    verticalBarChart = new SketchBarChart();
                    break;
                }
                default: {
                    verticalBarChart = new BarChart();
                    break;
                }
            }
        } else {
            verticalBarChart = new BarChart();
        }
        if (chartModel.getLegend() != null && chartModel.getLegend().getVisible()) {
            verticalBarChart.setText(dataSeries.getSeriesFormattedName());
            Integer legendSize = chartModel.getLegend().getFontSize();
            if (legendSize != null && legendSize > 0) {
                verticalBarChart.setFontSize(legendSize);
            }
        }
        verticalBarChart.setTooltip("#val#");
        if (barPlot.getOpacity() != null) {
            verticalBarChart.setAlpha(barPlot.getOpacity());
        }
        if (palette.size() > seriesIdx) {
            verticalBarChart.setColour("#" + Integer.toHexString(0xFFFFFF & (Integer)palette.get(seriesIdx)));
        }
        ArrayList<BarChart.Bar> bars = new ArrayList<BarChart.Bar>();
        for (NamedValue namedValue : dataSeries) {
            BarChart.Bar bar = null;
            Number value = namedValue.getValue();
            if (value == null) {
                bar = new BarChart.Bar(null);
            } else {
                String barLink;
                bar = new BarChart.Bar(this.scaleNumber(value, scalingFactor));
                if (chartLinkGenerator != null && (barLink = chartLinkGenerator.generateLink(dataSeries.getSeriesName(), namedValue.getName(), namedValue.getValue())) != null) {
                    bar.setOnClick(barLink.replaceAll("javascript:", ""));
                }
            }
            bars.add(bar);
        }
        verticalBarChart.addBars(bars);
        return verticalBarChart;
    }

    public Chart makeBarChart(ChartModel chartModel, MultiSeriesDataModel dataModel, IChartLinkGenerator linkGenerator) {
        Chart chart = this.createBasicGraphChart(chartModel);
        BarPlot barPlot = (BarPlot)chartModel.getPlot();
        if (Plot.Orientation.HORIZONTAL.equals((Object)barPlot.getOrientation())) {
            int index = 0;
            chart.setTooltip(new Tooltip());
            for (MultiSeriesDataModel.SeriesData series : dataModel.getSeriesData()) {
                chart.addElements(new Element[]{this.makeHorizontalBarChart(chartModel, series, index, dataModel.getScalingFactor(), linkGenerator)});
                ++index;
            }
            List<MultiSeriesDataModel.DomainData> categories = dataModel.getDomainData();
            Collections.reverse(categories);
            chart.setYAxis(this.createYAxis((TwoAxisPlot)barPlot, categories));
            AxisConfiguration rangeDescription = this.getAxisConfiguration(barPlot, dataModel);
            if (rangeDescription != null) {
                chart.setXAxis(this.createXAxis((TwoAxisPlot)barPlot, rangeDescription));
            }
        } else {
            AxisConfiguration rangeDescription;
            if (barPlot.getFlavor() == BarPlot.BarPlotFlavor.STACKED) {
                chart.addElements(new Element[]{this.makeStackedBarChart(chartModel, dataModel, linkGenerator)});
            } else {
                int index = 0;
                for (MultiSeriesDataModel.SeriesData series : dataModel.getSeriesData()) {
                    chart.addElements(new Element[]{this.makeVerticalBarChart(chartModel, series, index, dataModel.getScalingFactor(), linkGenerator)});
                    ++index;
                }
            }
            chart.setXAxis(this.createXAxis((TwoAxisPlot)barPlot, dataModel.getDomainData()));
            if (barPlot.getFlavor() == BarPlot.BarPlotFlavor.THREED) {
                chart.getXAxis().set3D(Integer.valueOf(3));
            }
            if ((rangeDescription = this.getAxisConfiguration(barPlot, dataModel)) != null) {
                chart.setYAxis(this.createYAxis((TwoAxisPlot)barPlot, rangeDescription));
            }
        }
        return chart;
    }

    public Chart makeLineChart(ChartModel chartModel, MultiSeriesDataModel chartTableModel, IChartLinkGenerator linkGenerator) {
        Chart chart = this.createBasicGraphChart(chartModel);
        LinePlot linePlot = (LinePlot)chartModel.getPlot();
        chart.setXAxis(this.createXAxis((TwoAxisPlot)linePlot, chartTableModel.getDomainData()));
        Palette palette = this.getPalette(linePlot);
        int index = 0;
        for (MultiSeriesDataModel.SeriesData dataSeries : chartTableModel.getSeriesData()) {
            LineChart lineChart = new LineChart(LineChart.Style.DOT);
            lineChart.setHaloSize(Integer.valueOf(0));
            Integer lineWidth = linePlot.getLineWidth();
            lineChart.setWidth(Integer.valueOf(lineWidth == null || lineWidth <= 0 ? 1 : lineWidth));
            lineChart.setDotSize(Integer.valueOf(lineChart.getWidth() + 2));
            if (linePlot.getOpacity() != null) {
                lineChart.setAlpha(linePlot.getOpacity());
            }
            if (chartModel.getLegend() != null && chartModel.getLegend().getVisible()) {
                lineChart.setText(dataSeries.getSeriesFormattedName());
                Integer legendSize = chartModel.getLegend().getFontSize();
                if (legendSize != null && legendSize > 0) {
                    lineChart.setFontSize(legendSize);
                }
            }
            lineChart.setTooltip("#val#");
            if (palette.size() > index) {
                lineChart.setColour("#" + Integer.toHexString(0xFFFFFF & (Integer)palette.get(index)));
            }
            ArrayList<LineChart.Dot> dots = new ArrayList<LineChart.Dot>();
            for (NamedValue namedValue : dataSeries) {
                String dotLink;
                Number value = namedValue.getValue();
                if (value == null) {
                    dots.add(null);
                    continue;
                }
                LineChart.Dot dot = new LineChart.Dot(this.scaleNumber(value, chartTableModel.getScalingFactor()));
                if (linkGenerator != null && (dotLink = linkGenerator.generateLink(dataSeries.getSeriesName(), namedValue.getName(), namedValue.getValue())) != null) {
                    dot.setOnClick(dotLink.replaceAll("javascript:", ""));
                }
                dots.add(dot);
            }
            lineChart.addDots(dots);
            chart.addElements(new Element[]{lineChart});
            ++index;
        }
        AxisConfiguration rangeDescription = this.getAxisConfiguration(linePlot, chartTableModel);
        if (rangeDescription != null) {
            chart.setYAxis(this.createYAxis((TwoAxisPlot)linePlot, rangeDescription));
        }
        return chart;
    }

    public IOutput makeChart(ChartTableModel chartTableModel, ChartDocumentContext chartDocumentContext, ChartResult chartResult) {
        CSSConstant currentChartType = this.determineChartType(chartDocumentContext.getChartDocument());
        OpenFlashChartOutput chartOutput = null;
        try {
            if (currentChartType == ChartSeriesType.BAR) {
                chartOutput = new OpenFlashChartOutput(this.makeBarChart(chartTableModel, chartDocumentContext));
            } else if (currentChartType == ChartSeriesType.LINE) {
                chartOutput = new OpenFlashChartOutput(this.makeLineChart(chartTableModel, chartDocumentContext));
            } else if (currentChartType == ChartSeriesType.AREA) {
                chartOutput = new OpenFlashChartOutput(this.makeAreaChart(chartTableModel, chartDocumentContext));
            } else if (currentChartType == ChartSeriesType.PIE) {
                chartOutput = new OpenFlashChartOutput(this.makePieChart(chartTableModel, chartDocumentContext));
            } else if (currentChartType == ChartSeriesType.DIAL) {
                chartOutput = new OpenFlashChartOutput(this.makeDialChart(chartTableModel, chartDocumentContext));
            } else {
                chartResult.setErrorCode(5);
                chartResult.setDescription(Messages.getErrorString("JFreeChartPlugin.ERROR_0001_CHART_TYPE_INDETERMINABLE"));
            }
        }
        catch (Exception e) {
            chartResult.setErrorCode(1);
            chartResult.setDescription(e.getLocalizedMessage());
        }
        return chartOutput;
    }

    public Chart makeAreaChart(ChartTableModel chartTableModel, ChartDocumentContext chartDocumentContext) {
        ChartDocument chartDocument = chartDocumentContext.getChartDocument();
        Chart chart = this.createBasicGraphChart(chartDocument);
        boolean showLegend = this.showLegend(chartDocument);
        ArrayList<String> domainValues = new ArrayList<String>();
        for (int column = 0; column < chartTableModel.getColumnCount(); ++column) {
            domainValues.add(chartTableModel.getColumnName(column));
        }
        if (domainValues.size() > 0) {
            XAxis xa = new XAxis();
            xa.setLabels(domainValues);
            xa.setMax(Integer.valueOf(domainValues.size() - 1));
            chart.setXAxis(xa);
        }
        ChartElement[] seriesElements = chartDocument.getRootElement().findChildrenByName("series");
        CSSNumericValue opacity = (CSSNumericValue)chartDocument.getPlotElement().getLayoutStyle().getValue(ColorStyleKeys.OPACITY);
        Number maxValue = null;
        Number minValue = null;
        for (int row = 0; row < chartTableModel.getRowCount(); ++row) {
            AreaHollowChart areaChart = new AreaHollowChart();
            areaChart.setHaloSize(Integer.valueOf(0));
            areaChart.setWidth(Integer.valueOf(2));
            areaChart.setDotSize(Integer.valueOf(4));
            if (opacity != null) {
                areaChart.setAlpha(Float.valueOf((float)opacity.getValue()));
            }
            if (showLegend) {
                areaChart.setText(chartTableModel.getRowName(row));
            }
            areaChart.setTooltip("#val#");
            if (seriesElements != null && seriesElements.length > row) {
                Paint color;
                LayoutStyle layoutStyle = seriesElements[row].getLayoutStyle();
                Paint paint = color = layoutStyle != null ? (Paint)layoutStyle.getValue(ColorStyleKeys.COLOR) : null;
                if (color instanceof Color) {
                    String colorString = "#" + Integer.toHexString(0xFFFFFF & ((Color)color).getRGB());
                    areaChart.setFill(colorString);
                    areaChart.setColour(colorString);
                }
            }
            ArrayList<LineChart.Dot> dots = new ArrayList<LineChart.Dot>();
            for (int column = 0; column < chartTableModel.getColumnCount(); ++column) {
                Number value = (Number)chartTableModel.getValueAt(row, column);
                if (maxValue == null) {
                    maxValue = value;
                } else if (value != null) {
                    maxValue = Math.max(maxValue.doubleValue(), value.doubleValue());
                }
                if (minValue == null) {
                    minValue = value;
                } else if (value != null) {
                    minValue = Math.min(minValue.doubleValue(), value.doubleValue());
                }
                dots.add(new LineChart.Dot(value == null ? (Number)0 : (Number)value));
            }
            areaChart.addDots(dots);
            chart.addElements(new Element[]{areaChart});
        }
        if (maxValue != null && minValue != null) {
            int exponent = Integer.toString(Math.abs(maxValue.intValue())).length() - 1;
            YAxis ya = new YAxis();
            int stepSize = (int)((double)((long)((double)maxValue.intValue() / Math.pow(10.0, exponent))) * Math.pow(10.0, exponent - 1));
            ya.setSteps(Integer.valueOf(stepSize));
            ya.setMax(Integer.valueOf((int)(maxValue.doubleValue() - maxValue.doubleValue() % (double)stepSize) + stepSize));
            chart.setYAxis(ya);
        }
        return chart;
    }

    public Chart makePieChart(ChartTableModel chartTableModel, ChartDocumentContext chartDocumentContext) {
        CSSNumericValue opacity;
        ChartDocument chartDocument = chartDocumentContext.getChartDocument();
        PieChart pieChart = new PieChart();
        pieChart.setAnimate(this.getAnimate(chartDocument));
        pieChart.setBorder(Integer.valueOf(2));
        CSSNumericValue startAngle = (CSSNumericValue)chartDocument.getPlotElement().getLayoutStyle().getValue(ChartStyleKeys.PIE_START_ANGLE);
        if (startAngle != null) {
            pieChart.setStartAngle(Integer.valueOf((int)startAngle.getValue()));
        }
        if ((opacity = (CSSNumericValue)chartDocument.getPlotElement().getLayoutStyle().getValue(ColorStyleKeys.OPACITY)) != null) {
            pieChart.setAlpha(Float.valueOf((float)opacity.getValue()));
        }
        ArrayList<PieChart.Slice> slices = new ArrayList<PieChart.Slice>();
        for (int row = 0; row < chartTableModel.getRowCount(); ++row) {
            ChartElement[] value = (ChartElement[])chartTableModel.getValueAt(row, 0);
            PieChart.Slice slice = new PieChart.Slice((Number)value, "#val#", chartTableModel.getRowName(row));
            slices.add(slice);
        }
        pieChart.addSlices(slices);
        ArrayList<String> colors = new ArrayList<String>();
        for (ChartElement seriesElement : chartDocument.getRootElement().findChildrenByName("series")) {
            Paint color;
            LayoutStyle layoutStyle = seriesElement.getLayoutStyle();
            Paint paint = color = layoutStyle != null ? (Paint)layoutStyle.getValue(ColorStyleKeys.COLOR) : null;
            if (!(color instanceof Color)) continue;
            colors.add("#" + Integer.toHexString(0xFFFFFF & ((Color)color).getRGB()));
        }
        pieChart.setColours(colors);
        Chart chart = this.createBasicChart(chartDocument);
        chart.addElements(new Element[]{pieChart});
        return chart;
    }

    public Chart makeDialChart(ChartTableModel chartTableModel, ChartDocumentContext chartDocumentContext) {
        Chart chartData = new Chart("The Title", "font-size: 14px; font-family: Verdana; text-align: center;");
        return chartData;
    }

    private String createCssFontStyleString(ChartElement element) {
        LayoutStyle layoutStyle;
        Paint color;
        StringBuffer cssStyleString = new StringBuffer();
        String fontFamily = ChartUtils.getFontFamily(element);
        float fontSize = ChartUtils.getFontSize(element);
        CSSValue fontStyle = ChartUtils.getFontStyle(element);
        CSSValue fontWeight = ChartUtils.getFontWeight(element);
        if (fontFamily != null && fontFamily.trim().length() > 0) {
            cssStyleString.append("font-family: " + fontFamily + ";");
        }
        if (fontSize > 0.0f) {
            cssStyleString.append("font-size: " + fontSize + "px;");
        }
        if (fontStyle != null) {
            cssStyleString.append("font-style: " + fontStyle.getCSSText() + ";");
        }
        if (fontWeight != null) {
            cssStyleString.append("font-weight: " + fontWeight.getCSSText() + ";");
        }
        Paint paint = color = (layoutStyle = element.getLayoutStyle()) != null ? (Paint)layoutStyle.getValue(ColorStyleKeys.COLOR) : null;
        if (color instanceof Color) {
            cssStyleString.append("color: #" + Integer.toHexString(0xFFFFFF & ((Color)color).getRGB()));
        }
        return cssStyleString.length() > 0 ? cssStyleString.toString() : null;
    }

    private Chart createBasicGraphChart(ChartDocument chartDocument) {
        Chart chart = this.createBasicChart(chartDocument);
        Text rangeLabel = this.getText(chartDocument, "rangeLabel");
        Text domainLabel = this.getText(chartDocument, "domainLabel");
        if (domainLabel != null) {
            chart.setXLegend(domainLabel);
        }
        if (rangeLabel != null) {
            chart.setYLegend(rangeLabel);
        }
        return chart;
    }

    private Chart createBasicChart(ChartDocument chartDocument) {
        String chartTitle = null;
        String cssFontStyleString = null;
        ChartElement rootElement = chartDocument.getRootElement();
        ChartElement plot = chartDocument.getPlotElement();
        ChartElement[] children = rootElement.findChildrenByName("title");
        if (children != null && children.length > 0) {
            chartTitle = children[0].getText();
            cssFontStyleString = this.createCssFontStyleString(children[0]);
        }
        Chart chart = null;
        chart = chartTitle != null && chartTitle.trim().length() > 0 ? (cssFontStyleString != null ? new Chart(chartTitle, cssFontStyleString) : new Chart(chartTitle)) : new Chart();
        Color chartBackgroundPaint = ColorFactory.getInstance().getColor(rootElement, BorderStyleKeys.BACKGROUND_COLOR);
        if (chartBackgroundPaint == null) {
            chartBackgroundPaint = Color.white;
        }
        chart.setBackgroundColour("#" + Integer.toHexString(0xFFFFFF & chartBackgroundPaint.getRGB()));
        Color plotBackgroundColor = ColorFactory.getInstance().getColor(plot, BorderStyleKeys.BACKGROUND_COLOR);
        if (plotBackgroundColor != null) {
            chart.setInnerBackgroundColour("#" + Integer.toHexString(0xFFFFFF & plotBackgroundColor.getRGB()));
        }
        return chart;
    }

    private boolean showLegend(ChartDocument chartDocument) {
        ChartElement[] children = chartDocument.getRootElement().findChildrenByName("legend");
        return children != null && children.length > 0;
    }

    public Chart makeBarChart(ChartTableModel chartTableModel, ChartDocumentContext chartDocumentContext) throws Exception {
        LayoutStyle layoutStyle;
        int i;
        ArrayList<String> categories;
        ChartDocument chartDocument = chartDocumentContext.getChartDocument();
        Chart chart = this.createBasicGraphChart(chartDocument);
        boolean showLegend = this.showLegend(chartDocument);
        CSSValue orientation = this.getPlotOrientation(chartDocumentContext.getChartDocument());
        CSSNumericValue opacity = (CSSNumericValue)chartDocument.getPlotElement().getLayoutStyle().getValue(ColorStyleKeys.OPACITY);
        ChartElement[] seriesElements = chartDocument.getRootElement().findChildrenByName("series");
        Enum flavor = null;
        for (ChartElement element : seriesElements) {
            CSSValue cssValue = element.getLayoutStyle().getValue(ChartStyleKeys.BAR_STYLE);
            if (cssValue == null) continue;
            String text = cssValue.getCSSText();
            for (BarPlot.BarPlotFlavor barPlotFlavor : BarPlot.BarPlotFlavor.values()) {
                if (!barPlotFlavor.toString().equalsIgnoreCase(text)) continue;
                flavor = barPlotFlavor;
            }
        }
        if (ChartOrientationStyle.HORIZONTAL.equals((Object)orientation)) {
            categories = new ArrayList<String>();
            for (i = 0; i < chartTableModel.getColumnCount(); ++i) {
                categories.add(chartTableModel.getColumnName(i));
            }
            if (!(categories.size() <= 0 || categories.size() <= 1 && ((String)categories.get(0)).equals(""))) {
                YAxis ya = new YAxis();
                ya.setLabels(categories.toArray(new String[0]));
                ya.setMax(Integer.valueOf(categories.size()));
                chart.setYAxis(ya);
            }
            Number maxValue = null;
            Number minValue = null;
            for (int row = 0; row < chartTableModel.getRowCount(); ++row) {
                HorizontalBarChart horizontalBarChart = new HorizontalBarChart();
                if (showLegend) {
                    horizontalBarChart.setText(chartTableModel.getRowName(row));
                }
                horizontalBarChart.setTooltip("#val#");
                if (opacity != null) {
                    horizontalBarChart.setAlpha(Float.valueOf((float)opacity.getValue()));
                }
                if (seriesElements != null && seriesElements.length > row) {
                    Paint color;
                    layoutStyle = seriesElements[row].getLayoutStyle();
                    Paint paint = color = layoutStyle != null ? (Paint)layoutStyle.getValue(ColorStyleKeys.COLOR) : null;
                    if (color instanceof Color) {
                        horizontalBarChart.setColour("#" + Integer.toHexString(0xFFFFFF & ((Color)color).getRGB()));
                    }
                }
                ArrayList<Number> values = new ArrayList<Number>();
                for (int column = 0; column < chartTableModel.getColumnCount(); ++column) {
                    Number value = (Number)chartTableModel.getValueAt(row, column);
                    if (maxValue == null) {
                        maxValue = value;
                    } else if (value != null) {
                        maxValue = Math.max(maxValue.doubleValue(), value.doubleValue());
                    }
                    if (minValue == null) {
                        minValue = value;
                    } else if (value != null) {
                        minValue = Math.min(minValue.doubleValue(), value.doubleValue());
                    }
                    values.add(value == null ? (Number)0 : (Number)value);
                }
                horizontalBarChart.addValues(values.toArray(new Number[0]));
                chart.addElements(new Element[]{horizontalBarChart});
            }
            if (maxValue != null && minValue != null) {
                int exponent = Integer.toString(Math.abs(maxValue.intValue())).length() - 1;
                XAxis xa = new XAxis();
                int stepSize = (int)((double)((long)((double)maxValue.intValue() / Math.pow(10.0, exponent))) * Math.pow(10.0, exponent - 1)) * 2;
                xa.setSteps(Integer.valueOf(stepSize));
                xa.setMax(Integer.valueOf((int)(maxValue.doubleValue() - maxValue.doubleValue() % (double)stepSize) + stepSize));
                chart.setXAxis(xa);
            }
        } else {
            categories = new ArrayList();
            for (i = 0; i < chartTableModel.getColumnCount(); ++i) {
                categories.add(chartTableModel.getColumnName(i));
            }
            if (!(categories.size() <= 0 || categories.size() <= 1 && ((String)categories.get(0)).equals(""))) {
                XAxis xa = new XAxis();
                xa.setLabels(categories);
                xa.setMax(Integer.valueOf(categories.size()));
                chart.setXAxis(xa);
            }
            Number maxValue = null;
            Number minValue = null;
            for (int row = 0; row < chartTableModel.getRowCount(); ++row) {
                BarChart verticalBarChart = null;
                if (flavor != null) {
                    switch (1.$SwitchMap$org$pentaho$chart$model$BarPlot$BarPlotFlavor[flavor.ordinal()]) {
                        case 1: {
                            verticalBarChart = new BarChart(BarChart.Style.THREED);
                            break;
                        }
                        case 2: {
                            verticalBarChart = new BarChart(BarChart.Style.GLASS);
                            break;
                        }
                        default: {
                            verticalBarChart = new BarChart();
                            break;
                        }
                    }
                } else {
                    verticalBarChart = new BarChart();
                }
                if (showLegend) {
                    verticalBarChart.setText(chartTableModel.getRowName(row));
                }
                verticalBarChart.setTooltip("#val#");
                if (opacity != null) {
                    verticalBarChart.setAlpha(Float.valueOf((float)opacity.getValue()));
                }
                if (seriesElements != null && seriesElements.length > row) {
                    Paint color;
                    layoutStyle = seriesElements[row].getLayoutStyle();
                    Paint paint = color = layoutStyle != null ? (Paint)layoutStyle.getValue(ColorStyleKeys.COLOR) : null;
                    if (color instanceof Color) {
                        verticalBarChart.setColour("#" + Integer.toHexString(0xFFFFFF & ((Color)color).getRGB()));
                    }
                }
                ArrayList<BarChart.Bar> bars = new ArrayList<BarChart.Bar>();
                for (int column = 0; column < chartTableModel.getColumnCount(); ++column) {
                    Number value = (Number)chartTableModel.getValueAt(row, column);
                    if (maxValue == null) {
                        maxValue = value;
                    } else if (value != null) {
                        maxValue = Math.max(maxValue.doubleValue(), value.doubleValue());
                    }
                    if (minValue == null) {
                        minValue = value;
                    } else if (value != null) {
                        minValue = Math.min(minValue.doubleValue(), value.doubleValue());
                    }
                    bars.add(new BarChart.Bar(value));
                }
                verticalBarChart.addBars(bars);
                chart.addElements(new Element[]{verticalBarChart});
            }
            if (maxValue != null && minValue != null) {
                int exponent = Integer.toString(Math.abs(maxValue.intValue())).length() - 1;
                YAxis ya = new YAxis();
                int stepSize = (int)((double)((long)((double)maxValue.intValue() / Math.pow(10.0, exponent))) * Math.pow(10.0, exponent - 1));
                ya.setSteps(Integer.valueOf(stepSize));
                ya.setMax(Integer.valueOf((int)(maxValue.doubleValue() - maxValue.doubleValue() % (double)stepSize) + stepSize));
                chart.setYAxis(ya);
            }
        }
        return chart;
    }

    public boolean getAnimate(ChartDocument chartDocument) {
        ChartElement[] children = chartDocument.getRootElement().findChildrenByName("animate");
        return children != null && children.length > 0 && Boolean.valueOf(children[0].getText()) != false;
    }

    private CSSValue getPlotOrientation(ChartDocument chartDocument) {
        CSSValue plotOrient = null;
        ChartElement plotElement = chartDocument.getPlotElement();
        if (plotElement != null) {
            LayoutStyle layoutStyle = plotElement.getLayoutStyle();
            plotOrient = layoutStyle.getValue(ChartStyleKeys.ORIENTATION);
        }
        return plotOrient;
    }

    public Chart makeLineChart(ChartTableModel chartTableModel, ChartDocumentContext chartDocumentContext) {
        ChartDocument chartDocument = chartDocumentContext.getChartDocument();
        boolean showLegend = this.showLegend(chartDocument);
        Chart chart = this.createBasicGraphChart(chartDocument);
        ArrayList<String> domainValues = new ArrayList<String>();
        for (int column = 0; column < chartTableModel.getColumnCount(); ++column) {
            domainValues.add(chartTableModel.getColumnName(column));
        }
        if (domainValues.size() > 0) {
            XAxis xa = new XAxis();
            xa.setLabels(domainValues);
            xa.setMax(Integer.valueOf(domainValues.size()));
            chart.setXAxis(xa);
        }
        CSSNumericValue opacity = (CSSNumericValue)chartDocument.getPlotElement().getLayoutStyle().getValue(ColorStyleKeys.OPACITY);
        ChartElement[] seriesElements = chartDocument.getRootElement().findChildrenByName("series");
        Number maxValue = null;
        Number minValue = null;
        for (int row = 0; row < chartTableModel.getRowCount(); ++row) {
            LineChart lineChart = new LineChart(LineChart.Style.DOT);
            lineChart.setHaloSize(Integer.valueOf(0));
            lineChart.setWidth(Integer.valueOf(2));
            lineChart.setDotSize(Integer.valueOf(4));
            if (opacity != null) {
                lineChart.setAlpha(Float.valueOf((float)opacity.getValue()));
            }
            if (showLegend) {
                lineChart.setText(chartTableModel.getRowName(row));
            }
            lineChart.setTooltip("#val#");
            if (seriesElements != null && seriesElements.length > row) {
                Paint color;
                LayoutStyle layoutStyle = seriesElements[row].getLayoutStyle();
                Paint paint = color = layoutStyle != null ? (Paint)layoutStyle.getValue(ColorStyleKeys.COLOR) : null;
                if (color instanceof Color) {
                    lineChart.setColour("#" + Integer.toHexString(0xFFFFFF & ((Color)color).getRGB()));
                }
            }
            ArrayList<LineChart.Dot> dots = new ArrayList<LineChart.Dot>();
            for (int column = 0; column < chartTableModel.getColumnCount(); ++column) {
                Number value = (Number)chartTableModel.getValueAt(row, column);
                if (maxValue == null) {
                    maxValue = value;
                } else if (value != null) {
                    maxValue = Math.max(maxValue.doubleValue(), value.doubleValue());
                }
                if (minValue == null) {
                    minValue = value;
                } else if (value != null) {
                    minValue = Math.min(minValue.doubleValue(), value.doubleValue());
                }
                dots.add(new LineChart.Dot(value == null ? (Number)0 : (Number)value));
            }
            lineChart.addDots(dots);
            chart.addElements(new Element[]{lineChart});
        }
        if (maxValue != null && minValue != null) {
            int exponent = Integer.toString(Math.abs(maxValue.intValue())).length() - 1;
            YAxis ya = new YAxis();
            int stepSize = (int)((double)((long)((double)maxValue.intValue() / Math.pow(10.0, exponent))) * Math.pow(10.0, exponent - 1));
            ya.setSteps(Integer.valueOf(stepSize));
            ya.setMax(Integer.valueOf((int)(maxValue.doubleValue() - maxValue.doubleValue() % (double)stepSize) + stepSize));
            chart.setYAxis(ya);
        }
        return chart;
    }

    public CSSConstant determineChartType(ChartDocument chartDocument) {
        ChartElement[] elements;
        for (ChartElement element : elements = chartDocument.getRootElement().findChildrenByName("series")) {
            CSSValue value = element.getLayoutStyle().getValue(ChartStyleKeys.CHART_TYPE);
            if (value == null) continue;
            if (value.equals(ChartSeriesType.BAR)) {
                return ChartSeriesType.BAR;
            }
            if (value.equals(ChartSeriesType.LINE)) {
                return ChartSeriesType.LINE;
            }
            if (value.equals(ChartSeriesType.AREA)) {
                return ChartSeriesType.AREA;
            }
            if (value.equals(ChartSeriesType.PIE)) {
                return ChartSeriesType.PIE;
            }
            if (!value.equals(ChartSeriesType.DIAL)) continue;
            return ChartSeriesType.DIAL;
        }
        return ChartSeriesType.UNDEFINED;
    }

    public Text getText(ChartDocument chartDocument, String elementName) {
        String label;
        Text text = null;
        ChartElement[] children = chartDocument.getRootElement().findChildrenByName(elementName);
        if (children != null && children.length > 0 && (label = children[0].getText().trim()).length() > 0) {
            String cssFontStyleString = this.createCssFontStyleString(children[0]);
            text = cssFontStyleString != null ? new Text(label, cssFontStyleString) : new Text(label);
        }
        return text;
    }

    protected Number scaleNumber(Number number, Number scale) {
        Number scaledNumber = number;
        if (number != null && scale != null && !scale.equals(1) && !scale.equals(0)) {
            String fractionalPart;
            int indexOfDecimalPoint;
            int startingSignificantDigits = 0;
            if (!(number instanceof Integer || (indexOfDecimalPoint = number.toString().indexOf(".")) < 0 || (fractionalPart = number.toString().substring(indexOfDecimalPoint + 1)).length() <= 1 && Integer.parseInt(fractionalPart) <= 0)) {
                startingSignificantDigits = fractionalPart.length();
            }
            int preferredSignificantDigits = Math.max(2, Math.min(startingSignificantDigits, 6));
            scaledNumber = number.doubleValue() / scale.doubleValue();
            int scaledSignificantDigits = 0;
            int indexOfDecimalPoint2 = scaledNumber.toString().indexOf(".");
            String fractionalPart2 = scaledNumber.toString().substring(indexOfDecimalPoint2 + 1);
            if (fractionalPart2.length() > 1 || Integer.parseInt(fractionalPart2) > 0) {
                scaledSignificantDigits = fractionalPart2.length();
            }
            if (scaledSignificantDigits > preferredSignificantDigits) {
                double multiplier = Math.pow(10.0, preferredSignificantDigits);
                scaledNumber = (double)Math.round(scaledNumber.doubleValue() * multiplier) / multiplier;
            }
        }
        return scaledNumber;
    }

    private class AxisConfiguration {
        int minValue;
        int maxValue;
        int stepSize;

        private AxisConfiguration(int minValue, int maxValue, int stepSize) {
            this.maxValue = maxValue;
            this.minValue = minValue;
            this.stepSize = stepSize;
        }
    }
}

