/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.util.messages;

import java.text.DateFormat;
import java.util.Locale;

public class LocaleHelper {
    private static final ThreadLocal threadLocales = new ThreadLocal();
    public static final int FORMAT_SHORT = 3;
    public static final int FORMAT_MEDIUM = 2;
    public static final int FORMAT_LONG = 1;
    public static final int FORMAT_FULL = 0;
    public static final int FORMAT_IGNORE = -1;
    private static Locale defaultLocale;
    public static final String UTF_8 = "UTF-8";
    private static String encoding;
    public static final String LEFT_TO_RIGHT = "LTR";
    private static String textDirection;

    private LocaleHelper() {
    }

    public static void setDefaultLocale(Locale newLocale) {
        defaultLocale = newLocale;
    }

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    public static void setLocale(Locale newLocale) {
        threadLocales.set(newLocale);
    }

    public static Locale getLocale() {
        Locale rtn = (Locale)threadLocales.get();
        if (rtn != null) {
            return rtn;
        }
        defaultLocale = Locale.getDefault();
        LocaleHelper.setLocale(defaultLocale);
        return defaultLocale;
    }

    public static void setSystemEncoding(String encoding) {
        LocaleHelper.encoding = encoding;
    }

    public static void setTextDirection(String textDirection) {
        LocaleHelper.textDirection = textDirection;
    }

    public static String getSystemEncoding() {
        return encoding;
    }

    public static String getTextDirection() {
        return textDirection;
    }

    public static DateFormat getDateFormat(int dateFormat, int timeFormat) {
        if (dateFormat != -1 && timeFormat != -1) {
            return DateFormat.getDateTimeInstance(dateFormat, timeFormat, LocaleHelper.getLocale());
        }
        if (dateFormat != -1) {
            return DateFormat.getDateInstance(dateFormat, LocaleHelper.getLocale());
        }
        if (timeFormat != -1) {
            return DateFormat.getTimeInstance(timeFormat, LocaleHelper.getLocale());
        }
        return null;
    }

    public static DateFormat getShortDateFormat(boolean date, boolean time) {
        if (date && time) {
            return DateFormat.getDateTimeInstance(3, 3, LocaleHelper.getLocale());
        }
        if (date) {
            return DateFormat.getDateInstance(3, LocaleHelper.getLocale());
        }
        if (time) {
            return DateFormat.getTimeInstance(3, LocaleHelper.getLocale());
        }
        return null;
    }

    public static DateFormat getMediumDateFormat(boolean date, boolean time) {
        if (date && time) {
            return DateFormat.getDateTimeInstance(2, 2, LocaleHelper.getLocale());
        }
        if (date) {
            return DateFormat.getDateInstance(2, LocaleHelper.getLocale());
        }
        if (time) {
            return DateFormat.getTimeInstance(2, LocaleHelper.getLocale());
        }
        return null;
    }

    public static DateFormat getLongDateFormat(boolean date, boolean time) {
        if (date && time) {
            return DateFormat.getDateTimeInstance(1, 1, LocaleHelper.getLocale());
        }
        if (date) {
            return DateFormat.getDateInstance(1, LocaleHelper.getLocale());
        }
        if (time) {
            return DateFormat.getTimeInstance(1, LocaleHelper.getLocale());
        }
        return null;
    }

    public static DateFormat getFullDateFormat(boolean date, boolean time) {
        if (date && time) {
            return DateFormat.getDateTimeInstance(0, 0, LocaleHelper.getLocale());
        }
        if (date) {
            return DateFormat.getDateInstance(0, LocaleHelper.getLocale());
        }
        if (time) {
            return DateFormat.getTimeInstance(0, LocaleHelper.getLocale());
        }
        return null;
    }

    static {
        encoding = UTF_8;
        textDirection = LEFT_TO_RIGHT;
    }
}

