/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.xml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.xml.TextValue;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.util.Base64;
import org.apache.jackrabbit.util.TransientFileFactory;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BufferedStringValue
implements TextValue {
    private static Logger log = LoggerFactory.getLogger(BufferedStringValue.class);
    private static final int MAX_BUFFER_SIZE = 65536;
    private StringWriter buffer = new StringWriter();
    private long length = 0L;
    private File tmpFile = null;
    private Writer writer = null;
    private final NamePathResolver nsContext;
    private final ValueFactory valueFactory;
    private boolean base64;

    protected BufferedStringValue(NamePathResolver nsContext, ValueFactory valueFactory) {
        this.nsContext = nsContext;
        this.valueFactory = valueFactory;
    }

    public long length() throws IOException {
        return this.length;
    }

    private String retrieveString() throws IOException {
        String value = this.retrieve();
        if (this.base64) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Base64.decode((String)value, (OutputStream)out);
            value = new String(out.toByteArray(), "UTF-8");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String retrieve() throws IOException {
        if (this.buffer != null) {
            return this.buffer.toString();
        }
        if (this.tmpFile != null) {
            this.writer.close();
            if (this.tmpFile.length() > Integer.MAX_VALUE) {
                throw new IOException("size of value is too big, use reader()");
            }
            StringBuilder sb = new StringBuilder((int)this.length);
            char[] chunk = new char[8192];
            try (Reader reader = this.openReader();){
                int read;
                while ((read = reader.read(chunk)) > -1) {
                    sb.append(chunk, 0, read);
                }
            }
            return sb.toString();
        }
        throw new IOException("this instance has already been disposed");
    }

    private Reader openReader() throws IOException {
        return new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(this.tmpFile)), "UTF-8");
    }

    public Reader reader() throws IOException {
        if (this.buffer != null) {
            return new StringReader(this.retrieve());
        }
        if (this.tmpFile != null) {
            this.writer.close();
            return this.openReader();
        }
        throw new IOException("this instance has already been disposed");
    }

    public void append(char[] chars, int start, int len) throws IOException {
        if (this.buffer != null) {
            if (this.length + (long)len > 65536L) {
                TransientFileFactory fileFactory = TransientFileFactory.getInstance();
                this.tmpFile = fileFactory.createTransientFile("txt", null, null);
                BufferedOutputStream fout = new BufferedOutputStream(new FileOutputStream(this.tmpFile));
                this.writer = new OutputStreamWriter((OutputStream)fout, "UTF-8");
                this.writer.write(this.buffer.toString());
                this.writer.write(chars, start, len);
                this.buffer = null;
            } else {
                this.buffer.write(chars, start, len);
            }
        } else if (this.tmpFile != null) {
            this.writer.write(chars, start, len);
        } else {
            throw new IOException("this instance has already been disposed");
        }
        this.length += (long)len;
    }

    public void close() throws IOException {
        if (this.buffer == null) {
            if (this.tmpFile != null) {
                this.writer.close();
            } else {
                throw new IOException("this instance has already been disposed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value getValue(int targetType, NamePathResolver resolver) throws ValueFormatException, RepositoryException {
        Value value;
        if (targetType == 7 || targetType == 8) {
            InternalValue ival = InternalValue.create(ValueHelper.convert((String)this.retrieve(), (int)targetType, (ValueFactory)this.valueFactory), this.nsContext);
            return ValueFormat.getJCRValue((QValue)ival, (NamePathResolver)resolver, (ValueFactory)this.valueFactory);
        }
        if (targetType != 2) return ValueHelper.deserialize((String)this.retrieveString(), (int)targetType, (boolean)false, (ValueFactory)this.valueFactory);
        if (this.length() < 65536L) {
            return ValueHelper.deserialize((String)this.retrieve(), (int)targetType, (boolean)false, (ValueFactory)this.valueFactory);
        }
        Reader reader = this.reader();
        try {
            value = ValueHelper.deserialize((Reader)reader, (int)targetType, (boolean)false, (ValueFactory)this.valueFactory);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                String msg = "failed to retrieve serialized value";
                log.debug(msg, (Throwable)e);
                throw new RepositoryException(msg, (Throwable)e);
            }
        }
        reader.close();
        return value;
    }

    @Override
    public InternalValue getInternalValue(int type) throws ValueFormatException, RepositoryException {
        try {
            if (type == 2) {
                if (this.length() < 65536L) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Base64.decode((String)this.retrieve(), (OutputStream)baos);
                    return InternalValue.create(baos.toByteArray());
                }
                Base64ReaderInputStream in = new Base64ReaderInputStream(this.reader());
                return InternalValue.createTemporary(in);
            }
            return InternalValue.create(ValueHelper.convert((String)this.retrieveString(), (int)type, (ValueFactory)this.valueFactory), this.nsContext);
        }
        catch (IOException e) {
            throw new RepositoryException("Error accessing property value", (Throwable)e);
        }
    }

    @Override
    public void dispose() {
        if (this.buffer != null) {
            this.buffer = null;
        } else if (this.tmpFile != null) {
            try {
                this.writer.close();
                this.tmpFile.delete();
                this.tmpFile = null;
                this.writer = null;
            }
            catch (IOException e) {
                log.warn("Problem disposing property value", (Throwable)e);
            }
        } else {
            log.warn("this instance has already been disposed");
        }
    }

    public void setBase64(boolean base64) {
        this.base64 = base64;
    }

    private static class Base64ReaderInputStream
    extends InputStream {
        private static final int BUFFER_SIZE = 1024;
        private final char[] chars = new char[1024];
        private final ByteArrayOutputStream out;
        private final Reader reader;
        private int pos;
        private int remaining;
        private byte[] buffer;

        public Base64ReaderInputStream(Reader reader) {
            this.reader = reader;
            this.out = new ByteArrayOutputStream(1024);
        }

        private void fillBuffer() throws IOException {
            int len = this.reader.read(this.chars, 0, 1024);
            if (len < 0) {
                this.remaining = -1;
                return;
            }
            Base64.decode((char[])this.chars, (int)0, (int)len, (OutputStream)this.out);
            this.buffer = this.out.toByteArray();
            this.pos = 0;
            this.remaining = this.buffer.length;
            this.out.reset();
        }

        @Override
        public int read() throws IOException {
            if (this.remaining == 0) {
                this.fillBuffer();
            }
            if (this.remaining < 0) {
                return -1;
            }
            --this.remaining;
            return this.buffer[this.pos++] & 0xFF;
        }
    }
}

