/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.hadoop.hbase.regionserver.MutableSegment;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.SegmentFactory;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;

@InterfaceAudience.Private
public abstract class AbstractMemStore
implements MemStore {
    private static final long NO_SNAPSHOT_ID = -1L;
    private final Configuration conf;
    private final CellComparator comparator;
    protected volatile MutableSegment active;
    protected volatile ImmutableSegment snapshot;
    protected volatile long snapshotId;
    private volatile long timeOfOldestEdit;
    public static final long FIXED_OVERHEAD;
    public static final long DEEP_OVERHEAD;

    public static long addToScanners(List<? extends Segment> segments, long readPt, long order, List<KeyValueScanner> scanners) {
        for (Segment segment : segments) {
            order = AbstractMemStore.addToScanners(segment, readPt, order, scanners);
        }
        return order;
    }

    protected static long addToScanners(Segment segment, long readPt, long order, List<KeyValueScanner> scanners) {
        scanners.add(segment.getScanner(readPt, order));
        return order - 1L;
    }

    protected AbstractMemStore(Configuration conf, CellComparator c) {
        this.conf = conf;
        this.comparator = c;
        this.resetActive();
        this.snapshot = SegmentFactory.instance().createImmutableSegment(c);
        this.snapshotId = -1L;
    }

    protected void resetActive() {
        this.active = SegmentFactory.instance().createMutableSegment(this.conf, this.comparator);
        this.timeOfOldestEdit = Long.MAX_VALUE;
    }

    public abstract void updateLowestUnflushedSequenceIdInWAL(boolean var1);

    @Override
    public void add(Iterable<Cell> cells, MemStoreSizing memstoreSizing) {
        for (Cell cell : cells) {
            this.add(cell, memstoreSizing);
        }
    }

    @Override
    public void add(Cell cell, MemStoreSizing memstoreSizing) {
        boolean mslabUsed;
        Cell toAdd = this.maybeCloneWithAllocator(cell, false);
        boolean bl = mslabUsed = toAdd != cell;
        if (!mslabUsed) {
            toAdd = AbstractMemStore.deepCopyIfNeeded(toAdd);
        }
        this.internalAdd(toAdd, mslabUsed, memstoreSizing);
    }

    private static Cell deepCopyIfNeeded(Cell cell) {
        if (cell instanceof ExtendedCell) {
            return ((ExtendedCell)cell).deepClone();
        }
        return cell;
    }

    @Override
    public void upsert(Iterable<Cell> cells, long readpoint, MemStoreSizing memstoreSizing) {
        for (Cell cell : cells) {
            this.upsert(cell, readpoint, memstoreSizing);
        }
    }

    @Override
    public long timeOfOldestEdit() {
        return this.timeOfOldestEdit;
    }

    @Override
    public void clearSnapshot(long id) throws UnexpectedStateException {
        if (this.snapshotId == -1L) {
            return;
        }
        if (this.snapshotId != id) {
            throw new UnexpectedStateException("Current snapshot id is " + this.snapshotId + ",passed " + id);
        }
        ImmutableSegment oldSnapshot = this.snapshot;
        if (!this.snapshot.isEmpty()) {
            this.snapshot = SegmentFactory.instance().createImmutableSegment(this.comparator);
        }
        this.snapshotId = -1L;
        oldSnapshot.close();
    }

    @Override
    public MemStoreSize getSnapshotSize() {
        return this.snapshot.getMemStoreSize();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int i = 1;
        try {
            for (Segment segment : this.getSegments()) {
                buf.append("Segment (" + i + ") " + segment.toString() + "; ");
                ++i;
            }
        }
        catch (IOException e) {
            return e.toString();
        }
        return buf.toString();
    }

    protected Configuration getConfiguration() {
        return this.conf;
    }

    protected void dump(Logger log) {
        this.active.dump(log);
        this.snapshot.dump(log);
    }

    private void upsert(Cell cell, long readpoint, MemStoreSizing memstoreSizing) {
        cell = AbstractMemStore.deepCopyIfNeeded(cell);
        this.active.upsert(cell, readpoint, memstoreSizing);
        this.setOldestEditTimeToNow();
        this.checkActiveSize();
    }

    protected Cell getLowest(Cell a, Cell b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return this.comparator.compareRows(a, b) <= 0 ? a : b;
    }

    protected Cell getNextRow(Cell key, NavigableSet<Cell> set) {
        Cell result = null;
        NavigableSet<Cell> tail = key == null ? set : set.tailSet(key);
        for (Cell cell : tail) {
            if (this.comparator.compareRows(cell, key) <= 0) continue;
            result = cell;
            break;
        }
        return result;
    }

    private Cell maybeCloneWithAllocator(Cell cell, boolean forceCloneOfBigCell) {
        return this.active.maybeCloneWithAllocator(cell, forceCloneOfBigCell);
    }

    private void internalAdd(Cell toAdd, boolean mslabUsed, MemStoreSizing memstoreSizing) {
        this.active.add(toAdd, mslabUsed, memstoreSizing);
        this.setOldestEditTimeToNow();
        this.checkActiveSize();
    }

    private void setOldestEditTimeToNow() {
        if (this.timeOfOldestEdit == Long.MAX_VALUE) {
            this.timeOfOldestEdit = EnvironmentEdgeManager.currentTime();
        }
    }

    protected abstract long keySize();

    protected abstract long heapSize();

    protected CellComparator getComparator() {
        return this.comparator;
    }

    @VisibleForTesting
    MutableSegment getActive() {
        return this.active;
    }

    @VisibleForTesting
    ImmutableSegment getSnapshot() {
        return this.snapshot;
    }

    protected abstract void checkActiveSize();

    protected abstract List<Segment> getSegments() throws IOException;

    static {
        DEEP_OVERHEAD = FIXED_OVERHEAD = (long)ClassSize.OBJECT + (long)(4 * ClassSize.REFERENCE) + 16L;
    }
}

