/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.functions.AggregateFunction;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.Event;

public final class DropAggregateStatement
extends SchemaAlteringStatement {
    private FunctionName functionName;
    private final boolean ifExists;
    private final List<CQL3Type.Raw> argRawTypes;
    private final boolean argsPresent;

    public DropAggregateStatement(FunctionName functionName, List<CQL3Type.Raw> argRawTypes, boolean argsPresent, boolean ifExists) {
        this.functionName = functionName;
        this.argRawTypes = argRawTypes;
        this.argsPresent = argsPresent;
        this.ifExists = ifExists;
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (!this.functionName.hasKeyspace() && state.getRawKeyspace() != null) {
            this.functionName = new FunctionName(state.getKeyspace(), this.functionName.name);
        }
        if (!this.functionName.hasKeyspace()) {
            throw new InvalidRequestException("Functions must be fully qualified with a keyspace name if a keyspace is not set for the session");
        }
        ThriftValidation.validateKeyspaceNotSystem(this.functionName.keyspace);
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasKeyspaceAccess(this.functionName.keyspace, Permission.DROP);
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
    }

    @Override
    public Event.SchemaChange announceMigration(QueryState queryState, boolean isLocalOnly) throws RequestValidationException {
        Collection<Function> olds = Schema.instance.getFunctions(this.functionName);
        if (!this.argsPresent && olds != null && olds.size() > 1) {
            throw new InvalidRequestException(String.format("'DROP AGGREGATE %s' matches multiple function definitions; specify the argument types by issuing a statement like 'DROP AGGREGATE %s (type, type, ...)'. Hint: use cqlsh 'DESCRIBE AGGREGATE %s' command to find all overloads", this.functionName, this.functionName, this.functionName));
        }
        Function old = null;
        if (this.argsPresent) {
            if (Schema.instance.getKSMetaData(this.functionName.keyspace) != null) {
                ArrayList argTypes = new ArrayList(this.argRawTypes.size());
                for (CQL3Type.Raw rawType : this.argRawTypes) {
                    argTypes.add(this.prepareType("arguments", rawType));
                }
                old = Schema.instance.findFunction(this.functionName, argTypes).orElse(null);
            }
            if (old == null || !(old instanceof AggregateFunction)) {
                if (this.ifExists) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                for (CQL3Type.Raw rawType : this.argRawTypes) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(rawType);
                }
                throw new InvalidRequestException(String.format("Cannot drop non existing aggregate '%s(%s)'", this.functionName, sb));
            }
        } else {
            if (olds == null || olds.isEmpty() || !(olds.iterator().next() instanceof AggregateFunction)) {
                if (this.ifExists) {
                    return null;
                }
                throw new InvalidRequestException(String.format("Cannot drop non existing aggregate '%s'", this.functionName));
            }
            old = olds.iterator().next();
        }
        if (old.isNative()) {
            throw new InvalidRequestException(String.format("Cannot drop aggregate '%s' because it is a native (built-in) function", this.functionName));
        }
        MigrationManager.announceAggregateDrop((UDAggregate)old, isLocalOnly);
        return new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, Event.SchemaChange.Target.AGGREGATE, old.name().keyspace, old.name().name, AbstractType.asCQLTypeStringList(old.argTypes()));
    }

    private AbstractType<?> prepareType(String typeName, CQL3Type.Raw rawType) {
        if (rawType.isFrozen()) {
            throw new InvalidRequestException(String.format("The function %s should not be frozen; remove the frozen<> modifier", typeName));
        }
        if (!rawType.canBeNonFrozen()) {
            rawType.freeze();
        }
        AbstractType<?> type = rawType.prepare(this.functionName.keyspace).getType();
        return type;
    }
}

