/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.log4j.Logger;
import org.ftp4che.io.BandwidthControlledInputStream;
import org.ftp4che.io.BandwidthControlledOutputStream;
import org.ftp4che.util.EasyX509TrustManager;

public class SSLSupport {
    private Socket socket;
    private SSLSocket sslSocket = null;
    private int mode;
    private static final Logger log = Logger.getLogger((String)SSLSupport.class.getName());
    private SSLContext context;
    private OutputStream out = null;
    private InputStream in = null;
    private byte[] readArray = new byte[16384];
    private boolean controllConnection;
    private int maxDownload;
    private int maxUpload;
    private TrustManager[] trustManagers = null;
    private KeyManager[] keyManagers = null;

    public SSLSupport(Socket socket, int mode, boolean controllConnection, int maxDownload, int maxUpload) {
        this.setMode(mode);
        this.setSocket(socket);
        this.setControllConnection(controllConnection);
        this.maxDownload = maxDownload;
        this.maxUpload = maxUpload;
    }

    public void initEngineAndBuffers() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, SSLException, IOException {
        this.context = this.mode == 3 || this.mode == 2 ? SSLContext.getInstance("SSL") : SSLContext.getInstance("TLS");
        if (this.trustManagers == null || this.trustManagers.length == 0) {
            this.trustManagers = new TrustManager[]{new EasyX509TrustManager(null)};
        }
        this.context.init(this.keyManagers, this.trustManagers, null);
        SSLSocketFactory sslFact = this.context.getSocketFactory();
        this.sslSocket = (SSLSocket)sslFact.createSocket(this.socket, this.socket.getInetAddress().getHostAddress(), this.socket.getPort(), true);
        this.out = this.maxUpload == Integer.MAX_VALUE || this.isControllConnection() ? this.sslSocket.getOutputStream() : new BandwidthControlledOutputStream(this.sslSocket.getOutputStream(), this.maxUpload);
        this.in = this.maxDownload == Integer.MAX_VALUE || this.isControllConnection() ? this.sslSocket.getInputStream() : new BandwidthControlledInputStream(this.sslSocket.getInputStream(), this.maxDownload);
        this.sslSocket.setEnableSessionCreation(true);
        this.sslSocket.setUseClientMode(true);
    }

    public void handshake() throws SSLException, IOException {
        log.debug((Object)"Starting handshake");
        this.sslSocket.startHandshake();
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int write(ByteBuffer src) throws IOException {
        int byteCount = src.remaining();
        this.out.write(src.array(), 0, byteCount);
        return byteCount;
    }

    public int read(ByteBuffer dst) throws IOException {
        int byteCount = 0;
        byteCount = this.isControllConnection() ? this.in.read(this.readArray, 0, dst.remaining()) : this.in.read(this.readArray);
        log.debug((Object)("Read -> " + byteCount + " byte"));
        if (byteCount <= 0) {
            return byteCount;
        }
        dst.put(this.readArray, dst.position(), byteCount);
        return byteCount;
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException ioe) {
            log.error((Object)ioe, (Throwable)ioe);
        }
    }

    public boolean isControllConnection() {
        return this.controllConnection;
    }

    public void setControllConnection(boolean controllConnection) {
        this.controllConnection = controllConnection;
    }

    public void setKeyManagers(KeyManager[] keyManagers) {
        this.keyManagers = keyManagers;
    }

    public void setTrustManagers(TrustManager[] trustManagers) {
        this.trustManagers = trustManagers;
    }
}

