/*
 * Decompiled with CFR 0.152.
 */
package org.ftp4che.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.log4j.Logger;
import org.ftp4che.io.BandwidthControlledInputStream;
import org.ftp4che.io.BandwidthControlledOutputStream;
import org.ftp4che.io.SSLSupport;
import org.ftp4che.proxy.Proxy;

public class SocketProvider {
    private SSLSupport supporter;
    private int sslMode = 1;
    private Socket socket = null;
    private static final Logger log = Logger.getLogger((String)SocketProvider.class.getName());
    private boolean isControllConnection = true;
    private OutputStream out = null;
    private InputStream in = null;
    private byte[] readArray = new byte[16384];
    int maxDownload;
    int maxUpload;

    public SocketProvider() {
        this.socket = new Socket();
    }

    public SocketProvider(boolean isControllConnection) throws IOException {
        this();
        this.setControllConnection(isControllConnection);
    }

    public SocketProvider(Socket socket, boolean isControllConnection) throws IOException {
        this(socket, isControllConnection, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public SocketProvider(Socket socket, boolean isControllConnection, int maxDownload, int maxUpload) throws IOException {
        this.setControllConnection(isControllConnection);
        this.maxDownload = maxDownload;
        this.maxUpload = maxUpload;
        this.socket = socket;
        this.initStreams();
    }

    private void initStreams() throws IOException {
        if (this.out == null) {
            this.out = this.maxUpload == Integer.MAX_VALUE || this.isControllConnection() ? this.socket.getOutputStream() : new BandwidthControlledOutputStream(this.socket.getOutputStream(), this.maxUpload);
        }
        if (this.in == null) {
            this.in = this.maxDownload == Integer.MAX_VALUE || this.isControllConnection() ? this.socket.getInputStream() : new BandwidthControlledInputStream(this.socket.getInputStream(), this.maxDownload);
        }
    }

    public void connect(SocketAddress remote, Proxy proxy, int maxDownload, int maxUpload) throws IOException {
        if (proxy == null) {
            this.socket.connect(remote);
        } else {
            InetSocketAddress isa = (InetSocketAddress)remote;
            this.socket = proxy.connect(isa.getAddress().getHostAddress(), isa.getPort());
        }
        this.maxDownload = maxDownload;
        this.maxUpload = maxUpload;
        this.initStreams();
    }

    public Socket socket() {
        return this.socket;
    }

    public boolean isConnected() {
        return this.socket.isConnected();
    }

    public boolean needsCrypt() {
        return (this.sslMode == 3 || this.sslMode == 4 || this.sslMode == 7 || this.sslMode == 6) && !this.isControllConnection() || this.sslMode != 1 && this.isControllConnection();
    }

    public void close() throws IOException {
        if (this.needsCrypt() && this.supporter != null) {
            this.supporter.close();
        }
        this.socket.close();
    }

    public int write(ByteBuffer src) throws IOException {
        if (this.needsCrypt()) {
            return this.supporter.write(src);
        }
        int byteCount = src.remaining();
        this.out.write(src.array(), 0, byteCount);
        return byteCount;
    }

    public int read(ByteBuffer dst) throws IOException {
        if (this.needsCrypt()) {
            return this.supporter.read(dst);
        }
        int byteCount = 0;
        byteCount = this.isControllConnection() ? this.in.read(this.readArray, 0, dst.remaining()) : this.in.read(this.readArray);
        log.debug((Object)("Read -> " + byteCount + " byte"));
        if (byteCount <= 0) {
            return byteCount;
        }
        dst.put(this.readArray, dst.position(), byteCount);
        return byteCount;
    }

    public String toString() {
        return this.socket.getInetAddress().getHostAddress() + ":" + this.socket.getPort();
    }

    public int getSSLMode() {
        return this.sslMode;
    }

    public void setSSLMode(int sslMode) {
        this.sslMode = sslMode;
    }

    public boolean isControllConnection() {
        return this.isControllConnection;
    }

    public void setControllConnection(boolean isControllConnection) {
        this.isControllConnection = isControllConnection;
    }

    public void negotiate(TrustManager[] trustManagers, KeyManager[] keyManagers) {
        try {
            this.supporter = new SSLSupport(this.socket, this.getSSLMode(), this.isControllConnection(), this.maxDownload, this.maxUpload);
            this.supporter.setTrustManagers(trustManagers);
            this.supporter.setKeyManagers(keyManagers);
            this.supporter.initEngineAndBuffers();
            this.supporter.handshake();
        }
        catch (Exception e) {
            log.fatal((Object)e, (Throwable)e);
        }
    }
}

