/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cpf.plugins.IPluginFilter;
import pt.webdetails.cpf.plugins.Plugin;
import pt.webdetails.cpf.plugins.PluginsAnalyzer;

public class CdePlugins {
    private static Log logger = LogFactory.getLog(CdePlugins.class);

    public String getCdePlugins() {
        JSONArray pluginsArray = new JSONArray();
        PluginsAnalyzer pluginsAnalyzer = new PluginsAnalyzer(CdeEnvironment.getContentAccessFactory(), (IPluginManager)PentahoSystem.get(IPluginManager.class));
        pluginsAnalyzer.refresh();
        IPluginFilter pluginFilter = new IPluginFilter(){

            public boolean include(Plugin plugin) {
                boolean include = false;
                if (plugin.hasSettingsXML()) {
                    include = plugin.getXmlValue("/settings/cde-compatible", "settings.xml").equals("true");
                }
                return include;
            }
        };
        List cdePlugins = pluginsAnalyzer.getPlugins(pluginFilter);
        for (Plugin plugin : cdePlugins) {
            try {
                JSONObject pluginObject = new JSONObject();
                pluginObject.put("title", (Object)plugin.getId());
                pluginObject.put("name", (Object)plugin.getName());
                pluginObject.put("description", (Object)plugin.getXmlValue("/settings/description", "settings.xml"));
                pluginObject.put("url", (Object)plugin.getXmlValue("/settings/url", "settings.xml"));
                pluginObject.put("jsPath", (Object)plugin.getXmlValue("/settings/jsPath", "settings.xml"));
                pluginObject.put("pluginId", (Object)plugin.getId());
                pluginsArray.put((Object)pluginObject);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        logger.debug((Object)"Feeding client with CDE-Compatible plugin list");
        return pluginsArray.toString();
    }
}

