/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd;

import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.engine.IParameterProvider;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.plugin.CorePlugin;
import pt.webdetails.cpf.plugincall.api.IPluginCall;
import pt.webdetails.cpf.plugincall.base.CallParameters;

public class InterPluginBroker {
    public static final String DATA_SOURCE_DEFINITION_METHOD_NAME = "listDataAccessTypes";

    public static String getCdfIncludes(String dashboard, String type, boolean debug, boolean absolute, String absRoot, String scheme) throws Exception {
        CallParameters params = new CallParameters();
        params.put("dashboardContent", dashboard);
        params.put("debug", debug);
        if (type != null) {
            params.put("dashboardType", type);
        }
        if (!StringUtils.isEmpty((String)absRoot)) {
            params.put("root", absRoot);
        }
        if (!StringUtils.isEmpty((String)scheme)) {
            params.put("scheme", scheme);
        }
        params.put("absolute", absolute);
        IPluginCall pluginCall = PluginEnvironment.env().getPluginCall(CorePlugin.CDF.getId(), "xcdf", "getHeaders");
        return pluginCall.call(params.getParameters());
    }

    public static String getDataSourceDefinitions(String plugin, String service, String method, boolean forceRefresh) throws Exception {
        CallParameters params = new CallParameters();
        params.put("refreshCache", forceRefresh);
        IPluginCall pluginCall = PluginEnvironment.env().getPluginCall(plugin, null, method);
        return pluginCall.call(params.getParameters());
    }

    public static String getCdfContext(String dashboard, String action, String view, IParameterProvider requestParams) throws Exception {
        CallParameters params = new CallParameters();
        params.put("path", dashboard);
        params.put("action", action);
        params.put("view", view);
        if (requestParams != null) {
            Iterator iterator = requestParams.getParameterNames();
            while (iterator.hasNext()) {
                Object paramValue;
                String paramName = (String)iterator.next();
                if (StringUtils.isEmpty((String)paramName) || !requestParams.hasParameter(paramName) || (paramValue = requestParams.getParameter(paramName)) == null) continue;
                params.put(paramName, StringUtils.join((Object[])((String[])paramValue), null, (int)0, (int)1));
            }
        }
        IPluginCall pluginCall = PluginEnvironment.env().getPluginCall(CorePlugin.CDF.getId(), "xcdf", "getContext");
        return pluginCall.call(params.getParameters());
    }

    public static String getCdfRequireContext(String dashboard, IParameterProvider requestParams) throws Exception {
        CallParameters params = new CallParameters();
        params.put("path", dashboard);
        if (requestParams != null) {
            Iterator iterator = requestParams.getParameterNames();
            while (iterator.hasNext()) {
                Object paramValue;
                String paramName = (String)iterator.next();
                if (StringUtils.isEmpty((String)paramName) || !requestParams.hasParameter(paramName) || (paramValue = requestParams.getParameter(paramName)) == null) continue;
                params.put(paramName, StringUtils.join((Object[])((String[])paramValue), null, (int)0, (int)1));
            }
        }
        IPluginCall pluginCall = PluginEnvironment.env().getPluginCall(CorePlugin.CDF.getId(), "context", "get");
        return pluginCall.call(params.getParameters());
    }

    public static String getCdfRequireConfig(String dashboard, IParameterProvider requestParams) throws Exception {
        CallParameters params = new CallParameters();
        params.put("path", dashboard);
        if (requestParams != null) {
            Iterator iterator = requestParams.getParameterNames();
            while (iterator.hasNext()) {
                Object paramValue;
                String paramName = (String)iterator.next();
                if (StringUtils.isEmpty((String)paramName) || !requestParams.hasParameter(paramName) || (paramValue = requestParams.getParameter(paramName)) == null) continue;
                params.put(paramName, StringUtils.join((Object[])((String[])paramValue), null, (int)0, (int)1));
            }
        }
        IPluginCall pluginCall = PluginEnvironment.env().getPluginCall(CorePlugin.CDF.getId(), "context", "getConfig");
        return pluginCall.call(params.getParameters());
    }

    public static String getCdfEmbed(String protocol, String name, int port, int inactiveInterval, String locale, IParameterProvider requestParams) throws Exception {
        return InterPluginBroker.getCdfEmbed(protocol, name, port, inactiveInterval, locale, false, requestParams);
    }

    public static String getCdfEmbed(String protocol, String name, int port, int inactiveInterval, String locale, boolean secure, IParameterProvider requestParams) throws Exception {
        CallParameters params = new CallParameters();
        params.put("protocol", protocol);
        params.put("name", name);
        params.put("port", port);
        params.put("inactiveInterval", inactiveInterval);
        params.put("locale", locale);
        params.put("secure", secure);
        if (requestParams != null) {
            Iterator iterator = requestParams.getParameterNames();
            while (iterator.hasNext()) {
                Object paramValue;
                String paramName = (String)iterator.next();
                if (StringUtils.isEmpty((String)paramName) || !requestParams.hasParameter(paramName) || (paramValue = requestParams.getParameter(paramName)) == null) continue;
                params.put(paramName, StringUtils.join((Object[])((String[])paramValue), null, (int)0, (int)1));
            }
        }
        IPluginCall pluginCall = PluginEnvironment.env().getPluginCall(CorePlugin.CDF.getId(), "cdfApi", "buildCdfEmbedContextSecure");
        return pluginCall.call(params.getParameters());
    }
}

