/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import pt.webdetails.cdf.dd.api.XSSHelper;
import pt.webdetails.cdf.dd.reader.factory.IResourceLoader;
import pt.webdetails.cdf.dd.reader.factory.ResourceLoaderFactory;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.JsonUtils;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.repository.api.FileAccess;
import pt.webdetails.cpf.repository.api.IACAccess;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.utils.CharsetHelper;

@Path(value="pentaho-cdf-dd/api/editor")
public class EditorApi {
    private static final int NO_CACHE_DURATION = 0;
    private static final Log logger = LogFactory.getLog(EditorApi.class);
    private static final String EXTERNAL_EDITOR_PAGE = "resources/ext-editor.html";
    private static final String COMPONENT_EDITOR_PAGE = "resources/cdf-dd-component-editor.html";

    @GET
    @Path(value="/file/get")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"text/plain"})
    public String getFile(@QueryParam(value="path") @DefaultValue(value="") String path, @Context HttpServletResponse response) throws IOException {
        boolean canGetFile;
        path = this.decodeAndEscape(path);
        IResourceLoader loader = this.getResourceLoader(path);
        IACAccess contentAccess = loader.getAccessControl();
        IReadAccess reader = loader.getReader();
        boolean bl = canGetFile = reader.fileExists(path) && contentAccess.hasAccess(path, FileAccess.READ);
        if (!canGetFile) {
            String errorMessage = "File: " + path + " does not exist, or you do not have permissions to access it";
            logger.error((Object)errorMessage);
            return errorMessage;
        }
        response.setHeader("Cache-Control", "max-age=0");
        return IOUtils.toString((InputStream)reader.getFileInputStream(path));
    }

    @POST
    @Path(value="/file/delete")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"text/javascript"})
    public void deleteFile(@FormParam(value="path") @DefaultValue(value="") String path, @Context HttpServletResponse response) throws IOException, JSONException {
        path = this.decodeAndEscape(path);
        IResourceLoader loader = this.getResourceLoader(path);
        IACAccess access = loader.getAccessControl();
        IRWAccess writer = loader.getWriter();
        boolean fileDeleted = access.hasAccess(path, FileAccess.DELETE) && writer.deleteFile(path);
        String message = "File: " + path + (fileDeleted ? "" : "not") + " removed";
        logger.debug((Object)message);
        JsonUtils.buildJsonResult((OutputStream)response.getOutputStream(), (Boolean)fileDeleted, null);
    }

    @POST
    @Path(value="/file/write")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public String writeFile(@FormParam(value="path") @DefaultValue(value="") String path, @FormParam(value="data") @DefaultValue(value="") String data, @Context HttpServletResponse response) throws IOException {
        path = this.decodeAndEscape(path);
        IResourceLoader loader = this.getResourceLoader(path);
        return this.writeFile(path, loader, data);
    }

    @PUT
    @Path(value="/file/write")
    @Consumes(value={"application/xml", "application/json", "application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public String createFile(@FormParam(value="path") @DefaultValue(value="") String path, @FormParam(value="data") @DefaultValue(value="") String data, @Context HttpServletResponse response) throws IOException {
        path = this.decodeAndEscape(path);
        IResourceLoader loader = this.getResourceLoader(path);
        return this.writeFile(path, FilenameUtils.getFullPath((String)path), loader, data);
    }

    @GET
    @Path(value="/file/canEdit")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"text/plain"})
    public String canEdit(@QueryParam(value="path") @DefaultValue(value="") String path) {
        path = this.decodeAndEscape(path);
        IResourceLoader loader = this.getResourceLoader(path);
        IACAccess contentAccess = loader.getAccessControl();
        return String.valueOf(contentAccess.hasAccess(path, FileAccess.WRITE));
    }

    @POST
    @Path(value="/createFolder")
    @Consumes(value={"application/xml", "application/json"})
    public String createFolder(@FormParam(value="path") @DefaultValue(value="") String path, @Context HttpServletResponse response) {
        String message;
        IResourceLoader loader = this.getResourceLoader(path = this.decodeAndEscape(path));
        IACAccess access = loader.getAccessControl();
        if (access.hasAccess(path, FileAccess.WRITE)) {
            IReadAccess reader = loader.getReader();
            if (reader.fileExists(path)) {
                message = "already exists: " + path;
                logger.debug((Object)message);
            } else {
                IRWAccess writer = loader.getWriter();
                if (writer.createFolder(path)) {
                    message = path + "created ok";
                    logger.debug((Object)message);
                } else {
                    message = "error creating folder " + path;
                    logger.debug((Object)message);
                }
            }
        } else {
            message = "no permissions to create folder " + path;
            logger.error((Object)message);
        }
        return message;
    }

    @GET
    @Path(value="/getExternalEditor")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"text/html"})
    public String externalEditor() throws IOException {
        IReadAccess access = CdeEnvironment.getPluginSystemReader();
        boolean externalEditorExists = access.fileExists(EXTERNAL_EDITOR_PAGE);
        if (!externalEditorExists) {
            String errorMessage = "External editor not found: resources/ext-editor.html";
            logger.error((Object)"External editor not found: resources/ext-editor.html");
            return "External editor not found: resources/ext-editor.html";
        }
        return IOUtils.toString((InputStream)access.getFileInputStream(EXTERNAL_EDITOR_PAGE));
    }

    @GET
    @Path(value="/getComponentEditor")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"text/html"})
    public String componentEditor() throws IOException {
        IReadAccess access = CdeEnvironment.getPluginSystemReader();
        boolean componentEditorExists = access.fileExists(COMPONENT_EDITOR_PAGE);
        if (!componentEditorExists) {
            String errorMessage = "no external editor found: resources/cdf-dd-component-editor.html";
            logger.error((Object)"no external editor found: resources/cdf-dd-component-editor.html");
            return "no external editor found: resources/cdf-dd-component-editor.html";
        }
        return IOUtils.toString((InputStream)access.getFileInputStream(COMPONENT_EDITOR_PAGE));
    }

    protected IResourceLoader getResourceLoader(String path) {
        return new ResourceLoaderFactory().getResourceLoader(path);
    }

    private String writeFile(String path, IResourceLoader loader, String data) throws IOException {
        return this.writeFile(path, path, loader, data);
    }

    private String writeFile(String path, String fullPath, IResourceLoader loader, String data) throws IOException {
        String message;
        IACAccess access = loader.getAccessControl();
        if (access.hasAccess(fullPath, FileAccess.WRITE)) {
            ByteArrayInputStream content;
            IRWAccess writer = loader.getWriter();
            if (writer.saveFile(path, (InputStream)(content = new ByteArrayInputStream(data.getBytes(CharsetHelper.getEncoding()))))) {
                message = "file '" + path + "' saved ok";
                logger.debug((Object)message);
            } else {
                message = "error saving file " + path;
                logger.error((Object)message);
            }
        } else {
            message = "no permissions to write file " + path;
            logger.error((Object)message);
        }
        return message;
    }

    private String decodeAndEscape(String path) {
        XSSHelper helper = XSSHelper.getInstance();
        return helper.escape(Utils.getURLDecoded((String)path));
    }

    private class MethodParams {
        public static final String PATH = "path";
        public static final String DATA = "data";

        private MethodParams() {
        }
    }
}

