/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.web.http.api.resources.PluginResource;
import pt.webdetails.cdf.dd.CdeSettings;
import pt.webdetails.cdf.dd.api.XSSHelper;
import pt.webdetails.cdf.dd.reader.factory.IResourceLoader;
import pt.webdetails.cdf.dd.reader.factory.ResourceLoaderFactory;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.GenericBasicFileFilter;
import pt.webdetails.cdf.dd.util.GenericFileAndDirectoryFilter;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.MimeTypeHandler;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IBasicFileFilter;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.repository.util.RepositoryHelper;
import pt.webdetails.cpf.utils.PluginIOUtils;

@Path(value="pentaho-cdf-dd/api/resources")
public class ResourcesApi {
    private static final Log logger = LogFactory.getLog(ResourcesApi.class);
    private static final List<String> allowedExtensions;

    @GET
    @Path(value="/get")
    @Produces(value={"text/plain"})
    public void getResource(@QueryParam(value="resource") @DefaultValue(value="") String resource, @Context HttpServletResponse response) throws IOException {
        resource = this.decodeAndEscape(resource);
        try {
            String mimeType;
            String extension = resource.replaceAll(".*\\.(.*)", "$1");
            if (allowedExtensions.indexOf(extension) < 0) {
                logger.error((Object)("Extension '" + extension + "' not whitelisted"));
                throw new SecurityException("Not allowed");
            }
            IBasicFile file = Utils.getFileViaAppropriateReadAccess((String)resource);
            if (file == null) {
                logger.error((Object)("resource not found:" + resource));
                response.sendError(500);
                return;
            }
            IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
            String maxAge = resLoader.getPluginSetting(this.getClass(), "max-age");
            try {
                mimeType = MimeTypeHandler.getMimeTypeFromExtension((String)file.getExtension());
            }
            catch (EnumConstantNotPresentException | IllegalArgumentException ex) {
                mimeType = "";
            }
            response.setHeader("Content-Type", mimeType);
            response.setHeader("content-disposition", "inline; filename=\"" + file.getName() + "\"");
            if (maxAge != null) {
                response.setHeader("Cache-Control", "max-age=" + maxAge);
            }
            PluginIOUtils.writeOutAndFlush((OutputStream)response.getOutputStream(), (InputStream)file.getContents());
        }
        catch (SecurityException e) {
            response.sendError(403);
        }
    }

    @GET
    @Path(value="/getCss")
    @Produces(value={"text/css"})
    public void getCssResource(@QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="resource") @DefaultValue(value="") String resource, @Context HttpServletResponse response) throws IOException {
        resource = this.decodeAndEscape(resource);
        this.getResource(resource, response);
    }

    @GET
    @Path(value="/getJs")
    @Produces(value={"text/javascript"})
    public void getJsResource(@QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="resource") @DefaultValue(value="") String resource, @Context HttpServletResponse response) throws IOException {
        resource = this.decodeAndEscape(resource);
        this.getResource(resource, response);
    }

    @GET
    @Path(value="/getUntyped")
    @Produces(value={"text/plain"})
    public void getUntypedResource(@QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="resource") @DefaultValue(value="") String resource, @Context HttpServletResponse response) throws IOException {
        resource = this.decodeAndEscape(resource);
        response.setHeader("content-disposition", "inline");
        this.getResource(resource, response);
    }

    @GET
    @Path(value="/getImg")
    @Produces(value={"text/plain"})
    public void getImage(@QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="resource") @DefaultValue(value="") String resource, @Context HttpServletResponse response) throws IOException {
        resource = this.decodeAndEscape(resource);
        this.getResource(resource, response);
    }

    @GET
    @Path(value="/res")
    @Produces(value={"text/plain"})
    public void res(@QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="resource") @DefaultValue(value="") String resource, @Context HttpServletResponse response) throws Exception {
        resource = this.decodeAndEscape(resource);
        this.getResource(resource, response);
    }

    @POST
    @Path(value="/explore")
    @Produces(value={"text/plain"})
    public String exploreFolder(@FormParam(value="dir") @DefaultValue(value="/") String folder, @FormParam(value="outputType") String outputType, @QueryParam(value="dashboardPath") @DefaultValue(value="") String dashboardPath, @QueryParam(value="fileExtensions") String fileExtensions, @QueryParam(value="access") String access, @QueryParam(value="showHiddenFiles") @DefaultValue(value="false") boolean showHiddenFiles) {
        folder = this.decodeAndEscape(folder);
        outputType = this.decodeAndEscape(outputType);
        dashboardPath = this.decodeAndEscape(dashboardPath);
        fileExtensions = this.decodeAndEscape(fileExtensions);
        if (!StringUtils.isEmpty((String)outputType) && outputType.equals("json")) {
            try {
                IBasicFile[] files = this.getFileList(folder, dashboardPath, fileExtensions, showHiddenFiles);
                return RepositoryHelper.toJSON((String)folder, (IBasicFile[])files);
            }
            catch (JSONException e) {
                logger.error((Object)("exploreFolder" + folder), (Throwable)e);
                return "Error getting files in folder " + folder;
            }
        }
        IBasicFile[] files = this.getFileList(folder, dashboardPath, fileExtensions, showHiddenFiles);
        return RepositoryHelper.toJQueryFileTree((String)folder, (IBasicFile[])files);
    }

    private IBasicFile[] getFileList(String dir, String dashboardPath, String fileExtensions, boolean showHiddenFiles) {
        List fileList;
        String path;
        ArrayList<String> extensionsList = new ArrayList<String>();
        String[] extensions = StringUtils.split((String)fileExtensions, (String)".");
        if (extensions != null) {
            for (String extension : extensions) {
                extensionsList.add("." + extension);
                extensionsList.add(extension);
            }
        }
        GenericBasicFileFilter fileFilter = new GenericBasicFileFilter(null, extensionsList.toArray(new String[extensionsList.size()]), true);
        boolean isSystem = false;
        if (!dashboardPath.isEmpty() && (path = dashboardPath.toLowerCase().replaceFirst("/", "")).startsWith(CdeEnvironment.getSystemDir() + "/")) {
            isSystem = true;
        }
        IResourceLoader loader = this.getResourceLoader(dashboardPath);
        IReadAccess access = loader.getReader();
        GenericFileAndDirectoryFilter fileAndDirFilter = new GenericFileAndDirectoryFilter(fileFilter);
        if (isSystem) {
            if (!this.isAdministrator()) {
                fileAndDirFilter.setDirectories(CdeSettings.getFilePickerHiddenFolderPaths(CdeSettings.FolderType.STATIC));
                fileAndDirFilter.setFilterType(GenericFileAndDirectoryFilter.FilterType.FILTER_OUT);
            }
            fileList = access.listFiles(dir, (IBasicFileFilter)fileAndDirFilter, 1, true, false);
            fileList.remove(0);
        } else {
            if (!this.isAdministrator()) {
                fileAndDirFilter.setDirectories(CdeSettings.getFilePickerHiddenFolderPaths(CdeSettings.FolderType.REPO));
                fileAndDirFilter.setFilterType(GenericFileAndDirectoryFilter.FilterType.FILTER_OUT);
            }
            fileList = access.listFiles(dir, (IBasicFileFilter)fileAndDirFilter, 1, true, showHiddenFiles);
        }
        if (fileList != null && fileList.size() > 0) {
            return fileList.toArray(new IBasicFile[fileList.size()]);
        }
        return new IBasicFile[0];
    }

    @GET
    @Path(value="/system/{path: [^?]+ }")
    @Produces(value={"*/*"})
    public Response getSystemResource(@PathParam(value="path") String path, @Context HttpServletResponse response) throws IOException {
        Response readFileResponse;
        String extension = (path = this.decodeAndEscape(path)).replaceAll(".*\\.(.*)", "$1");
        if (allowedExtensions.indexOf(extension) < 0) {
            logger.error((Object)("Extension '" + extension + "' not whitelisted"));
            throw new SecurityException("Not allowed");
        }
        String[] splitPath = path.split("/");
        String pluginId = splitPath[0];
        StringBuilder resource = new StringBuilder();
        for (int i = 1; i < splitPath.length; ++i) {
            resource.append("/").append(splitPath[i]);
        }
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class);
        if (!StringUtils.isEmpty((String)path) && pluginManager.isPublic(pluginId, resource.toString()) && (readFileResponse = new PluginResource(response).readFile(pluginId, resource.toString())).getStatus() != Response.Status.NOT_FOUND.getStatusCode()) {
            return readFileResponse;
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{resource: [^?]+ }")
    @Produces(value={"*/*"})
    public void resource(@PathParam(value="resource") String resource, @Context HttpServletResponse response) throws Exception {
        resource = this.decodeAndEscape(resource);
        this.getResource(resource, response);
    }

    protected boolean isAdministrator() {
        return SecurityHelper.getInstance().isPentahoAdministrator(PentahoSessionHolder.getSession());
    }

    private IResourceLoader getResourceLoader(String path) {
        return new ResourceLoaderFactory().getResourceLoader(path);
    }

    private String decodeAndEscape(String path) {
        XSSHelper helper = XSSHelper.getInstance();
        return helper.escape(Utils.getURLDecoded((String)path));
    }

    static {
        String formats = ((IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null)).getPluginSetting(ResourcesApi.class, "settings/resources/downloadable-formats");
        allowedExtensions = Arrays.asList(StringUtils.split((String)formats, (char)','));
    }
}

