/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.api;

import com.sun.jersey.multipart.FormDataParam;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import pt.webdetails.cdf.dd.DashboardDesignerException;
import pt.webdetails.cdf.dd.Messages;
import pt.webdetails.cdf.dd.api.XSSHelper;
import pt.webdetails.cdf.dd.cdf.CdfStyles;
import pt.webdetails.cdf.dd.cdf.CdfTemplates;
import pt.webdetails.cdf.dd.structure.DashboardStructure;
import pt.webdetails.cdf.dd.structure.DashboardStructureException;
import pt.webdetails.cdf.dd.util.JsonUtils;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.utils.CharsetHelper;

@Path(value="pentaho-cdf-dd/api/syncronizer")
public class SyncronizerApi {
    private static final Log logger = LogFactory.getLog(SyncronizerApi.class);
    private static final String OPERATION_LOAD = "load";
    private static final String OPERATION_DELETE = "delete";
    private static final String OPERATION_DELETE_PREVIEW = "deletepreview";
    private static final String OPERATION_SAVE = "save";
    private static final String OPERATION_SAVE_AS = "saveas";
    private static final String OPERATION_NEW_FILE = "newfile";
    private static final String OPERATION_SAVE_SETTINGS = "savesettings";
    private static final String GET_RESOURCE = "api/resources/get?resource=";
    public static final String UNSAVED_FILE_PATH = "null/null/null";

    @POST
    @Path(value="/syncronizeDashboard")
    @Produces(value={"application/json"})
    public String syncronize(@FormParam(value="file") @DefaultValue(value="") String file, @FormParam(value="path") @DefaultValue(value="") String path, @FormParam(value="title") @DefaultValue(value="") String title, @FormParam(value="author") @DefaultValue(value="") String author, @FormParam(value="description") @DefaultValue(value="") String description, @FormParam(value="style") @DefaultValue(value="") String style, @FormParam(value="widgetName") @DefaultValue(value="") String widgetName, @FormParam(value="widget") boolean widget, @FormParam(value="rendererType") @DefaultValue(value="") String rendererType, @FormParam(value="widgetParameters") List<String> widgetParams, @FormParam(value="cdfstructure") String cdfStructure, @FormParam(value="operation") String operation, @FormParam(value="require") boolean require, @Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) throws Exception {
        XSSHelper xssHelper = XSSHelper.getInstance();
        file = xssHelper.escape(file);
        title = xssHelper.escape(title);
        author = xssHelper.escape(author);
        description = xssHelper.escape(description);
        style = xssHelper.escape(style);
        widgetName = xssHelper.escape(widgetName);
        rendererType = xssHelper.escape(rendererType);
        cdfStructure = xssHelper.escape(cdfStructure);
        operation = xssHelper.escape(operation);
        if (null != widgetParams) {
            for (int i = 0; i < widgetParams.size(); ++i) {
                widgetParams.add(i, xssHelper.escape(widgetParams.get(i)));
            }
        }
        servletResponse.setContentType("application/json");
        servletResponse.setCharacterEncoding(CharsetHelper.getEncoding());
        boolean isPreview = false;
        if (!file.isEmpty() && !file.equals(UNSAVED_FILE_PATH)) {
            isPreview = (file = Utils.getURLDecoded((String)file, (String)CharsetHelper.getEncoding())).contains("_tmp.cdfde") || file.contains("_tmp.wcdf");
            IRWAccess rwAccess = Utils.getSystemOrUserRWAccess((String)file);
            if (rwAccess == null) {
                String msg = "Access denied for the synchronize method syncronizeDashboard." + operation + " : " + file;
                logger.warn((Object)msg);
                return JsonUtils.getJsonResult((boolean)false, (Object)msg);
            }
        }
        try {
            String[] widgetParameters;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("file", file);
            params.put("widget", String.valueOf(widget));
            params.put("require", String.valueOf(require));
            if (!author.isEmpty()) {
                params.put("author", author);
            }
            if (!style.isEmpty()) {
                params.put("style", style);
            }
            if (!widgetName.isEmpty()) {
                params.put("widgetName", widgetName);
            }
            if (!rendererType.isEmpty()) {
                params.put("rendererType", rendererType);
            }
            if (!title.isEmpty()) {
                params.put("title", title);
            }
            if (!description.isEmpty()) {
                params.put("description", description);
            }
            if ((widgetParameters = widgetParams.toArray(new String[0])).length > 0) {
                params.put("widgetParameters", widgetParameters);
            }
            String wcdfdeFile = file.replace(".wcdf", ".cdfde");
            DashboardStructure dashboardStructure = new DashboardStructure();
            HashMap result = null;
            if (OPERATION_LOAD.equalsIgnoreCase(operation)) {
                return dashboardStructure.load(wcdfdeFile);
            }
            if (OPERATION_DELETE.equalsIgnoreCase(operation)) {
                dashboardStructure.delete(params);
            } else if (OPERATION_DELETE_PREVIEW.equalsIgnoreCase(operation)) {
                dashboardStructure.deletePreviewFiles(wcdfdeFile);
            } else if (OPERATION_SAVE.equalsIgnoreCase(operation)) {
                result = dashboardStructure.save(file, cdfStructure);
            } else if (OPERATION_SAVE_AS.equalsIgnoreCase(operation)) {
                if (StringUtils.isEmpty((String)title)) {
                    title = FilenameUtils.getBaseName((String)file);
                }
                result = dashboardStructure.saveAs(file, title, description, cdfStructure, isPreview);
            } else if (OPERATION_NEW_FILE.equalsIgnoreCase(operation)) {
                dashboardStructure.newfile(params);
            } else if (OPERATION_SAVE_SETTINGS.equalsIgnoreCase(operation)) {
                if (StringUtils.isEmpty((String)file) || file.equals(UNSAVED_FILE_PATH)) {
                    logger.warn((Object)this.getMessage("CdfTemplates.ERROR_003_SAVE_DASHBOARD_FIRST"));
                    return JsonUtils.getJsonResult((boolean)false, (Object)this.getMessage("CdfTemplates.ERROR_003_SAVE_DASHBOARD_FIRST"));
                }
                result = dashboardStructure.saveSettingsToWcdf(params);
            } else {
                logger.error((Object)("Unknown operation: " + operation));
            }
            return JsonUtils.getJsonResult((boolean)true, result);
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                this.handleDashboardStructureException(e, (OutputStream)servletResponse.getOutputStream());
            }
            throw e;
        }
    }

    @POST
    @Path(value="/syncronizeTemplates")
    @Produces(value={"application/json"})
    public void syncTemplates(@FormParam(value="operation") String operation, @FormParam(value="file") String file, @FormParam(value="cdfstructure") String cdfStructure, @FormParam(value="rendererType") String rendererType, @Context HttpServletResponse servletResponse) throws IOException, DashboardStructureException, JSONException {
        XSSHelper xssHelper = XSSHelper.getInstance();
        file = xssHelper.escape(file);
        rendererType = xssHelper.escape(rendererType);
        cdfStructure = xssHelper.escape(cdfStructure);
        operation = xssHelper.escape(operation);
        servletResponse.setContentType("application/json");
        servletResponse.setCharacterEncoding(CharsetHelper.getEncoding());
        Object result = null;
        if (OPERATION_LOAD.equalsIgnoreCase(operation)) {
            result = new CdfTemplates(GET_RESOURCE).load(rendererType);
        } else if (OPERATION_SAVE.equalsIgnoreCase(operation)) {
            new CdfTemplates(GET_RESOURCE).save(file, cdfStructure, rendererType);
        }
        JsonUtils.buildJsonResult((OutputStream)servletResponse.getOutputStream(), (Boolean)true, (Object)result);
    }

    @GET
    @Path(value="/syncronizeStyles")
    @Produces(value={"application/json"})
    public void syncStyles(@Context HttpServletResponse servletResponse) throws IOException, DashboardDesignerException, JSONException {
        servletResponse.setContentType("application/json");
        servletResponse.setCharacterEncoding(CharsetHelper.getEncoding());
        this.listStyles(servletResponse);
    }

    @POST
    @Path(value="/saveDashboard")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public String saveDashboard(@FormDataParam(value="file") @DefaultValue(value="") String file, @FormDataParam(value="title") @DefaultValue(value="") String title, @FormDataParam(value="description") @DefaultValue(value="") String description, @FormDataParam(value="cdfstructure") String cdfStructure, @FormDataParam(value="operation") String operation, @Context HttpServletResponse response) throws Exception {
        XSSHelper xssHelper = XSSHelper.getInstance();
        file = xssHelper.escape(file);
        title = xssHelper.escape(title);
        description = xssHelper.escape(description);
        cdfStructure = xssHelper.escape(cdfStructure);
        operation = xssHelper.escape(operation);
        response.setContentType("application/json");
        response.setCharacterEncoding(CharsetHelper.getEncoding());
        boolean isPreview = false;
        if (!(file.isEmpty() || file.equals(UNSAVED_FILE_PATH) || Utils.getURLDecoded((String)file).equals(UNSAVED_FILE_PATH))) {
            file = Utils.getURLDecoded((String)file, (String)CharsetHelper.getEncoding());
            if (StringUtils.isEmpty((String)title)) {
                title = FilenameUtils.getBaseName((String)file);
            }
            String fileDir = file.contains(".wcdf") || file.contains(".cdfde") ? file.substring(0, file.lastIndexOf("/")) : file;
            isPreview = file.contains("_tmp.cdfde") || file.contains("_tmp.wcdf");
            IRWAccess rwAccess = OPERATION_SAVE_AS.equalsIgnoreCase(operation) && !isPreview ? Utils.getSystemOrUserRWAccess((String)fileDir) : Utils.getSystemOrUserRWAccess((String)file);
            if (rwAccess == null) {
                String msg = "Access denied for the syncronize method saveDashboard." + operation + " : " + file;
                logger.warn((Object)msg);
                return JsonUtils.getJsonResult((boolean)false, (Object)msg);
            }
        }
        try {
            DashboardStructure dashboardStructure = new DashboardStructure();
            HashMap result = null;
            if (OPERATION_SAVE.equalsIgnoreCase(operation)) {
                result = dashboardStructure.save(file, cdfStructure);
            } else if (OPERATION_SAVE_AS.equalsIgnoreCase(operation)) {
                result = dashboardStructure.saveAs(file, title, description, cdfStructure, isPreview);
            } else {
                logger.error((Object)("Unknown operation: " + operation));
            }
            return JsonUtils.getJsonResult((boolean)true, (Object)result);
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                this.handleDashboardStructureException(e, (OutputStream)response.getOutputStream());
            }
            throw e;
        }
    }

    protected String getMessage(String key) {
        return Messages.getString((String)key);
    }

    protected void listStyles(HttpServletResponse servletResponse) throws IOException, DashboardDesignerException, JSONException {
        CdfStyles cdfStyles = new CdfStyles();
        JsonUtils.buildJsonResult((OutputStream)servletResponse.getOutputStream(), (Boolean)true, (Object)cdfStyles.liststyles());
    }

    private void handleDashboardStructureException(Exception e, OutputStream out) throws Exception {
        Throwable cause = e.getCause();
        if (cause instanceof DashboardStructureException) {
            JsonUtils.buildJsonResult((OutputStream)out, (Boolean)false, (Object)cause.getMessage());
        } else if (e instanceof InvocationTargetException) {
            throw (Exception)cause;
        }
    }

    private class MethodParams {
        private static final String FILE = "file";
        private static final String PATH = "path";
        private static final String TITLE = "title";
        private static final String AUTHOR = "author";
        private static final String DESCRIPTION = "description";
        private static final String STYLE = "style";
        private static final String OPERATION = "operation";
        private static final String RENDERER_TYPE = "rendererType";
        private static final String WIDGET = "widget";
        private static final String WIDGET_NAME = "widgetName";
        private static final String WIDGET_PARAMETERS = "widgetParameters";
        private static final String DASHBOARD_STRUCTURE = "cdfstructure";
        private static final String REQUIRE = "require";

        private MethodParams() {
        }
    }
}

