/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.cache.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import pt.webdetails.cdf.dd.DashboardCacheKey;
import pt.webdetails.cdf.dd.cache.api.ICache;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteResult;
import pt.webdetails.cpf.exceptions.InitializationException;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;

public final class Cache
implements ICache {
    private static final String CACHE_CFG_FILE = "ehcache.xml";
    private static final String CACHE_NAME = "pentaho-cde";
    private Ehcache ehcache;

    public Cache(IContentAccessFactory contentAccessFactory) throws InitializationException {
        CacheManager cacheManager;
        try {
            cacheManager = CacheManager.create((InputStream)contentAccessFactory.getPluginSystemReader(null).getFileInputStream(CACHE_CFG_FILE));
        }
        catch (IOException e) {
            throw new InitializationException("Failed to load the cache configuration file: ehcache.xml", (Exception)e);
        }
        catch (CacheException e) {
            throw new InitializationException("Failed to create the cache manager.", (Exception)((Object)e));
        }
        System.setProperty("net.sf.ehcache.enableShutdownHook", "true");
        if (!cacheManager.cacheExists(CACHE_NAME)) {
            cacheManager.addCache(CACHE_NAME);
        }
        this.ehcache = cacheManager.getCache(CACHE_NAME);
    }

    public CdfRunJsDashboardWriteResult get(DashboardCacheKey key) {
        Element element = this.ehcache.get((Serializable)key);
        if (element != null) {
            return (CdfRunJsDashboardWriteResult)element.getValue();
        }
        return null;
    }

    public List<DashboardCacheKey> getKeys() {
        return this.ehcache.getKeys();
    }

    public void remove(DashboardCacheKey key) {
        this.ehcache.remove((Serializable)key);
    }

    public void removeAll() {
        this.ehcache.removeAll();
    }

    public void put(DashboardCacheKey key, CdfRunJsDashboardWriteResult value) {
        Element element = new Element((Serializable)key, (Serializable)value);
        this.ehcache.put(element);
    }
}

