/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.datasources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import pt.webdetails.cdf.dd.datasources.DataSourceProvider;
import pt.webdetails.cdf.dd.datasources.IDataSourceManager;
import pt.webdetails.cdf.dd.datasources.IDataSourceProvider;
import pt.webdetails.cdf.dd.datasources.InvalidDataSourceProviderException;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cpf.plugins.PluginsAnalyzer;

public class DataSourceManager
implements IDataSourceManager {
    public static final String CDE_DATASOURCE_IDENTIFIER = "cde-datasources";
    private static Log logger = LogFactory.getLog(DataSourceManager.class);
    private static DataSourceManager instance;
    private final Map<String, DataSourceProvider> providersById = new LinkedHashMap<String, DataSourceProvider>();
    private final Map<String, JSONObject> providerDefinitionsById = new HashMap<String, JSONObject>();
    private boolean _isRefresh;

    public static DataSourceManager getInstance() {
        if (instance == null) {
            instance = new DataSourceManager();
        }
        return instance;
    }

    private DataSourceManager() {
        this.init(false);
    }

    private List<DataSourceProvider> readProviders() {
        ArrayList<DataSourceProvider> dataSourceProviders = new ArrayList<DataSourceProvider>();
        PluginsAnalyzer pluginsAnalyzer = new PluginsAnalyzer(CdeEnvironment.getContentAccessFactory(), (IPluginManager)PentahoSystem.get(IPluginManager.class));
        pluginsAnalyzer.refresh();
        List pluginsWithEntity = pluginsAnalyzer.getRegisteredEntities("/cde-datasources");
        for (PluginsAnalyzer.PluginWithEntity entity : pluginsWithEntity) {
            String provider = entity.getPlugin().getId();
            try {
                DataSourceProvider ds = new DataSourceProvider(provider);
                dataSourceProviders.add(ds);
                logger.debug((Object)String.format("Found valid CDE Data Source provider: %s", ds));
            }
            catch (InvalidDataSourceProviderException e) {
                logger.error((Object)String.format("Found invalid CDE Data Source provider in plugin %s.", provider));
            }
        }
        return dataSourceProviders;
    }

    public JSONObject getJsDefinition() throws JSONException {
        JSONObject dsSpec = new JSONObject();
        for (IDataSourceProvider provider : this.getProviders()) {
            JSONObject obj;
            JSONObject dsDefinition = this.getProviderJsDefinition(provider.getId());
            if (dsDefinition == null || dsDefinition.length() <= 0 || !(dsDefinition instanceof JSONObject) || (obj = dsDefinition).equals(JSONObject.NULL)) continue;
            for (String key : JSONObject.getNames((JSONObject)obj)) {
                dsSpec.put(key, obj.get(key));
            }
        }
        return dsSpec;
    }

    public JSONObject getProviderJsDefinition(String providerId) {
        return this.getProviderJsDefinition(providerId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getProviderJsDefinition(String providerId, boolean bypassCacheRead) {
        JSONObject result = null;
        if (!bypassCacheRead) {
            Map<String, JSONObject> map = this.providerDefinitionsById;
            synchronized (map) {
                result = this.providerDefinitionsById.get(providerId);
            }
        }
        if (result == null) {
            DataSourceProvider provider;
            Map<String, DataSourceProvider> map = this.providersById;
            synchronized (map) {
                provider = this.providersById.get(providerId);
            }
            if (provider != null && (result = provider.getDataSourceDefinitions(this._isRefresh)) != null) {
                map = this.providerDefinitionsById;
                synchronized (map) {
                    this.providerDefinitionsById.put(providerId, result);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSourceProvider getProvider(String id) {
        Map<String, DataSourceProvider> map = this.providersById;
        synchronized (map) {
            return this.providersById.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IDataSourceProvider> getProviders() {
        Map<String, DataSourceProvider> map = this.providersById;
        synchronized (map) {
            return new ArrayList<IDataSourceProvider>(this.providersById.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(boolean isRefresh) {
        List<DataSourceProvider> providers = this.readProviders();
        Map<String, DataSourceProvider> map = this.providersById;
        synchronized (map) {
            this._isRefresh = isRefresh;
            try {
                this.providersById.clear();
                this.providerDefinitionsById.clear();
                for (DataSourceProvider ds : providers) {
                    logger.info((Object)String.format("Loaded DataSourceProvider: id=%s, object=%s", ds.getId(), ds));
                    this.providersById.put(ds.getId(), ds);
                }
                logger.debug((Object)"Successfully initialized.");
            }
            catch (Exception e) {
                logger.error((Object)"Error initializing.", (Throwable)e);
            }
        }
    }

    public void refresh() {
        this.init(true);
    }
}

