/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.jdbc;

import java.sql.SQLException;
import nl.cwi.monetdb.jdbc.MonetResultSet;

class MonetVirtualResultSet
extends MonetResultSet {
    private String[][] results;
    private boolean closed;

    MonetVirtualResultSet(String[] columns, String[] types, String[][] results) throws IllegalArgumentException {
        super(columns, types, results.length);
        this.results = results;
        this.closed = false;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.closed) {
            throw new SQLException("ResultSet is closed!", "M1M20");
        }
        if (row < 0) {
            row = this.tupleCount + row + 1;
        }
        if (row < 0) {
            row = 0;
        } else if (row > this.tupleCount + 1) {
            row = this.tupleCount + 1;
        }
        this.curRow = row;
        if (row < 1 || row > this.tupleCount) {
            return false;
        }
        for (int i = 0; i < this.results[row - 1].length; ++i) {
            this.tlp.values[i] = this.results[row - 1][i];
        }
        return true;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.results = null;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }
}

