/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.i18n;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.ui.i18n.KeyOccurrence;

public class MessagesStore
extends ChangedFlag {
    private String sourceFolder;
    private String locale;
    private String messagesPackage;
    private Map<String, String> messagesMap = new Hashtable<String, String>();
    private String filename;
    private Map<String, Map<String, List<KeyOccurrence>>> sourcePackageOccurrences;

    public MessagesStore(String locale, String sourceFolder, String messagesPackage, Map<String, Map<String, List<KeyOccurrence>>> sourcePackageOccurrences) {
        this.sourceFolder = sourceFolder;
        this.locale = locale;
        this.messagesPackage = messagesPackage;
        this.sourcePackageOccurrences = sourcePackageOccurrences;
        if (sourceFolder == null) {
            throw new RuntimeException("Source folder can not be null, messages package : " + messagesPackage + ", locale: " + locale);
        }
    }

    public void read(List<String> directories) throws KettleException {
        try {
            this.filename = this.getLoadFilename(directories);
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(new File(this.filename));
            properties.load(fileInputStream);
            fileInputStream.close();
            for (Object key : properties.keySet()) {
                Object value = properties.get(key);
                this.messagesMap.put((String)key, (String)value);
            }
        }
        catch (Exception e) {
            ArrayList keyList;
            String keys = "[";
            Map<String, List<KeyOccurrence>> po = this.sourcePackageOccurrences.get(this.sourceFolder);
            List<Object> list = keyList = po == null ? new ArrayList() : po.get(this.messagesPackage);
            if (keyList == null) {
                keyList = new ArrayList();
            }
            boolean first = true;
            for (KeyOccurrence occ : keyList) {
                if (first) {
                    first = false;
                } else {
                    keys = keys + ", ";
                }
                keys = keys + occ.getKey() + "/" + occ.getFileObject().toString();
            }
            keys = keys + "]";
            throw new KettleException("Unable to read messages file for locale : '" + this.locale + "' and package '" + this.messagesPackage + "', keys=" + keys, (Throwable)e);
        }
    }

    public void write() throws KettleException {
        if (this.filename == null) {
            throw new KettleException("Please specify a filename before saving messages store for package '" + this.messagesPackage + "' and locale '" + this.locale + "");
        }
        this.write(this.filename);
    }

    public void write(String filename) throws KettleException {
        try {
            File parent;
            File file = new File(filename);
            if (!file.exists() && !(parent = file.getParentFile()).exists()) {
                parent.mkdirs();
            }
            Properties properties = new Properties();
            for (String key : this.messagesMap.keySet()) {
                properties.put(key, this.messagesMap.get(key));
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            String comment = "File generated by Pentaho Translator for package '" + this.messagesPackage + "' in locale '" + this.locale + "'" + Const.CR + Const.CR;
            properties.store(fileOutputStream, comment);
            fileOutputStream.close();
            this.setChanged(false);
        }
        catch (IOException e) {
            throw new KettleException("Unable to save messages properties file '" + filename + "'", (Throwable)e);
        }
    }

    public String getLoadFilename(List<String> alternativeSourceFolders) throws FileNotFoundException {
        String path = this.calcFolderName(this.sourceFolder);
        if (new File(path).exists()) {
            return path;
        }
        for (String altSourceFolder : alternativeSourceFolders) {
            path = this.calcFolderName(altSourceFolder);
            if (!new File(path).exists()) continue;
            return path;
        }
        throw new FileNotFoundException("package file could not be found for file in folder " + this.sourceFolder + ", with messages package " + this.messagesPackage + " in locale " + this.locale);
    }

    private String calcFolderName(String sourceFolderPath) {
        String localeUpperLower = this.locale.substring(0, 3).toLowerCase() + this.locale.substring(3).toUpperCase();
        String filename = "messages_" + localeUpperLower + ".properties";
        String path = sourceFolderPath + File.separator + this.messagesPackage.replace('.', '/') + File.separator + "messages" + File.separator + filename;
        return path;
    }

    public String getSourceDirectory(List<String> directories) {
        String localeUpperLower = this.locale.substring(0, 3).toLowerCase() + this.locale.substring(3).toUpperCase();
        String filename = "messages_" + localeUpperLower + ".properties";
        String path = this.messagesPackage.replace('.', '/');
        for (String directory : directories) {
            String attempt = directory + Const.FILE_SEPARATOR + path + Const.FILE_SEPARATOR + "messages" + Const.FILE_SEPARATOR + filename;
            if (!new File(attempt).exists()) continue;
            return directory;
        }
        return null;
    }

    public String getSaveFilename(String directory) {
        String localeUpperLower = this.locale.substring(0, 3).toLowerCase() + this.locale.substring(3).toUpperCase();
        String filename = "messages_" + localeUpperLower + ".properties";
        String path = this.messagesPackage.replace('.', '/');
        return directory + Const.FILE_SEPARATOR + path + Const.FILE_SEPARATOR + "messages" + Const.FILE_SEPARATOR + filename;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getMessagesPackage() {
        return this.messagesPackage;
    }

    public void setMessagesPackage(String messagesPackage) {
        this.messagesPackage = messagesPackage;
    }

    public Map<String, String> getMessagesMap() {
        return this.messagesMap;
    }

    public void setMessagesMap(Map<String, String> messsagesMap) {
        this.messagesMap = messsagesMap;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getSourceFolder() {
        return this.sourceFolder;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }
}

