/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.truncatetables;

import java.util.Arrays;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.truncatetables.JobEntryTruncateTables;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class JobEntryTruncateTablesDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntryTruncateTables.class;
    private Button wbTable;
    private Label wlName;
    private Text wName;
    private FormData fdlName;
    private FormData fdName;
    private CCombo wConnection;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private JobEntryTruncateTables jobEntry;
    private Shell shell;
    private SelectionAdapter lsDef;
    private boolean changed;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private Button wbdTablename;
    private FormData fdbdTablename;
    private Label wlPrevious;
    private Button wPrevious;
    private FormData fdlPrevious;
    private FormData fdPrevious;

    public JobEntryTruncateTablesDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntryTruncateTables)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(PKG, (String)"JobTruncateTables.Name.Default", (String[])new String[0]));
        }
    }

    public JobEntryInterface open() {
        int rows;
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage(this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryTruncateTablesDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobTruncateTables.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlName = new Label((Composite)this.shell, 131072);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"JobTruncateTables.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        this.fdlName = new FormData();
        this.fdlName.left = new FormAttachment(0, 0);
        this.fdlName.right = new FormAttachment(middle, -margin);
        this.fdlName.top = new FormAttachment(0, margin);
        this.wlName.setLayoutData((Object)this.fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        this.fdName = new FormData();
        this.fdName.left = new FormAttachment(middle, 0);
        this.fdName.top = new FormAttachment(0, margin);
        this.fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)this.fdName);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wName, middle, margin);
        if (this.jobEntry.getDatabase() == null && this.jobMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wlPrevious = new Label((Composite)this.shell, 131072);
        this.wlPrevious.setText(BaseMessages.getString(PKG, (String)"JobTruncateTables.Previous.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPrevious);
        this.fdlPrevious = new FormData();
        this.fdlPrevious.left = new FormAttachment(0, 0);
        this.fdlPrevious.top = new FormAttachment((Control)this.wConnection, margin);
        this.fdlPrevious.right = new FormAttachment(middle, -margin);
        this.wlPrevious.setLayoutData((Object)this.fdlPrevious);
        this.wPrevious = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wPrevious);
        this.wPrevious.setToolTipText(BaseMessages.getString(PKG, (String)"JobTruncateTables.Previous.Tooltip", (String[])new String[0]));
        this.fdPrevious = new FormData();
        this.fdPrevious.left = new FormAttachment(middle, 0);
        this.fdPrevious.top = new FormAttachment((Control)this.wConnection, margin);
        this.fdPrevious.right = new FormAttachment(100, 0);
        this.wPrevious.setLayoutData((Object)this.fdPrevious);
        this.wPrevious.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntryTruncateTablesDialog.this.setPrevious();
                JobEntryTruncateTablesDialog.this.jobEntry.setChanged();
            }
        });
        this.wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbTable);
        this.wbTable.setText(BaseMessages.getString(PKG, (String)"JobTruncateTables.GetTablenamesList.Auto", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.left = new FormAttachment(0, margin);
        fdbTable.right = new FormAttachment(100, -margin);
        fdbTable.top = new FormAttachment((Control)this.wPrevious, 2 * margin);
        this.wbTable.setLayoutData((Object)fdbTable);
        this.wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntryTruncateTablesDialog.this.getTableName();
            }
        });
        this.wbdTablename = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbdTablename);
        this.wbdTablename.setText(BaseMessages.getString(PKG, (String)"JobTruncateTables.TableDelete.Button", (String[])new String[0]));
        this.wbdTablename.setToolTipText(BaseMessages.getString(PKG, (String)"JobTruncateTables.TableDelete.Tooltip", (String[])new String[0]));
        this.fdbdTablename = new FormData();
        this.fdbdTablename.right = new FormAttachment(100, 0);
        this.fdbdTablename.top = new FormAttachment((Control)this.wbTable, 2 * middle);
        this.wbdTablename.setLayoutData((Object)this.fdbdTablename);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"JobTruncateTables.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.right = new FormAttachment(middle, -margin);
        this.fdlFields.top = new FormAttachment((Control)this.wbTable, 2 * margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        int FieldsRows = rows = this.jobEntry.arguments == null ? 1 : (this.jobEntry.arguments.length == 0 ? 0 : this.jobEntry.arguments.length);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"JobTruncateTables.Fields.Table.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"JobTruncateTables.Fields.Schema.Label", (String[])new String[0]), 1, false)};
        colinf[0].setUsingVariables(true);
        colinf[0].setToolTip(BaseMessages.getString(PKG, (String)"JobTruncateTables.Fields.Table.Tooltip", (String[])new String[0]));
        colinf[1].setUsingVariables(true);
        colinf[1].setToolTip(BaseMessages.getString(PKG, (String)"JobTruncateTables.Fields.Schema.Tooltip", (String[])new String[0]));
        this.wFields = new TableView((VariableSpace)this.jobMeta, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment((Control)this.wbdTablename, -margin);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData(this.fdFields);
        this.wbdTablename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] idx = JobEntryTruncateTablesDialog.this.wFields.getSelectionIndices();
                JobEntryTruncateTablesDialog.this.wFields.remove(idx);
                JobEntryTruncateTablesDialog.this.wFields.removeEmptyRows();
                JobEntryTruncateTablesDialog.this.wFields.setRowNums();
            }
        });
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fd = new FormData();
        fd.right = new FormAttachment(50, -10);
        fd.bottom = new FormAttachment(100, 0);
        fd.width = 100;
        this.wOK.setLayoutData((Object)fd);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(50, 10);
        fd.bottom = new FormAttachment(100, 0);
        fd.width = 100;
        this.wCancel.setLayoutData((Object)fd);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntryTruncateTablesDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntryTruncateTablesDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wFields);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntryTruncateTablesDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntryTruncateTablesDialog.this.cancel();
            }
        });
        this.getData();
        this.setPrevious();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        this.props.setDialogSize(this.shell, "JobTruncateTablesDialogSize");
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    private void setPrevious() {
        this.wlFields.setEnabled(!this.wPrevious.getSelection());
        this.wFields.setEnabled(!this.wPrevious.getSelection());
        this.wbdTablename.setEnabled(!this.wPrevious.getSelection());
        this.wbTable.setEnabled(!this.wPrevious.getSelection());
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.jobEntry.getName()));
        if (this.jobEntry.getDatabase() != null) {
            this.wConnection.setText(this.jobEntry.getDatabase().getName());
        }
        if (this.jobEntry.arguments != null) {
            for (int i = 0; i < this.jobEntry.arguments.length; ++i) {
                TableItem ti = this.wFields.table.getItem(i);
                if (this.jobEntry.arguments[i] != null) {
                    ti.setText(1, this.jobEntry.arguments[i]);
                }
                if (this.jobEntry.schemaname[i] == null) continue;
                ti.setText(2, this.jobEntry.schemaname[i]);
            }
            this.wFields.removeEmptyRows();
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
        this.wPrevious.setSelection(this.jobEntry.argFromPrevious);
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        String arg;
        int i;
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        this.jobEntry.setDatabase(this.jobMeta.findDatabase(this.wConnection.getText()));
        this.jobEntry.argFromPrevious = this.wPrevious.getSelection();
        int nritems = this.wFields.nrNonEmpty();
        int nr = 0;
        for (i = 0; i < nritems; ++i) {
            arg = this.wFields.getNonEmpty(i).getText(1);
            if (arg == null || arg.length() == 0) continue;
            ++nr;
        }
        this.jobEntry.arguments = new String[nr];
        this.jobEntry.schemaname = new String[nr];
        nr = 0;
        for (i = 0; i < nritems; ++i) {
            arg = this.wFields.getNonEmpty(i).getText(1);
            String wild = this.wFields.getNonEmpty(i).getText(2);
            if (arg == null || arg.length() == 0) continue;
            this.jobEntry.arguments[nr] = arg;
            this.jobEntry.schemaname[nr] = wild;
            ++nr;
        }
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTableName() {
        DatabaseMeta databaseMeta = this.jobMeta.findDatabase(this.wConnection.getText());
        if (databaseMeta != null) {
            Database database = new Database(loggingObject, databaseMeta);
            try {
                database.connect();
                Object[] Tablenames = database.getTablenames();
                Arrays.sort(Tablenames);
                EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, (String[])Tablenames, BaseMessages.getString(PKG, (String)"JobTruncateTables.SelectTables.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobTruncateTables.SelectTables.Message", (String[])new String[0]));
                dialog.setMulti(true);
                dialog.setAvoidQuickSearch();
                if (dialog.open() != null) {
                    int[] idx = dialog.getSelectionIndeces();
                    for (int i = 0; i < idx.length; ++i) {
                        TableItem tableItem = new TableItem(this.wFields.table, 0);
                        tableItem.setText(1, (String)Tablenames[idx[i]]);
                    }
                }
            }
            catch (KettleDatabaseException e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryTruncateTables.ConnectionError.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
            }
            finally {
                if (database != null) {
                    database.disconnect();
                }
            }
            this.wFields.removeEmptyRows();
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
    }
}

