/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.model;

import java.util.Comparator;
import java.util.Date;
import org.pentaho.di.repository.IRepositoryService;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryObjectInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryDirectory;
import org.pentaho.ui.xul.util.AbstractModelNode;

public abstract class UIRepositoryObject
extends AbstractModelNode<UIRepositoryObject> {
    private static final long serialVersionUID = -456272921332284281L;
    protected RepositoryObjectInterface obj;
    protected Repository rep;
    private RepositoryObjectComparator roc = new RepositoryObjectComparator();
    private static final DateObjectComparator doc = new DateObjectComparator();
    private IRepositoryService repositoryService;

    public UIRepositoryObject() {
    }

    public UIRepositoryObject(RepositoryObjectInterface obj) {
        this();
        this.obj = obj;
    }

    public UIRepositoryObject(RepositoryObjectInterface obj, Repository rep) {
        this(obj);
        this.rep = rep;
    }

    public String getId() {
        if (this.obj != null && this.obj.getObjectId() != null) {
            return this.obj.getObjectId().getId();
        }
        return null;
    }

    public ObjectId getObjectId() {
        if (this.obj == null) {
            return null;
        }
        return this.obj.getObjectId();
    }

    public String getName() {
        return this.obj.getName();
    }

    public abstract void setName(String var1) throws Exception;

    public abstract void move(UIRepositoryDirectory var1) throws Exception;

    public abstract void delete() throws Exception;

    public abstract Date getModifiedDate();

    public abstract String getFormatModifiedDate();

    public abstract String getModifiedUser();

    public abstract RepositoryObjectType getRepositoryElementType();

    public abstract String getType();

    public abstract String getDescription();

    public abstract UIRepositoryDirectory getParent();

    public String getParentPath() {
        return this.getParent() != null ? this.getParent().getPath() : null;
    }

    public boolean isDeleted() {
        return false;
    }

    public abstract String getImage();

    public Repository getRepository() {
        return this.rep;
    }

    public void setRepository(Repository rep) {
        this.rep = rep;
    }

    public String getPath() {
        return this.getParentPath() + "/" + this.getName();
    }

    public RepositoryObjectComparator getComparator() {
        return this.roc;
    }

    public void setComparator(RepositoryObjectComparator roc) {
        this.roc = roc;
    }

    public DateObjectComparator getDateComparator() {
        return doc;
    }

    public IRepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(IRepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public abstract int getCategory();

    static class RepositoryObjectComparator
    implements Comparator<UIRepositoryObject> {
        RepositoryObjectComparator() {
        }

        @Override
        public int compare(UIRepositoryObject o1, UIRepositoryObject o2) {
            int cat2;
            int cat1 = o1.getCategory();
            if (cat1 != (cat2 = o2.getCategory())) {
                return cat1 - cat2;
            }
            String t1 = o1.getName();
            String t2 = o2.getName();
            if (t1 == null) {
                t1 = "";
            }
            if (t2 == null) {
                t2 = "";
            }
            return t1.compareToIgnoreCase(t2);
        }
    }

    static class DateObjectComparator
    implements Comparator<UIRepositoryObject> {
        DateObjectComparator() {
        }

        @Override
        public int compare(UIRepositoryObject o1, UIRepositoryObject o2) {
            Date d1 = o1 != null ? o1.getModifiedDate() : null;
            Date d2 = o2 != null ? o2.getModifiedDate() : null;
            long t1 = d1 != null ? d1.getTime() : 0L;
            long t2 = d2 != null ? d2.getTime() : 0L;
            int res = 0;
            if (t1 > t2) {
                res = 1;
            } else if (t1 < t2) {
                res = -1;
            }
            return res;
        }
    }
}

