/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.trans;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableField;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.XulSpoonResourceBundle;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;
import org.pentaho.di.ui.spoon.trans.TransGraph;
import org.pentaho.di.ui.xul.KettleXulLoader;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulToolbarbutton;
import org.pentaho.ui.xul.containers.XulToolbar;
import org.pentaho.ui.xul.impl.XulEventHandler;

public class TransHistoryDelegate
extends SpoonDelegate
implements XulEventHandler {
    private static Class<?> PKG = Spoon.class;
    private static final String XUL_FILE_TRANS_GRID_TOOLBAR = "ui/trans-history-toolbar.xul";
    private TransGraph transGraph;
    private CTabItem transHistoryTab;
    private XulToolbar toolbar;
    private Composite transHistoryComposite;
    private TransMeta transMeta;
    private CTabFolder tabFolder;
    private XulToolbarbutton refreshButton;
    private XulToolbarbutton fetchNextBatchButton;
    private XulToolbarbutton fetchAllButton;
    private TransHistoryLogTab[] models;

    public TransHistoryDelegate(Spoon spoon, TransGraph transGraph) {
        super(spoon);
        this.transGraph = transGraph;
    }

    public void addTransHistory() {
        if (this.transGraph.extraViewComposite == null || this.transGraph.extraViewComposite.isDisposed()) {
            this.transGraph.addExtraView();
        } else if (this.transHistoryTab != null && !this.transHistoryTab.isDisposed()) {
            this.transGraph.extraViewTabFolder.setSelection(this.transHistoryTab);
            return;
        }
        this.transMeta = this.transGraph.getManagedObject();
        this.transHistoryTab = new CTabItem(this.transGraph.extraViewTabFolder, 0);
        this.transHistoryTab.setImage(GUIResource.getInstance().getImageShowHistory());
        this.transHistoryTab.setText(BaseMessages.getString(PKG, (String)"Spoon.TransGraph.HistoryTab.Name", (String[])new String[0]));
        this.transHistoryComposite = new Composite((Composite)this.transGraph.extraViewTabFolder, 0);
        this.transHistoryComposite.setLayout((Layout)new FormLayout());
        this.spoon.props.setLook((Control)this.transHistoryComposite);
        this.addToolBar();
        Control toolbarControl = (Control)this.toolbar.getManagedObject();
        toolbarControl.setLayoutData((Object)new FormData());
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        toolbarControl.setLayoutData((Object)fd);
        toolbarControl.setParent(this.transHistoryComposite);
        this.addLogTableTabs();
        this.tabFolder.setSelection(0);
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                TransHistoryDelegate.this.setMoreRows(true);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.transHistoryComposite.pack();
        this.transHistoryTab.setControl((Control)this.transHistoryComposite);
        this.transGraph.extraViewTabFolder.setSelection(this.transHistoryTab);
        if (!Props.getInstance().disableInitialExecutionHistory()) {
            this.refreshAllHistory();
        }
    }

    private void addLogTableTabs() {
        this.tabFolder = new CTabFolder(this.transHistoryComposite, 2);
        this.spoon.props.setLook((Control)this.tabFolder, 5);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.toolbar.getManagedObject(), 0);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment(100, 0);
        this.tabFolder.setLayoutData((Object)fdTabFolder);
        this.models = new TransHistoryLogTab[this.transMeta.getLogTables().size()];
        for (int i = 0; i < this.models.length; ++i) {
            this.models[i] = new TransHistoryLogTab(this.tabFolder, (LogTableInterface)this.transMeta.getLogTables().get(i));
        }
    }

    private void addToolBar() {
        try {
            KettleXulLoader loader = new KettleXulLoader();
            loader.setIconsSize(16, 16);
            loader.setSettingsManager(XulSpoonSettingsManager.getInstance());
            XulSpoonResourceBundle bundle = new XulSpoonResourceBundle(Spoon.class);
            XulDomContainer xulDomContainer = loader.loadXul(XUL_FILE_TRANS_GRID_TOOLBAR, bundle);
            xulDomContainer.addEventHandler((XulEventHandler)this);
            this.toolbar = (XulToolbar)xulDomContainer.getDocumentRoot().getElementById("nav-toolbar");
            this.refreshButton = (XulToolbarbutton)xulDomContainer.getDocumentRoot().getElementById("refresh-history");
            this.fetchNextBatchButton = (XulToolbarbutton)xulDomContainer.getDocumentRoot().getElementById("fetch-next-batch-history");
            this.fetchAllButton = (XulToolbarbutton)xulDomContainer.getDocumentRoot().getElementById("fetch-all-history");
            ToolBar swtToolBar = (ToolBar)this.toolbar.getManagedObject();
            this.spoon.props.setLook((Control)swtToolBar, 6);
            swtToolBar.layout(true, true);
        }
        catch (Throwable t) {
            this.log.logError(Const.getStackTracker((Throwable)t));
            new ErrorDialog(this.transHistoryComposite.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Message", (String[])new String[]{XUL_FILE_TRANS_GRID_TOOLBAR}), new Exception(t));
        }
    }

    public void clearLogTable() {
        this.clearLogTable(this.tabFolder.getSelectionIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLogTable(int index) {
        TransHistoryLogTab model = this.models[index];
        LogTableInterface logTable = model.logTable;
        if (logTable.isDefined()) {
            String schemaTable = logTable.getQuotedSchemaTableCombination();
            DatabaseMeta databaseMeta = logTable.getDatabaseMeta();
            MessageBox mb = new MessageBox(this.transGraph.getShell(), 196);
            mb.setMessage(BaseMessages.getString(PKG, (String)"TransGraph.Dialog.AreYouSureYouWantToRemoveAllLogEntries.Message", (String[])new String[]{schemaTable}));
            mb.setText(BaseMessages.getString(PKG, (String)"TransGraph.Dialog.AreYouSureYouWantToRemoveAllLogEntries.Title", (String[])new String[0]));
            if (mb.open() == 64) {
                Database database = new Database(loggingObject, databaseMeta);
                try {
                    database.connect();
                    database.truncateTable(schemaTable);
                }
                catch (Exception e) {
                    new ErrorDialog(this.transGraph.getShell(), BaseMessages.getString(PKG, (String)"TransGraph.Dialog.ErrorClearningLoggingTable.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransGraph.Dialog.ErrorClearningLoggingTable.Message", (String[])new String[0]), e);
                }
                finally {
                    database.disconnect();
                    this.refreshHistory();
                    if (model.logDisplayText != null) {
                        model.logDisplayText.setText("");
                    }
                }
            }
        }
    }

    public void replayHistory() {
        TransHistoryLogTab model = this.models[this.tabFolder.getSelectionIndex()];
        int idx = model.logDisplayTableView.getSelectionIndex();
        if (idx >= 0) {
            String[] fields = model.logDisplayTableView.getItem(idx);
            String dateString = fields[13];
            Date replayDate = XMLHandler.stringToDate((String)dateString);
            this.spoon.executeTransformation(this.transGraph.getManagedObject(), true, false, false, false, false, replayDate, false, this.spoon.getTransExecutionConfiguration().getLogLevel());
        }
    }

    public void refreshHistory() {
        this.refreshHistory(this.tabFolder.getSelectionIndex(), Mode.INITIAL);
    }

    private void refreshAllHistory() {
        for (int i = 0; i < this.models.length; ++i) {
            this.refreshHistory(i, Mode.INITIAL);
        }
    }

    private void refreshHistory(final int index, final Mode fetchMode) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                TransHistoryDelegate.this.spoon.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        TransHistoryDelegate.this.setQueryInProgress(true);
                        TransHistoryLogTab model = TransHistoryDelegate.this.models[index];
                        model.setLogTable((LogTableInterface)TransHistoryDelegate.this.transMeta.getLogTables().get(index));
                    }
                });
                final boolean moreRows = TransHistoryDelegate.this.getHistoryData(index, fetchMode);
                TransHistoryDelegate.this.spoon.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        TransHistoryDelegate.this.displayHistoryData(index);
                        TransHistoryDelegate.this.setQueryInProgress(false);
                        TransHistoryDelegate.this.setMoreRows(moreRows);
                    }
                });
            }
        }).start();
    }

    private void setMoreRows(boolean moreRows) {
        this.fetchNextBatchButton.setDisabled(!moreRows);
    }

    private void setQueryInProgress(boolean inProgress) {
        this.refreshButton.setDisabled(inProgress);
        this.fetchNextBatchButton.setDisabled(inProgress);
        this.fetchAllButton.setDisabled(inProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getHistoryData(int index, Mode mode) {
        int BATCH_SIZE = Props.getInstance().getLinesInHistoryFetchSize();
        boolean moreRows = false;
        TransHistoryLogTab model = this.models[index];
        LogTableInterface logTable = model.logTable;
        if (this.transMeta != null && !Utils.isEmpty((CharSequence)this.transMeta.getName()) && logTable.isDefined()) {
            Database database = null;
            try {
                DatabaseMeta logConnection = logTable.getDatabaseMeta();
                database = new Database(loggingObject, logConnection);
                database.shareVariablesWith((VariableSpace)this.transMeta);
                database.connect();
                int queryLimit = 0;
                switch (mode) {
                    case ALL: {
                        model.batchCount = 0;
                        queryLimit = Props.getInstance().getMaxNrLinesInHistory();
                        break;
                    }
                    case NEXT_BATCH: {
                        ++model.batchCount;
                        queryLimit = BATCH_SIZE * model.batchCount;
                        break;
                    }
                    case INITIAL: {
                        model.batchCount = 1;
                        queryLimit = BATCH_SIZE;
                        break;
                    }
                }
                database.setQueryLimit(queryLimit);
                String schemaTable = logTable.getQuotedSchemaTableCombination();
                StringBuilder sql = new StringBuilder("SELECT ");
                boolean first = true;
                for (LogTableField field : logTable.getFields()) {
                    if (!field.isEnabled() || !field.isVisible()) continue;
                    if (!first) {
                        sql.append(", ");
                    }
                    first = false;
                    sql.append(logConnection.quoteField(field.getFieldName()));
                }
                sql.append(" FROM ").append(schemaTable);
                RowMetaAndData params = new RowMetaAndData();
                LogTableField nameField = logTable.getNameField();
                LogTableField keyField = logTable.getKeyField();
                if (nameField != null) {
                    if (this.transMeta.isUsingAClusterSchema()) {
                        sql.append(" WHERE ").append(logConnection.quoteField(nameField.getFieldName())).append(" LIKE ?");
                        params.addValue((ValueMetaInterface)new ValueMetaString("transname_literal", 255, -1), (Object)this.transMeta.getName());
                        sql.append(" OR    ").append(logConnection.quoteField(nameField.getFieldName())).append(" LIKE ?");
                        params.addValue((ValueMetaInterface)new ValueMetaString("transname_cluster", 255, -1), (Object)(this.transMeta.getName() + " (%"));
                    } else {
                        sql.append(" WHERE ").append(logConnection.quoteField(nameField.getFieldName())).append(" = ?");
                        params.addValue((ValueMetaInterface)new ValueMetaString("transname_literal", 255, -1), (Object)this.transMeta.getName());
                    }
                }
                if (keyField != null && keyField.isEnabled()) {
                    sql.append(" ORDER BY ").append(logConnection.quoteField(keyField.getFieldName())).append(" DESC");
                }
                ResultSet resultSet = database.openQuery(sql.toString(), params.getRowMeta(), params.getData());
                ArrayList<Object[]> rows = new ArrayList<Object[]>();
                Object[] rowData = database.getRow(resultSet);
                int rowsFetched = 1;
                while (rowData != null) {
                    rows.add(rowData);
                    rowData = database.getRow(resultSet);
                    ++rowsFetched;
                }
                if (rowsFetched >= queryLimit) {
                    moreRows = true;
                }
                database.closeQuery(resultSet);
                model.rows = rows;
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Unable to get rows of data from logging table " + model.logTable, (Throwable)e);
                model.rows = new ArrayList();
            }
            finally {
                if (database != null) {
                    database.disconnect();
                }
            }
        } else {
            model.rows = new ArrayList();
        }
        return moreRows;
    }

    private void displayHistoryData(int index) {
        TransHistoryLogTab model = this.models[index];
        ColumnInfo[] colinf = model.logDisplayTableView.getColumns();
        if (model.logDisplayTableView == null || model.logDisplayTableView.isDisposed()) {
            return;
        }
        int selectionIndex = model.logDisplayTableView.getSelectionIndex();
        ((TransHistoryLogTab)model).logDisplayTableView.table.clearAll();
        List rows = model.rows;
        if (rows != null && rows.size() > 0) {
            for (Object[] rowData : rows) {
                LogTableField statusField;
                TableItem item = new TableItem(((TransHistoryLogTab)model).logDisplayTableView.table, 0);
                for (int c = 0; c < colinf.length; ++c) {
                    ColumnInfo column = colinf[c];
                    ValueMetaInterface valueMeta = column.getValueMeta();
                    String string = null;
                    try {
                        string = valueMeta.getString(rowData[c]);
                    }
                    catch (KettleValueException e) {
                        this.log.logError("history data conversion issue", (Throwable)e);
                    }
                    item.setText(c + 1, Const.NVL((String)string, (String)""));
                }
                Long errors = null;
                LogStatus status = null;
                LogTableField errorsField = model.logTable.getErrorsField();
                if (errorsField != null) {
                    int index1 = model.logTableFields.indexOf(errorsField);
                    try {
                        errors = colinf[index1].getValueMeta().getInteger(rowData[index1]);
                    }
                    catch (KettleValueException e) {
                        this.log.logError("history data conversion issue", (Throwable)e);
                    }
                }
                if ((statusField = model.logTable.getStatusField()) != null) {
                    int index1 = model.logTableFields.indexOf(statusField);
                    String statusString = null;
                    try {
                        statusString = colinf[index1].getValueMeta().getString(rowData[index1]);
                    }
                    catch (KettleValueException e) {
                        this.log.logError("history data conversion issue", (Throwable)e);
                    }
                    if (statusString != null) {
                        status = LogStatus.findStatus((String)statusString);
                    }
                }
                if (errors != null && errors > 0L) {
                    item.setBackground(GUIResource.getInstance().getColorRed());
                    continue;
                }
                if (status == null || !LogStatus.STOP.equals(status)) continue;
                item.setBackground(GUIResource.getInstance().getColorYellow());
            }
            model.logDisplayTableView.removeEmptyRows();
            model.logDisplayTableView.setRowNums();
            model.logDisplayTableView.optWidth(true);
        } else {
            model.logDisplayTableView.clearAll(false);
        }
        if (selectionIndex >= 0 && selectionIndex < model.logDisplayTableView.getItemCount()) {
            ((TransHistoryLogTab)model).logDisplayTableView.table.select(selectionIndex);
            this.showLogEntry();
        }
    }

    private void showLogEntry() {
        TransHistoryLogTab model = this.models[this.tabFolder.getSelectionIndex()];
        Text text = model.logDisplayText;
        if (text == null || text.isDisposed()) {
            return;
        }
        List list = model.rows;
        if (list == null || list.size() == 0) {
            String message = model.logTable.isDefined() ? BaseMessages.getString(PKG, (String)"TransHistory.PleaseRefresh.Message", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"TransHistory.HistoryConfiguration.Message", (String[])new String[0]);
            text.setText(message);
            return;
        }
        int nr = ((TransHistoryLogTab)model).logDisplayTableView.table.getSelectionIndex();
        if (nr >= 0 && nr < list.size()) {
            Object[] row = (Object[])list.get(nr);
            LogTableField logField = model.logTable.getLogField();
            if (logField != null) {
                int index = model.logTableFields.indexOf(logField);
                if (index >= 0) {
                    String logText = row[index].toString();
                    text.setText(Const.NVL((String)logText, (String)""));
                    text.setSelection(text.getText().length());
                    text.showSelection();
                } else {
                    text.setText(BaseMessages.getString(PKG, (String)"TransHistory.HistoryConfiguration.NoLoggingFieldDefined", (String[])new String[0]));
                }
            }
        }
    }

    public CTabItem getTransHistoryTab() {
        return this.transHistoryTab;
    }

    public Object getData() {
        return null;
    }

    public String getName() {
        return "transhistory";
    }

    public XulDomContainer getXulDomContainer() {
        return null;
    }

    public void setData(Object data) {
    }

    public void setName(String name) {
    }

    public void setXulDomContainer(XulDomContainer xulDomContainer) {
    }

    public void fetchNextBatch() {
        int tabIndex = this.tabFolder.getSelectionIndex();
        this.refreshHistory(tabIndex, Mode.NEXT_BATCH);
    }

    public void fetchAll() {
        int tabIndex = this.tabFolder.getSelectionIndex();
        this.refreshHistory(tabIndex, Mode.ALL);
    }

    private class TransHistoryLogTab
    extends CTabItem {
        private List<LogTableField> logTableFields;
        private List<Object[]> rows;
        private LogTableInterface logTable;
        private Text logDisplayText;
        private TableView logDisplayTableView;
        public int batchCount;

        public TransHistoryLogTab(CTabFolder tabFolder, LogTableInterface logTable) {
            super(tabFolder, 0);
            this.logTableFields = new ArrayList<LogTableField>();
            this.setLogTable(logTable);
            this.setText(logTable.getLogTableType());
            Composite logTableComposite = new Composite((Composite)tabFolder, 0);
            logTableComposite.setLayout((Layout)new FormLayout());
            ((TransHistoryDelegate)TransHistoryDelegate.this).spoon.props.setLook((Control)logTableComposite);
            this.setControl((Control)logTableComposite);
            SashForm sash = new SashForm(logTableComposite, 512);
            sash.setLayout((Layout)new FillLayout());
            FormData fdSash = new FormData();
            fdSash.left = new FormAttachment(0, 0);
            fdSash.top = new FormAttachment(0, 0);
            fdSash.right = new FormAttachment(100, 0);
            fdSash.bottom = new FormAttachment(100, 0);
            sash.setLayoutData((Object)fdSash);
            this.logDisplayTableView = this.createTransLogTableView((Composite)sash);
            if (logTable.getLogField() != null) {
                this.logDisplayText = new Text((Composite)sash, 778);
                ((TransHistoryDelegate)TransHistoryDelegate.this).spoon.props.setLook((Control)this.logDisplayText);
                this.logDisplayText.setVisible(true);
                FormData fdText = new FormData();
                fdText.left = new FormAttachment(0, 0);
                fdText.top = new FormAttachment(0, 0);
                fdText.right = new FormAttachment(100, 0);
                fdText.bottom = new FormAttachment(100, 0);
                this.logDisplayText.setLayoutData((Object)fdText);
                sash.setWeights(new int[]{70, 30});
            } else {
                this.logDisplayText = null;
                sash.setWeights(new int[]{100});
            }
        }

        public void setLogTable(LogTableInterface logTable) {
            this.logTable = logTable;
            this.logTableFields.clear();
            for (LogTableField field : logTable.getFields()) {
                if (!field.isEnabled() || !field.isVisible()) continue;
                this.logTableFields.add(field);
            }
            if (this.logDisplayTableView != null) {
                Composite tableParent = this.logDisplayTableView.getParent();
                TableView newTable = this.createTransLogTableView(tableParent);
                newTable.moveAbove((Control)this.logDisplayTableView);
                this.logDisplayTableView.dispose();
                tableParent.layout(false);
                this.logDisplayTableView = newTable;
            }
        }

        private TableView createTransLogTableView(Composite parent) {
            ArrayList<ColumnInfo> columnList = new ArrayList<ColumnInfo>();
            for (LogTableField field : this.logTableFields) {
                if (field.isLogField()) continue;
                ColumnInfo column = new ColumnInfo(field.getName(), 1, false, true);
                int valueType = field.getDataType();
                String conversionMask = null;
                switch (field.getDataType()) {
                    case 5: {
                        conversionMask = "###,###,##0";
                        column.setAllignement(131072);
                        break;
                    }
                    case 3: {
                        conversionMask = "yyyy/MM/dd HH:mm:ss";
                        column.setAllignement(0x1000000);
                        break;
                    }
                    case 1: {
                        conversionMask = " ###,###,##0.00;-###,###,##0.00";
                        column.setAllignement(131072);
                        break;
                    }
                    case 2: {
                        column.setAllignement(16384);
                        break;
                    }
                    case 4: {
                        DatabaseMeta databaseMeta = this.logTable.getDatabaseMeta();
                        if (databaseMeta == null || databaseMeta.supportsBooleanDataType()) break;
                        valueType = 2;
                        break;
                    }
                }
                ValueMeta valueMeta = new ValueMeta(field.getFieldName(), valueType, field.getLength(), -1);
                if (conversionMask != null) {
                    valueMeta.setConversionMask(conversionMask);
                }
                column.setValueMeta((ValueMetaInterface)valueMeta);
                columnList.add(column);
            }
            TableView tableView = new TableView((VariableSpace)TransHistoryDelegate.this.transMeta, parent, 67588, columnList.toArray(new ColumnInfo[columnList.size()]), 1, true, null, ((TransHistoryDelegate)TransHistoryDelegate.this).spoon.props);
            tableView.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    TransHistoryDelegate.this.showLogEntry();
                }
            });
            return tableView;
        }
    }

    private static enum Mode {
        INITIAL,
        NEXT_BATCH,
        ALL;

    }
}

