/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.systemdata;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.systemdata.SystemDataMeta;
import org.pentaho.di.trans.steps.systemdata.SystemDataTypes;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class SystemDataDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = SystemDataMeta.class;
    private Label wlStepname;
    private Text wStepname;
    private FormData fdlStepname;
    private FormData fdStepname;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private SystemDataMeta input;
    private boolean isReceivingInput = false;

    public SystemDataDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (SystemDataMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SystemDataDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SystemDataDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.isReceivingInput = this.transMeta.findNrPrevSteps(this.stepMeta) > 0;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"SystemDataDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        int FieldsCols = 2;
        int FieldsRows = this.input.getFieldName().length;
        final String[] functionDesc = new String[SystemDataTypes.values().length - 1];
        for (int i = 1; i < SystemDataTypes.values().length; ++i) {
            functionDesc[i - 1] = SystemDataTypes.values()[i].getDescription();
        }
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SystemDataDialog.NameColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SystemDataDialog.TypeColumn.Column", (String[])new String[0]), 1, false)};
        colinf[1].setSelectionAdapter((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterSelectionDialog esd = new EnterSelectionDialog(SystemDataDialog.this.shell, functionDesc, BaseMessages.getString((Class)PKG, (String)"SystemDataDialog.SelectInfoType.DialogTitle", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"SystemDataDialog.SelectInfoType.DialogMessage", (String[])new String[0]));
                String string = esd.open();
                if (string != null) {
                    TableView tv = (TableView)e.widget;
                    tv.setText(string, e.x, e.y);
                }
                SystemDataDialog.this.input.setChanged();
            }
        });
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData(this.fdFields);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"SystemDataDialog.Button.PreviewRows", (String[])new String[0]));
        this.wPreview.setEnabled(!this.isReceivingInput);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wPreview, this.wCancel}, margin, (Control)this.wFields);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                SystemDataDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                SystemDataDialog.this.ok();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                SystemDataDialog.this.preview();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.wPreview.addListener(13, this.lsPreview);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SystemDataDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SystemDataDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        this.wStepname.setText(this.stepname);
        for (int i = 0; i < this.input.getFieldName().length; ++i) {
            TableItem item = this.wFields.table.getItem(i);
            String name = this.input.getFieldName()[i];
            String type = this.input.getFieldType()[i].getDescription();
            if (name != null) {
                item.setText(1, name);
            }
            if (type == null) continue;
            item.setText(2, type);
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        try {
            this.getInfo(this.input);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SystemDataDialog.ErrorParsingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SystemDataDialog.ErrorParsingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
        this.dispose();
    }

    private void getInfo(SystemDataMeta in) throws KettleException {
        this.stepname = this.wStepname.getText();
        int count = this.wFields.nrNonEmpty();
        in.allocate(count);
        for (int i = 0; i < count; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            in.getFieldName()[i] = item.getText(1);
            in.getFieldType()[i] = SystemDataTypes.getTypeFromString((String)item.getText(2));
        }
    }

    private void preview() {
        try {
            SystemDataMeta oneMeta = new SystemDataMeta();
            this.getInfo(oneMeta);
            TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
            EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"SystemDataDialog.NumberRows.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SystemDataDialog.NumberRows.DialogMessage", (String[])new String[0]));
            int previewSize = numberDialog.open();
            if (previewSize > 0) {
                TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
                progressDialog.open();
                if (!progressDialog.isCancelled()) {
                    Trans trans = progressDialog.getTrans();
                    String loggingText = progressDialog.getLoggingText();
                    if (trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                        EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                        etd.setReadOnly();
                        etd.open();
                    }
                    PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
                    prd.open();
                }
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SystemDataDialog.ErrorPreviewingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SystemDataDialog.ErrorPreviewingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }
}

