/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import java.text.NumberFormat;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class DollarFunction
implements Function {
    private static final long serialVersionUID = 3505313019941429911L;

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1 || parameterCount > 2) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type1 = parameters.getType(0);
        Object value1 = parameters.getValue(0);
        Number result = context.getTypeRegistry().convertToNumber(type1, value1);
        if (result == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        NumberFormat currencyInstance = NumberFormat.getCurrencyInstance(context.getLocalizationContext().getLocale());
        if (parameterCount == 2) {
            Type typeDecimals = parameters.getType(1);
            Object valueDecimals = parameters.getValue(1);
            Number resultDecimals = context.getTypeRegistry().convertToNumber(typeDecimals, valueDecimals);
            currencyInstance.setMaximumFractionDigits(resultDecimals.intValue());
            currencyInstance.setMinimumFractionDigits(resultDecimals.intValue());
        }
        return new TypeValuePair(TextType.TYPE, currencyInstance.format(result));
    }

    @Override
    public String getCanonicalName() {
        return "FIXED";
    }
}

