/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.pentaho.metaverse.api.IHasProperties;

public class PropertiesHolder
implements IHasProperties {
    protected Map<String, Object> properties = new HashMap<String, Object>();
    private boolean dirty = false;

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public String getPropertyAsString(String key) {
        Object prop = this.getProperty(key);
        if (prop == null) {
            return null;
        }
        return prop.toString();
    }

    @Override
    public void setProperty(String key, Object value) {
        this.dirty = true;
        this.properties.put(key, value);
    }

    @Override
    public Object removeProperty(String key) {
        this.dirty = true;
        return this.properties.remove(key);
    }

    @Override
    public Set<String> getPropertyKeys() {
        return this.properties.keySet();
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        this.dirty = true;
        this.properties.putAll(props);
    }

    @Override
    public void removeProperties(Set<String> keys) {
        if (keys != null) {
            this.dirty = true;
            for (String key : keys) {
                this.properties.remove(key);
            }
        }
    }

    @Override
    public void clearProperties() {
        this.dirty = true;
        this.properties.clear();
    }

    @Override
    public boolean containsKey(String key) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey(key);
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String toString() {
        if (this.properties == null) {
            return super.toString();
        }
        return this.properties.toString();
    }
}

