/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.analyzer.kettle;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import flexjson.JSONSerializer;
import java.util.List;
import org.pentaho.metaverse.api.ChangeType;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.model.IOperation;
import org.pentaho.metaverse.api.model.Operation;
import org.pentaho.metaverse.api.model.Operations;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class ComponentDerivationRecord {
    protected StepField originalField;
    protected StepField changedField;
    protected ChangeType changeType = ChangeType.METADATA;
    protected Operations operations = new Operations();

    public ComponentDerivationRecord() {
        this.originalField = new StepField();
        this.changedField = new StepField();
    }

    public ComponentDerivationRecord(StepField originalField, StepField changedField) {
        this();
        this.originalField = originalField;
        this.changedField = changedField;
    }

    public ComponentDerivationRecord(StepField originalField, StepField changedField, ChangeType changeType) {
        this();
        this.originalField = originalField;
        this.changedField = changedField;
        this.changeType = changeType;
    }

    public ComponentDerivationRecord(String originalEntityName, String changedEntityName) {
        this(originalEntityName, changedEntityName, ChangeType.METADATA);
    }

    public ComponentDerivationRecord(String originalEntityName, String changedEntityName, ChangeType changeType) {
        this();
        this.originalField = new StepField("", originalEntityName);
        this.changedField = new StepField("", changedEntityName);
        this.changeType = changeType;
    }

    public ComponentDerivationRecord(String changedEntityName, ChangeType changeType) {
        this();
        this.originalField = new StepField("", changedEntityName);
        this.changedField = new StepField("", changedEntityName);
        this.changeType = changeType;
    }

    public ComponentDerivationRecord(String changedEntityName) {
        this(changedEntityName, ChangeType.METADATA);
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public void setChangeType(ChangeType changeType) {
        this.changeType = changeType;
    }

    public String getChangedEntityName() {
        return this.changedField.getFieldName();
    }

    public void setChangedEntityName(String changedEntityName) {
        this.changedField.setFieldName(changedEntityName);
    }

    public String getOriginalEntityName() {
        return this.originalField.getFieldName();
    }

    public void setOriginalEntityName(String originalEntityName) {
        this.originalField.setFieldName(originalEntityName);
    }

    public String getOriginalEntityStepName() {
        return this.originalField.getStepName();
    }

    public void setOriginalEntityStepName(String stepName) {
        this.originalField.setStepName(stepName);
    }

    public String getChangedEntityStepName() {
        return this.changedField.getStepName();
    }

    public void setChangedEntityStepName(String stepName) {
        this.changedField.setStepName(stepName);
    }

    public StepField getOriginalField() {
        return this.originalField;
    }

    public void setOriginalField(StepField originalField) {
        this.originalField = originalField;
    }

    public StepField getChangedField() {
        return this.changedField;
    }

    public void setChangedField(StepField changedField) {
        this.changedField = changedField;
    }

    public List<IOperation> getOperations(ChangeType type) {
        return (List)this.getOperations().get((Object)type);
    }

    public Operations getOperations() {
        if (this.operations == null) {
            this.operations = new Operations();
        }
        return this.operations;
    }

    public void addOperation(Operation operation) {
        if (operation != null) {
            this.getOperations().addOperation(operation.getType(), operation);
        }
    }

    public boolean hasDelta() {
        return this.operations != null && !this.operations.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentDerivationRecord that = (ComponentDerivationRecord)o;
        if (this.originalField != null ? !this.originalField.equals(that.originalField) : that.originalField != null) {
            return false;
        }
        if (this.changedField != null ? !this.changedField.equals(that.changedField) : that.changedField != null) {
            return false;
        }
        if (this.changeType != that.changeType) {
            return false;
        }
        return !(this.operations == null ? that.operations != null : !this.operations.equals(that.operations));
    }

    public int hashCode() {
        int result = this.originalField != null ? this.originalField.hashCode() : 0;
        result = 31 * result + (this.changedField != null ? this.changedField.hashCode() : 0);
        result = 31 * result + (this.changeType != null ? this.changeType.hashCode() : 0);
        result = 31 * result + (this.operations != null ? this.operations.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new JSONSerializer().include(new String[]{"*"}).serialize((Object)this.operations);
    }
}

