/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.scheduler2.action;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.action.ActionInvocationException;
import org.pentaho.platform.api.action.IAction;
import org.pentaho.platform.api.action.IPostProcessingAction;
import org.pentaho.platform.api.action.IStreamingAction;
import org.pentaho.platform.api.action.IVarArgsAction;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository2.unified.ISourcesStreamEvents;
import org.pentaho.platform.api.repository2.unified.IStreamListener;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.scheduler2.IBackgroundExecutionStreamProvider;
import org.pentaho.platform.engine.core.output.FileContentItem;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.ActionSequenceCompatibilityFormatter;
import org.pentaho.platform.scheduler2.messsages.Messages;
import org.pentaho.platform.scheduler2.quartz.SchedulerOutputPathResolver;
import org.pentaho.platform.util.ActionUtil;
import org.pentaho.platform.util.beans.ActionHarness;
import org.pentaho.platform.util.beans.PropertyNameFormatter;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.workitem.WorkItemLifecycleEventUtil;
import org.pentaho.platform.workitem.WorkItemLifecyclePhase;

public class ActionRunner
implements Callable<Boolean> {
    private static final Log logger = LogFactory.getLog(ActionRunner.class);
    private Map<String, Serializable> params;
    private IAction actionBean;
    private IBackgroundExecutionStreamProvider streamProvider;
    private String actionUser;
    private String outputFilePath = null;
    private Object lock = new Object();

    public ActionRunner(IAction actionBean, String actionUser, Map<String, Serializable> params, IBackgroundExecutionStreamProvider streamProvider) {
        this.actionBean = actionBean;
        this.actionUser = actionUser;
        this.params = params;
        this.streamProvider = streamProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws ActionInvocationException {
        String workItemName = ActionUtil.extractName(this.params);
        try {
            ExecutionResult result = this.callImpl();
            if (result.isSuccess().booleanValue()) {
                WorkItemLifecycleEventUtil.publish((String)workItemName, this.params, (WorkItemLifecyclePhase)WorkItemLifecyclePhase.SUCCEEDED);
            } else {
                WorkItemLifecycleEventUtil.publish((String)workItemName, this.params, (WorkItemLifecyclePhase)WorkItemLifecyclePhase.FAILED);
            }
            return result.updateRequired();
        }
        catch (Throwable t) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            WorkItemLifecycleEventUtil.publish((String)workItemName, this.params, (WorkItemLifecyclePhase)WorkItemLifecyclePhase.FAILED, (String)t.toString());
            throw new ActionInvocationException(Messages.getInstance().getActionFailedToExecute(this.actionBean.getClass().getName()), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutionResult callImpl() throws Exception {
        Object resolver;
        boolean executionStatus = true;
        Serializable locale = this.params.get("user_locale");
        if (locale instanceof Locale) {
            LocaleHelper.setLocaleOverride((Locale)((Locale)locale));
        } else {
            LocaleHelper.setLocaleOverride((Locale)new Locale((String)((Object)locale)));
        }
        ActionHarness actionHarness = new ActionHarness(this.actionBean);
        boolean updateJob = false;
        HashMap<String, Object> actionParams = new HashMap<String, Object>();
        actionParams.putAll(this.params);
        if (this.streamProvider != null) {
            actionParams.put("inputStream", this.streamProvider.getInputStream());
        }
        actionHarness.setValues(actionParams, new PropertyNameFormatter[]{new ActionSequenceCompatibilityFormatter()});
        if (this.actionBean instanceof IVarArgsAction) {
            actionParams.remove("inputStream");
            actionParams.remove("outputStream");
            ((IVarArgsAction)this.actionBean).setVarArgs(actionParams);
        }
        boolean waitForFileCreated = false;
        OutputStream stream = null;
        if (this.streamProvider != null) {
            String outputPath;
            actionParams.remove("inputStream");
            if (this.actionBean instanceof IStreamingAction) {
                this.streamProvider.setStreamingAction((IStreamingAction)this.actionBean);
            }
            if ((outputPath = ((SchedulerOutputPathResolver)(resolver = new SchedulerOutputPathResolver(this.streamProvider.getOutputPath(), this.actionUser))).resolveOutputFilePath()) == null) {
                return new ExecutionResult(true, false);
            }
            actionParams.put("useJcr", Boolean.TRUE);
            actionParams.put("jcrOutputPath", outputPath.substring(0, outputPath.lastIndexOf("/")));
            if (!outputPath.equals(this.streamProvider.getOutputPath())) {
                this.streamProvider.setOutputFilePath(outputPath);
                updateJob = true;
            }
            if ((stream = this.streamProvider.getOutputStream()) instanceof ISourcesStreamEvents) {
                ((ISourcesStreamEvents)stream).addListener(new IStreamListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void fileCreated(String filePath) {
                        Object object = ActionRunner.this.lock;
                        synchronized (object) {
                            ActionRunner.this.outputFilePath = filePath;
                            ActionRunner.this.lock.notifyAll();
                        }
                    }
                });
                waitForFileCreated = true;
            }
            actionParams.put("outputStream", stream);
            ActionUtil.removeKeyFromMap(actionParams, (String)"lineage-id");
            actionHarness.setValues(actionParams);
        }
        this.actionBean.execute();
        executionStatus = this.actionBean.isExecutionSuccessful();
        if (stream != null) {
            IOUtils.closeQuietly(stream);
        }
        if (waitForFileCreated) {
            resolver = this.lock;
            synchronized (resolver) {
                if (this.outputFilePath == null) {
                    this.lock.wait();
                }
            }
            ActionUtil.sendEmail(actionParams, this.params, (String)this.outputFilePath);
            this.deleteEmptyFile();
        }
        if (this.actionBean instanceof IPostProcessingAction) {
            this.closeContentOutputStreams((IPostProcessingAction)this.actionBean);
            this.markContentAsGenerated((IPostProcessingAction)this.actionBean);
        }
        ExecutionResult executionResult = new ExecutionResult(updateJob, executionStatus);
        return executionResult;
    }

    private void deleteEmptyFile() {
        IUnifiedRepository repo = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        RepositoryFile file = repo.getFile(this.outputFilePath);
        Long emptyFileSize = new Long(0L);
        Long fileSize = file.getFileSize();
        if (fileSize.equals(emptyFileSize)) {
            repo.deleteFile(file.getId(), true, null);
        }
    }

    private void closeContentOutputStreams(IPostProcessingAction actionBean) {
        for (IContentItem contentItem : actionBean.getActionOutputContents()) {
            contentItem.closeOutputStream();
        }
    }

    private void markContentAsGenerated(IPostProcessingAction actionBean) {
        IUnifiedRepository repo = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        String lineageId = (String)((Object)this.params.get("lineage-id"));
        for (IContentItem contentItem : actionBean.getActionOutputContents()) {
            RepositoryFile sourceFile = this.getRepositoryFileSafe(repo, contentItem.getPath());
            if (sourceFile != null) {
                Map metadata = repo.getFileMetadata(sourceFile.getId());
                metadata.put("lineage-id", lineageId);
                repo.setFileMetadata(sourceFile.getId(), metadata);
                continue;
            }
            String fileName = this.getFSFileNameSafe(contentItem);
            logger.warn((Object)Messages.getInstance().getSkipRemovingOutputFile(fileName));
        }
    }

    private RepositoryFile getRepositoryFileSafe(IUnifiedRepository repo, String path) {
        try {
            return repo.getFile(path);
        }
        catch (Exception e) {
            logger.debug((Object)Messages.getInstance().getCannotGetRepoFile(path, e.getMessage()));
            return null;
        }
    }

    private String getFSFileNameSafe(IContentItem contentItem) {
        if (contentItem instanceof FileContentItem) {
            return ((FileContentItem)contentItem).getFile().getName();
        }
        return null;
    }

    private class ExecutionResult {
        private boolean updateRequired;
        private boolean isSuccess;

        public ExecutionResult(Boolean updateRequired, Boolean isSuccess) {
            this.updateRequired = updateRequired;
            this.isSuccess = isSuccess;
        }

        public Boolean updateRequired() {
            return this.updateRequired;
        }

        public Boolean isSuccess() {
            return this.isSuccess;
        }
    }
}

