/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.scheduler2.blockout;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.platform.api.scheduler2.IBlockoutManager;
import org.pentaho.platform.api.scheduler2.IJobFilter;
import org.pentaho.platform.api.scheduler2.IJobTrigger;
import org.pentaho.platform.api.scheduler2.IScheduler;
import org.pentaho.platform.api.scheduler2.Job;
import org.pentaho.platform.api.scheduler2.JobTrigger;
import org.pentaho.platform.api.scheduler2.SchedulerException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.scheduler2.blockout.BlockoutManagerUtil;

public class PentahoBlockoutManager
implements IBlockoutManager {
    private IScheduler scheduler = (IScheduler)PentahoSystem.get(IScheduler.class, (String)"IScheduler2", null);

    @Override
    public IJobTrigger getBlockOut(String blockOutJobId) {
        try {
            Job blockOutJob = this.scheduler.getJob(blockOutJobId);
            JobTrigger blockOutJobTrigger = blockOutJob.getJobTrigger();
            blockOutJobTrigger.setDuration(((Number)blockOutJob.getJobParams().get("DURATION_PARAM")).longValue());
            return blockOutJobTrigger;
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Job> getBlockOutJobs() {
        try {
            List<Job> jobs = this.scheduler.getJobs(new IJobFilter(){

                @Override
                public boolean accept(Job job) {
                    if ("BlockoutAction".equals(job.getJobName())) {
                        job.getJobTrigger().setDuration(((Number)job.getJobParams().get("DURATION_PARAM")).longValue());
                        return true;
                    }
                    return false;
                }
            });
            return jobs;
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean willFire(IJobTrigger scheduleTrigger) {
        return BlockoutManagerUtil.willFire(scheduleTrigger, this.getBlockOutJobTriggers(), this.scheduler);
    }

    @Override
    public boolean shouldFireNow() {
        return BlockoutManagerUtil.shouldFireNow(this.getBlockOutJobTriggers(), this.scheduler);
    }

    @Override
    public List<IJobTrigger> willBlockSchedules(IJobTrigger testBlockOutJobTrigger) {
        ArrayList<IJobTrigger> blockedSchedules = new ArrayList<IJobTrigger>();
        List<Object> scheduledJobs = new ArrayList();
        try {
            scheduledJobs = this.scheduler.getJobs(new IJobFilter(){

                @Override
                public boolean accept(Job job) {
                    return !"BlockoutAction".equals(job.getJobName());
                }
            });
        }
        catch (SchedulerException e) {
            throw new RuntimeException(e);
        }
        for (Job job : scheduledJobs) {
            if (!BlockoutManagerUtil.willBlockSchedule(job.getJobTrigger(), testBlockOutJobTrigger, this.scheduler)) continue;
            blockedSchedules.add(job.getJobTrigger());
        }
        return blockedSchedules;
    }

    @Override
    public boolean isPartiallyBlocked(IJobTrigger scheduleJobTrigger) {
        return BlockoutManagerUtil.isPartiallyBlocked(scheduleJobTrigger, this.getBlockOutJobTriggers(), this.scheduler);
    }

    private List<IJobTrigger> getBlockOutJobTriggers() {
        ArrayList<IJobTrigger> blockOutJobTriggers = new ArrayList<IJobTrigger>();
        for (Job blockOutJob : this.getBlockOutJobs()) {
            blockOutJobTriggers.add(blockOutJob.getJobTrigger());
        }
        return blockOutJobTriggers;
    }
}

