/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.scheduler2.quartz;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.scheduler2.IBlockoutManager;
import org.pentaho.platform.engine.core.audit.AuditHelper;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.scheduler2.blockout.BlockoutAction;
import org.pentaho.platform.scheduler2.blockout.PentahoBlockoutManager;
import org.pentaho.platform.scheduler2.quartz.ActionAdapterQuartzJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;

public class BlockingQuartzJob
implements Job {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        long start;
        boolean jobRestarted = jobExecutionContext != null && jobExecutionContext.getJobDetail() != null ? jobExecutionContext.getJobDetail().getJobDataMap().getBooleanValue("ActionAdapterQuartzJob-Restart") : false;
        String messageType = jobRestarted ? "recreated_instance_start" : "instance_start";
        long end = start = System.currentTimeMillis();
        try {
            if (this.getBlockoutManager().shouldFireNow() || this.isBlockoutAction(jobExecutionContext)) {
                this.makeAuditRecord(0.0f, messageType, jobExecutionContext);
                this.createUnderlyingJob().execute(jobExecutionContext);
                end = System.currentTimeMillis();
                messageType = jobRestarted ? "recreated_instance_end" : "instance_end";
            } else {
                this.getLogger().warn((Object)("Job '" + jobExecutionContext.getJobDetail().getName() + "' attempted to run during a blockout period.  This job was not executed"));
            }
        }
        catch (ActionAdapterQuartzJob.LoggingJobExecutionException le) {
            end = System.currentTimeMillis();
            messageType = jobRestarted ? "recreated_instance_failed" : "instance_failed";
        }
        catch (SchedulerException e) {
            end = System.currentTimeMillis();
            messageType = jobRestarted ? "recreated_instance_failed" : "instance_failed";
            this.getLogger().warn((Object)("Got Exception retrieving the Blockout Manager for job '" + jobExecutionContext.getJobDetail().getName() + "'. Executing the underlying job anyway"), (Throwable)e);
            this.createUnderlyingJob().execute(jobExecutionContext);
            end = System.currentTimeMillis();
            messageType = jobRestarted ? "recreated_instance_end" : "instance_end";
        }
        finally {
            this.makeAuditRecord((float)(end - start) / 1000.0f, messageType, jobExecutionContext);
        }
    }

    IBlockoutManager getBlockoutManager() throws SchedulerException {
        return new PentahoBlockoutManager();
    }

    Job createUnderlyingJob() {
        return new ActionAdapterQuartzJob();
    }

    Log getLogger() {
        return LogFactory.getLog(BlockingQuartzJob.class);
    }

    protected boolean isBlockoutAction(JobExecutionContext ctx) {
        try {
            String actionClass = ctx.getJobDetail().getJobDataMap().getString("ActionAdapterQuartzJob-ActionClass");
            return BlockoutAction.class.getName().equals(actionClass);
        }
        catch (Throwable t) {
            this.getLogger().warn((Object)t.getMessage(), t);
            return false;
        }
    }

    protected void makeAuditRecord(float time, String messageType, JobExecutionContext jobExecutionContext) {
        if (jobExecutionContext != null && jobExecutionContext.getJobDetail() != null) {
            JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
            if (null == jobDataMap || null == jobDataMap.get((Object)"ActionAdapterQuartzJob-StreamProvider") || null == jobDataMap.get((Object)"ActionAdapterQuartzJob-ActionId")) {
                return;
            }
            AuditHelper.audit((String)(PentahoSessionHolder.getSession() != null ? PentahoSessionHolder.getSession().getId() : ""), (String)(jobDataMap.get((Object)"ActionAdapterQuartzJob-ActionUser") != null ? jobDataMap.get((Object)"ActionAdapterQuartzJob-ActionUser").toString() : ""), (String)(jobDataMap.get((Object)"ActionAdapterQuartzJob-StreamProvider") != null ? jobDataMap.get((Object)"ActionAdapterQuartzJob-StreamProvider").toString() : ""), (String)(jobExecutionContext.getJobDetail().getJobClass() != null ? jobExecutionContext.getJobDetail().getJobClass().getName() : ""), (String)(jobDataMap.get((Object)"ActionAdapterQuartzJob-ActionId") != null ? jobDataMap.get((Object)"ActionAdapterQuartzJob-ActionId").toString() : ""), (String)messageType, (String)(jobDataMap.get((Object)"lineage-id") != null ? jobDataMap.get((Object)"lineage-id").toString() : ""), null, (float)time, null);
        }
    }
}

