/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.scheduler2.quartz;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.IClientRepositoryPathsStrategy;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.repository2.unified.RepositoryFilePermission;
import org.pentaho.platform.api.scheduler2.SchedulerException;
import org.pentaho.platform.api.usersettings.IUserSettingService;
import org.pentaho.platform.api.usersettings.pojo.IUserSetting;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.scheduler2.messsages.Messages;

public class SchedulerOutputPathResolver {
    final String DEFAULT_SETTING_KEY = "default-scheduler-output-path";
    public static final String SCHEDULER_ACTION_NAME = "org.pentaho.scheduler.manage";
    private static final Log logger = LogFactory.getLog(SchedulerOutputPathResolver.class);
    private static final List<RepositoryFilePermission> permissions = new ArrayList<RepositoryFilePermission>();
    private String jobName;
    private String outputDirectory;
    private String actionUser;

    public SchedulerOutputPathResolver(String outputPathPattern, String actionUser) {
        this.jobName = FilenameUtils.getBaseName((String)outputPathPattern);
        this.outputDirectory = FilenameUtils.getPathNoEndSeparator((String)outputPathPattern);
        this.actionUser = actionUser;
    }

    public String resolveOutputFilePath() {
        final String fileNamePattern = "/" + this.jobName + ".*";
        final String outputFilePath = "/" + this.outputDirectory;
        Callable<String> callable = new Callable<String>(){

            @Override
            public String call() throws Exception {
                String[] fallBackPaths;
                if (StringUtils.isNotBlank((String)outputFilePath) && SchedulerOutputPathResolver.this.isValidOutputPath(outputFilePath) && SchedulerOutputPathResolver.this.isPermitted(outputFilePath)) {
                    return outputFilePath + fileNamePattern;
                }
                for (String path : fallBackPaths = new String[]{SchedulerOutputPathResolver.this.getUserSettingOutputPath(), SchedulerOutputPathResolver.this.getSystemSettingOutputPath(), SchedulerOutputPathResolver.this.getUserHomeDirectoryPath()}) {
                    if (!StringUtils.isNotBlank((String)path) || !SchedulerOutputPathResolver.this.isValidOutputPath(path)) continue;
                    return path + fileNamePattern;
                }
                return null;
            }
        };
        return this.runAsUser(callable);
    }

    private String runAsUser(Callable<String> callable) {
        try {
            if (callable != null) {
                return (String)SecurityHelper.getInstance().runAsUser(this.actionUser, callable);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private boolean isValidOutputPath(String path) throws SchedulerException {
        try {
            RepositoryFile repoFile = this.getRepository().getFile(path);
            if (repoFile != null && repoFile.isFolder()) {
                boolean scheduleAllowed = this.isScheduleAllowed(repoFile.getId());
                if (scheduleAllowed) {
                    return true;
                }
                throw new SchedulerException(Messages.getInstance().getString("QuartzScheduler.ERROR_0009_SCHEDULING_IS_NOT_ALLOWED_AFTER_CHANGE", new Object[]{this.jobName, this.actionUser}));
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private String getUserSettingOutputPath() {
        try {
            IUserSetting userSetting = this.getUserSettingService().getUserSetting("default-scheduler-output-path", null);
            if (userSetting != null && StringUtils.isNotBlank((String)userSetting.getSettingValue())) {
                return userSetting.getSettingValue();
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private String getSystemSettingOutputPath() {
        try {
            return PentahoSystem.getSystemSettings().getSystemSetting("default-scheduler-output-path", null);
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String getUserHomeDirectoryPath() {
        try {
            IClientRepositoryPathsStrategy pathsStrategy = (IClientRepositoryPathsStrategy)PentahoSystem.get(IClientRepositoryPathsStrategy.class, (IPentahoSession)this.getScheduleCreatorSession());
            return pathsStrategy.getUserHomeFolderPath(this.getScheduleCreatorSession().getName());
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private IPentahoSession getScheduleCreatorSession() {
        return PentahoSessionHolder.getSession();
    }

    private IUnifiedRepository getRepository() {
        return (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, (IPentahoSession)this.getScheduleCreatorSession());
    }

    private IUserSettingService getUserSettingService() {
        return (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)this.getScheduleCreatorSession());
    }

    private IAuthorizationPolicy getAuthorizationPolicy() {
        return (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class, (IPentahoSession)this.getScheduleCreatorSession());
    }

    private boolean isScheduleAllowed(Serializable repositoryId) {
        Map metadata;
        boolean canSchedule = false;
        canSchedule = this.getAuthorizationPolicy().isAllowed(SCHEDULER_ACTION_NAME);
        if (canSchedule && (metadata = this.getRepository().getFileMetadata(repositoryId)).containsKey("_PERM_SCHEDULABLE")) {
            canSchedule = BooleanUtils.toBoolean((String)((String)metadata.get("_PERM_SCHEDULABLE")));
        }
        return canSchedule;
    }

    private boolean isPermitted(String path) {
        try {
            return this.getRepository().hasAccess(path, EnumSet.copyOf(permissions));
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    static {
        permissions.add(RepositoryFilePermission.READ);
        permissions.add(RepositoryFilePermission.WRITE);
    }
}

