/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import com.cloudera.sqoop.SqoopOptions;
import com.cloudera.sqoop.manager.ManagerFactory;
import com.cloudera.sqoop.metastore.JobData;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.manager.ConnManager;
import org.apache.sqoop.manager.OracleManager;
import org.apache.sqoop.manager.oracle.OraOopConnManager;
import org.apache.sqoop.manager.oracle.OraOopConstants;
import org.apache.sqoop.manager.oracle.OraOopJdbcUrl;
import org.apache.sqoop.manager.oracle.OraOopLog;
import org.apache.sqoop.manager.oracle.OraOopLogFactory;
import org.apache.sqoop.manager.oracle.OraOopLogMessage;
import org.apache.sqoop.manager.oracle.OraOopOracleQueries;
import org.apache.sqoop.manager.oracle.OraOopOutputFormatUpdate;
import org.apache.sqoop.manager.oracle.OraOopUtilities;
import org.apache.sqoop.manager.oracle.OracleActiveInstance;
import org.apache.sqoop.manager.oracle.OracleConnectionFactory;
import org.apache.sqoop.manager.oracle.OracleTable;
import org.apache.sqoop.manager.oracle.OracleTablePartition;
import org.apache.sqoop.manager.oracle.OracleTablePartitions;
import org.apache.sqoop.manager.oracle.OracleVersion;

public class OraOopManagerFactory
extends ManagerFactory {
    private static final OraOopLog ORAOOP_LOG = OraOopLogFactory.getLog("org.apache.sqoop.manager.oracle");
    private static final OraOopLog LOG = OraOopLogFactory.getLog(OraOopManagerFactory.class.getName());

    @Override
    public com.cloudera.sqoop.manager.ConnManager accept(JobData jobData) {
        SqoopOptions sqoopOptions;
        String connectString;
        OraOopUtilities.enableDebugLoggingIfRequired(jobData.getSqoopOptions().getConf());
        LOG.debug(String.format("%s can be called by Sqoop!", "Data Connector for Oracle and Hadoop"));
        ConnManager result = null;
        if (jobData != null && (connectString = (sqoopOptions = jobData.getSqoopOptions()).getConnectString()) != null && connectString.toLowerCase().trim().startsWith("jdbc:oracle")) {
            if (!this.isOraOopEnabled(sqoopOptions)) {
                return result;
            }
            OraOopConnManager oraOopConnManager = null;
            OraOopConstants.Sqoop.Tool jobType = this.getSqoopJobType(jobData);
            OraOopUtilities.rememberSqoopJobType(jobType, jobData.getSqoopOptions().getConf());
            ArrayList<OraOopLogMessage> messagesToDisplayAfterWelcome = new ArrayList<OraOopLogMessage>();
            switch (jobType) {
                case IMPORT: {
                    Object connection;
                    if (!this.isNumberOfImportMappersOkay(sqoopOptions) || this.isSqoopImportIncremental(jobData) || !this.isSqoopImportJobTableBased(sqoopOptions)) break;
                    oraOopConnManager = new OraOopConnManager(sqoopOptions);
                    try {
                        connection = oraOopConnManager.getConnection();
                        if (!this.isSqoopTableAnOracleTable((Connection)connection, sqoopOptions.getUsername(), oraOopConnManager.getOracleTableContext())) break;
                        if (!this.isSqoopTableAnIndexOrganizedTable((Connection)connection, oraOopConnManager.getOracleTableContext())) {
                            result = oraOopConnManager;
                            break;
                        }
                        OraOopConstants.OraOopOracleDataChunkMethod method = OraOopUtilities.getOraOopOracleDataChunkMethod(sqoopOptions.getConf());
                        if (method == OraOopConstants.OraOopOracleDataChunkMethod.PARTITION) {
                            result = oraOopConnManager;
                            break;
                        }
                        LOG.info(String.format("%s will not process this Sqoop connection, as the Oracle table %s is an index-organized table. If the table is partitioned, set oraoop.chunk.method to " + (Object)((Object)OraOopConstants.OraOopOracleDataChunkMethod.PARTITION) + ".", "Data Connector for Oracle and Hadoop", oraOopConnManager.getOracleTableContext().toString()));
                        break;
                    }
                    catch (SQLException ex) {
                        throw new RuntimeException(String.format("Unable to connect to the Oracle database at %s\nError:%s", sqoopOptions.getConnectString(), ex.getMessage()), ex);
                    }
                }
                case EXPORT: {
                    if (!this.isNumberOfExportMappersOkay(sqoopOptions)) break;
                    oraOopConnManager = new OraOopConnManager(sqoopOptions);
                    Object connection = null;
                    try {
                        connection = oraOopConnManager.getConnection();
                    }
                    catch (SQLException ex) {
                        throw new RuntimeException(String.format("Unable to connect to the Oracle database at %s\nError:%s", sqoopOptions.getConnectString(), ex.getMessage()), ex);
                    }
                    try {
                        this.createAnyRequiredOracleObjects(sqoopOptions, (Connection)connection, oraOopConnManager, messagesToDisplayAfterWelcome);
                        if (!this.isSqoopTableAnOracleTable((Connection)connection, sqoopOptions.getUsername(), oraOopConnManager.getOracleTableContext())) break;
                        result = oraOopConnManager;
                    }
                    catch (SQLException ex) {
                        LOG.error(OraOopUtilities.getFullExceptionMessage(ex));
                    }
                    break;
                }
            }
            if (result != null) {
                this.showUserTheOraOopWelcomeMessage();
                for (OraOopLogMessage message : messagesToDisplayAfterWelcome) {
                    message.log(LOG);
                }
                sqoopOptions.getConf().setInt("oraoop.desired.num.mappers", sqoopOptions.getNumMappers());
                sqoopOptions.getConf().set("oraoop.oracle.session.module.action", this.getOracleSessionActionName(jobData));
                OraOopUtilities.appendJavaSecurityEgd(sqoopOptions.getConf());
                try {
                    OracleVersion oracleVersion = OraOopOracleQueries.getOracleVersion(result.getConnection());
                    LOG.info(String.format("Oracle Database version: %s", oracleVersion.getBanner()));
                    sqoopOptions.getConf().setInt("oraoop.oracle.database.version.major", oracleVersion.getMajor());
                    sqoopOptions.getConf().setInt("oraoop.oracle.database.version.minor", oracleVersion.getMinor());
                }
                catch (SQLException ex) {
                    LOG.error("Unable to obtain the Oracle database version.", ex);
                }
                try {
                    if (sqoopOptions.getConf().getBoolean("oraoop.import.consistent.read", false)) {
                        long scn = sqoopOptions.getConf().getLong("oraoop.import.consistent.read.scn", 0L);
                        if (scn == 0L) {
                            scn = OraOopOracleQueries.getCurrentScn(result.getConnection());
                        }
                        sqoopOptions.getConf().setLong("oraoop.import.consistent.read.scn", scn);
                        LOG.info("Performing a consistent read using SCN: " + scn);
                    }
                }
                catch (SQLException ex) {
                    throw new RuntimeException("Unable to determine SCN of database.", ex);
                }
                this.setMapperConnectionDetails(oraOopConnManager, jobData);
                this.showUserTheOracleCommandToKillOraOop(sqoopOptions);
            }
        }
        return result;
    }

    private void setMapperConnectionDetails(OraOopConnManager oraOopConnManager, JobData jobData) {
        Connection connection = null;
        try {
            connection = oraOopConnManager.getConnection();
        }
        catch (SQLException ex) {
            throw new RuntimeException(String.format("Unable to connect to the Oracle database at %s\nError:%s", jobData.getSqoopOptions().getConnectString(), ex.getMessage()));
        }
        List<OracleActiveInstance> activeInstances = null;
        try {
            activeInstances = OraOopOracleQueries.getOracleActiveInstances(connection);
        }
        catch (SQLException ex) {
            throw new RuntimeException("An error was encountered when attempting to determine the configuration of the Oracle RAC.", ex);
        }
        if (activeInstances == null) {
            LOG.info("This Oracle database is not a RAC.");
        } else {
            LOG.info("This Oracle database is a RAC.");
        }
        if (OraOopUtilities.oracleJdbcUrlGenerationDisabled(jobData.getSqoopOptions().getConf())) {
            LOG.info(String.format("%s will not use dynamically generated JDBC URLs - this feature has been disabled.", "Data Connector for Oracle and Hadoop"));
            return;
        }
        boolean generateRacBasedJdbcUrls = false;
        if (activeInstances != null) {
            generateRacBasedJdbcUrls = true;
            if (activeInstances.size() < OraOopUtilities.getMinNumberOfOracleRacActiveInstancesForDynamicJdbcUrlUse(jobData.getSqoopOptions().getConf())) {
                LOG.info(String.format("There are only %d active instances in the Oracle RAC. %s will not bother utilizing dynamically generated JDBC URLs.", activeInstances.size(), "Data Connector for Oracle and Hadoop"));
                generateRacBasedJdbcUrls = false;
            }
        }
        String jdbcConnectStr = jobData.getSqoopOptions().getConnectString();
        String jdbcHost = "";
        int jdbcPort = 0;
        String jdbcSid = "";
        String jdbcService = "";
        String jdbcTnsName = "";
        try {
            OraOopJdbcUrl oraOopJdbcUrl = new OraOopJdbcUrl(jdbcConnectStr);
            OraOopUtilities.JdbcOracleThinConnection jdbcConnection = oraOopJdbcUrl.parseJdbcOracleThinConnectionString();
            jdbcHost = jdbcConnection.getHost();
            jdbcPort = jdbcConnection.getPort();
            jdbcSid = jdbcConnection.getSid();
            jdbcService = jdbcConnection.getService();
            jdbcTnsName = jdbcConnection.getTnsName();
        }
        catch (OraOopUtilities.JdbcOracleThinConnectionParsingError ex) {
            LOG.info(String.format("Unable to parse the JDBC connection URL \"%s\" as a connection that uses the Oracle 'thin' JDBC driver.\nThis problem prevents %s from being able to dynamically generate JDBC URLs that specify 'dedicated server connections' or spread mapper sessions across multiple Oracle instances.\nIf the JDBC driver-type is 'OCI' (instead of 'thin'), then load-balancing should be appropriately managed automatically.", jdbcConnectStr, "Data Connector for Oracle and Hadoop", ex));
            return;
        }
        if (generateRacBasedJdbcUrls) {
            String oracleServiceName = OraOopUtilities.getOracleServiceName(jobData.getSqoopOptions().getConf());
            if (!oracleServiceName.isEmpty()) {
                if (!this.generateRacJdbcConnectionUrlsByServiceName(jdbcHost, jdbcPort, oracleServiceName, jobData)) {
                    throw new RuntimeException(String.format("Unable to connect to the Oracle database at %s via the service name \"%s\".", jobData.getSqoopOptions().getConnectString(), oracleServiceName));
                }
            } else {
                this.generateJdbcConnectionUrlsByActiveInstance(activeInstances, jdbcPort, jobData);
            }
        } else {
            this.generateJdbcConnectionUrlsByTnsnameSidOrService(jdbcHost, jdbcPort, jdbcSid, jdbcService, jdbcTnsName, jobData);
        }
    }

    private void generateJdbcConnectionUrlsByTnsnameSidOrService(String hostName, int port, String sid, String serviceName, String tnsName, JobData jobData) {
        String jdbcUrl = null;
        jdbcUrl = tnsName != null && !tnsName.isEmpty() ? OraOopUtilities.generateOracleTnsNameJdbcUrl(tnsName) : (sid != null && !sid.isEmpty() ? OraOopUtilities.generateOracleSidJdbcUrl(hostName, port, sid) : OraOopUtilities.generateOracleServiceNameJdbcUrl(hostName, port, serviceName));
        for (int idxMapper = 0; idxMapper < jobData.getSqoopOptions().getNumMappers(); ++idxMapper) {
            this.storeJdbcUrlForMapper(idxMapper, jdbcUrl, jobData);
        }
    }

    private boolean generateRacJdbcConnectionUrlsByServiceName(String hostName, int port, String serviceName, JobData jobData) {
        boolean result = false;
        String jdbcUrl = OraOopUtilities.generateOracleServiceNameJdbcUrl(hostName, port, serviceName);
        if (this.testDynamicallyGeneratedOracleRacInstanceConnection(jdbcUrl, jobData.getSqoopOptions().getUsername(), jobData.getSqoopOptions().getPassword(), jobData.getSqoopOptions().getConnectionParams(), false, "")) {
            LOG.info(String.format("%s will load-balance sessions across the Oracle RAC instances by connecting each mapper to the Oracle Service \"%s\".", "Data Connector for Oracle and Hadoop", serviceName));
            for (int idxMapper = 0; idxMapper < jobData.getSqoopOptions().getNumMappers(); ++idxMapper) {
                this.storeJdbcUrlForMapper(idxMapper, jdbcUrl, jobData);
            }
            result = true;
        }
        return result;
    }

    private void generateJdbcConnectionUrlsByActiveInstance(List<OracleActiveInstance> activeInstances, int jdbcPort, JobData jobData) {
        ArrayList<OraOopUtilities.JdbcOracleThinConnection> jdbcOracleActiveThinConnections = new ArrayList<OraOopUtilities.JdbcOracleThinConnection>(activeInstances.size());
        for (OracleActiveInstance oracleActiveInstance : activeInstances) {
            OraOopUtilities.JdbcOracleThinConnection jdbcActiveInstanceThinConnection = new OraOopUtilities.JdbcOracleThinConnection(oracleActiveInstance.getHostName(), jdbcPort, oracleActiveInstance.getInstanceName(), "", "");
            if (!this.testDynamicallyGeneratedOracleRacInstanceConnection(jdbcActiveInstanceThinConnection.toString(), jobData.getSqoopOptions().getUsername(), jobData.getSqoopOptions().getPassword(), jobData.getSqoopOptions().getConnectionParams(), true, oracleActiveInstance.getInstanceName())) continue;
            jdbcOracleActiveThinConnections.add(jdbcActiveInstanceThinConnection);
        }
        if (jdbcOracleActiveThinConnections.size() < OraOopUtilities.getMinNumberOfOracleRacActiveInstancesForDynamicJdbcUrlUse(jobData.getSqoopOptions().getConf())) {
            LOG.info(String.format("%s will not attempt to load-balance sessions across instances of an Oracle RAC - as multiple JDBC URLs to the Oracle RAC could not be dynamically generated.", "Data Connector for Oracle and Hadoop"));
            return;
        }
        StringBuilder msg = new StringBuilder();
        msg.append(String.format("%s will load-balance sessions across the following instances ofthe Oracle RAC:\n", "Data Connector for Oracle and Hadoop"));
        for (OraOopUtilities.JdbcOracleThinConnection thinConnection : jdbcOracleActiveThinConnections) {
            msg.append(String.format("\tInstance: %s \t URL: %s\n", thinConnection.getSid(), thinConnection.toString()));
        }
        LOG.info(msg.toString());
        int racInstanceIdx = 0;
        for (int idxMapper = 0; idxMapper < jobData.getSqoopOptions().getNumMappers(); ++idxMapper) {
            if (racInstanceIdx > jdbcOracleActiveThinConnections.size() - 1) {
                racInstanceIdx = 0;
            }
            OraOopUtilities.JdbcOracleThinConnection jdbcOracleThinConnection = (OraOopUtilities.JdbcOracleThinConnection)jdbcOracleActiveThinConnections.get(racInstanceIdx);
            ++racInstanceIdx;
            this.storeJdbcUrlForMapper(idxMapper, jdbcOracleThinConnection.toString(), jobData);
        }
    }

    private boolean testDynamicallyGeneratedOracleRacInstanceConnection(String url, String userName, String password, Properties additionalProps, boolean showInstanceSysTimestamp, String instanceDescription) {
        boolean result = false;
        try {
            Connection testConnection = OracleConnectionFactory.createOracleJdbcConnection("oracle.jdbc.OracleDriver", url, userName, password, additionalProps);
            if (showInstanceSysTimestamp) {
                LOG.info(String.format("\tDatabase time on %s is %s", instanceDescription, OraOopOracleQueries.getSysTimeStamp(testConnection)));
            }
            testConnection.close();
            result = true;
        }
        catch (SQLException ex) {
            LOG.warn(String.format("The dynamically generated JDBC URL \"%s\" was unable to connect to an instance in the Oracle RAC.", url), ex);
        }
        return result;
    }

    private void storeJdbcUrlForMapper(int mapperIdx, String jdbcUrl, JobData jobData) {
        Configuration conf = jobData.getSqoopOptions().getConf();
        String mapperJdbcUrlPropertyName = OraOopUtilities.getMapperJdbcUrlPropertyName(mapperIdx, conf);
        LOG.debug("Setting mapper url " + mapperJdbcUrlPropertyName + " = " + jdbcUrl);
        conf.set(mapperJdbcUrlPropertyName, jdbcUrl);
    }

    private boolean isOraOopEnabled(SqoopOptions sqoopOptions) {
        String oraOopDisabled = sqoopOptions.getConf().get("oraoop.disabled", "false").toLowerCase();
        boolean oraOopIsDisabled = oraOopDisabled.equalsIgnoreCase("true") || oraOopDisabled.equalsIgnoreCase("yes") || oraOopDisabled.equalsIgnoreCase("y") || oraOopDisabled.equalsIgnoreCase("1");
        boolean bl = oraOopIsDisabled = oraOopIsDisabled || !sqoopOptions.isDirect();
        if (oraOopIsDisabled) {
            LOG.info(String.format("%s is disabled.", "Data Connector for Oracle and Hadoop"));
        }
        return !oraOopIsDisabled;
    }

    private OraOopConstants.Sqoop.Tool getSqoopJobType(JobData jobData) {
        OraOopConstants.Sqoop.Tool result = OraOopConstants.Sqoop.Tool.UNKNOWN;
        String sqoopToolName = this.getSqoopToolName(jobData).toUpperCase().trim();
        try {
            result = OraOopConstants.Sqoop.Tool.valueOf(sqoopToolName);
        }
        catch (IllegalArgumentException ex) {
            LOG.debug(String.format("The Sqoop tool name \"%s\" is not supported by OraOop", sqoopToolName), ex);
        }
        return result;
    }

    private boolean isNumberOfImportMappersOkay(SqoopOptions sqoopOptions) {
        boolean result;
        boolean bl = result = sqoopOptions.getNumMappers() >= OraOopUtilities.getMinNumberOfImportMappersAcceptedByOraOop(sqoopOptions.getConf());
        if (!result) {
            LOG.info(String.format("%s will not process this sqoop connection, as an insufficient number of mappers are being used.", "Data Connector for Oracle and Hadoop"));
        }
        return result;
    }

    private boolean isNumberOfExportMappersOkay(SqoopOptions sqoopOptions) {
        boolean result;
        boolean bl = result = sqoopOptions.getNumMappers() >= OraOopUtilities.getMinNumberOfExportMappersAcceptedByOraOop(sqoopOptions.getConf());
        if (!result) {
            LOG.info(String.format("%s will not process this sqoop connection, as an insufficient number of mappers are being used.", "Data Connector for Oracle and Hadoop"));
        }
        return result;
    }

    private boolean isSqoopImportJobTableBased(SqoopOptions sqoopOptions) {
        String tableName = sqoopOptions.getTableName();
        return tableName != null && !tableName.isEmpty();
    }

    private boolean isSqoopTableAnOracleTable(Connection connection, String connectionUserName, OracleTable tableContext) {
        String oracleObjectType;
        try {
            OracleTable oracleTable = OraOopOracleQueries.getTable(connection, tableContext.getSchema(), tableContext.getName());
            if (oracleTable != null) {
                return true;
            }
            oracleObjectType = OraOopOracleQueries.getOracleObjectType(connection, tableContext);
            if (oracleObjectType == null) {
                LOG.info(String.format("%1$s will not process this Sqoop connection, as the Oracle user %2$s does not own a table named %3$s.\n\tPlease prefix the table name with the owner.\n \tNote: You may need to double-quote the owner and/or table name.\n\tE.g. sqoop ... --username %4$s --table %2$s.%3$s\n", "Data Connector for Oracle and Hadoop", tableContext.getSchema(), tableContext.getName(), connectionUserName));
                return false;
            }
        }
        catch (SQLException ex) {
            LOG.warn(String.format("Unable to determine the Oracle-type of the object named %s owned by %s.\nError:\n%s", tableContext.getName(), tableContext.getSchema(), ex.getMessage()));
            return true;
        }
        boolean result = oracleObjectType.equalsIgnoreCase("TABLE");
        if (!result) {
            LOG.info(String.format("%s will not process this sqoop connection, as %s is not an Oracle table, it's a %s.", "Data Connector for Oracle and Hadoop", tableContext.toString(), oracleObjectType));
        }
        return result;
    }

    private boolean isSqoopTableAnIndexOrganizedTable(Connection connection, OracleTable tableContext) {
        boolean result = false;
        try {
            result = OraOopOracleQueries.isTableAnIndexOrganizedTable(connection, tableContext);
            return result;
        }
        catch (SQLException ex) {
            LOG.warn(String.format("Unable to determine whether the Oracle table %s is an index-organized table.\nError:\n%s", tableContext.toString(), ex.getMessage()));
            return result;
        }
    }

    private String getSqoopToolName(JobData jobData) {
        return jobData.getSqoopTool().getToolName();
    }

    private String getOracleSessionActionName(JobData jobData) {
        if (this.getSqoopJobType(jobData) != OraOopConstants.Sqoop.Tool.IMPORT && this.getSqoopJobType(jobData) != OraOopConstants.Sqoop.Tool.EXPORT) {
            throw new UnsupportedOperationException(String.format("%s needs to be updated to cope with Sqoop jobs of type %s.", OraOopUtilities.getCurrentMethodName(), this.getSqoopToolName(jobData)));
        }
        String timeStr = new SimpleDateFormat("yyyyMMddHHmmsszzz").format(new java.util.Date());
        String result = String.format("%s %s", this.getSqoopToolName(jobData), timeStr);
        if (result.length() > 32) {
            result = result.substring(0, 32).trim();
        }
        return result;
    }

    private boolean isSqoopImportIncremental(JobData jobData) {
        boolean result;
        boolean bl = result = jobData.getSqoopOptions().getIncrementalMode() != SqoopOptions.IncrementalMode.None;
        if (result) {
            LOG.info(String.format("%1$s will not process this sqoop connection, as incremental mode is not supported by %1$s.", "Data Connector for Oracle and Hadoop"));
        }
        return result;
    }

    private void showUserTheOraOopWelcomeMessage() {
        String msg1 = String.format("Using %s", "Data Connector for Oracle and Hadoop");
        int longestMessage = msg1.length();
        msg1 = OraOopUtilities.padRight(msg1, longestMessage);
        char[] asterisks = new char[longestMessage + 8];
        Arrays.fill(asterisks, '*');
        String msg = String.format("\n%1$s\n*** %2$s ***\n%1$s", new String(asterisks), msg1);
        LOG.info(msg);
    }

    private void showUserTheOracleCommandToKillOraOop(SqoopOptions sqoopOptions) {
        int taskAttempts = sqoopOptions.getConf().getInt("mapreduce.map.maxattempts", -1);
        if (taskAttempts != 1) {
            return;
        }
        String moduleName = "Data Connector for Oracle and Hadoop";
        String actionName = sqoopOptions.getConf().get("oraoop.oracle.session.module.action");
        String msg = String.format("\nNote: This %s job can be killed via Oracle by executing the following statement:\n\tbegin\n\t\tfor row in (select sid,serial# from v$session where module='%s' and action='%s') loop\n\t\t\texecute immediate 'alter system kill session ''' || row.sid || ',' || row.serial# || '''';\n\t\tend loop;\n\tend;", "Data Connector for Oracle and Hadoop", moduleName, actionName);
        LOG.info(msg);
    }

    private void createAnyRequiredOracleObjects(SqoopOptions sqoopOptions, Connection connection, OraOopConnManager oraOopConnManager, List<OraOopLogMessage> messagesToDisplayAfterWelcome) throws SQLException {
        Configuration conf = sqoopOptions.getConf();
        Object sysDateTime = OraOopOracleQueries.getSysDate(connection);
        String sysDateStr = OraOopOracleQueries.oraDATEToString(sysDateTime, "yyyy-mm-dd hh24:mi:ss");
        OraOopUtilities.rememberOracleDateTime(conf, "oraoop.job.sysdate", sysDateStr);
        this.checkForOldOraOopTemporaryOracleTables(connection, sysDateTime, OraOopOracleQueries.getCurrentSchema(connection), messagesToDisplayAfterWelcome);
        String partitionValue = OraOopOracleQueries.oraDATEToString(sysDateTime, "yyyy-mm-dd hh24:mi:ss");
        conf.set("oraoop.export.partition.date.value", partitionValue);
        String partitionName = OraOopUtilities.createExportTablePartitionNameFromOracleTimestamp(sysDateTime);
        int numMappers = sqoopOptions.getNumMappers();
        String exportTableTemplate = conf.get("oraoop.template.table", "");
        String user = sqoopOptions.getUsername();
        if (user == null) {
            user = OracleManager.getSessionUser(connection);
        }
        OracleTable templateTableContext = OraOopUtilities.decodeOracleTableName(user, exportTableTemplate);
        boolean noLoggingOnNewTable = conf.getBoolean("oraoop.no.logging", false);
        String updateKeyCol = sqoopOptions.getUpdateKeyCol();
        if ((updateKeyCol == null || updateKeyCol.isEmpty()) && OraOopUtilities.getExportUpdateMode(conf) == OraOopOutputFormatUpdate.UpdateMode.Merge) {
            throw new RuntimeException(String.format("\n\nThe option \"%s\" can only be used if \"%s\" is also used.\n", "oraoop.export.merge", "--update-key"));
        }
        if (OraOopUtilities.userWantsToCreatePartitionedExportTableFromTemplate(conf) || OraOopUtilities.userWantsToCreateNonPartitionedExportTableFromTemplate(conf)) {
            String newTableObjectType;
            OraOopOutputFormatUpdate.UpdateMode updateMode;
            if (oraOopConnManager.getOracleTableContext().getName().length() > 30) {
                String msg = String.format("The Oracle table name \"%s\" is longer than %d characters.\nOracle will not allow a table with this name to be created.", oraOopConnManager.getOracleTableContext().getName(), 30);
                throw new RuntimeException(msg);
            }
            if (updateKeyCol != null && !updateKeyCol.isEmpty() && (updateMode = OraOopUtilities.getExportUpdateMode(conf)) == OraOopOutputFormatUpdate.UpdateMode.Update) {
                throw new RuntimeException(String.format("\n\nCombining the option \"%s\" with the option \"%s=false\" is nonsensical, as this would create an empty table and then perform a lot of work that results in a table containing no rows.\n", "oraoop.template.table", "oraoop.export.merge"));
            }
            String templateTableObjectType = OraOopOracleQueries.getOracleObjectType(connection, templateTableContext);
            if (templateTableObjectType == null) {
                throw new RuntimeException(String.format("The specified Oracle template table \"%s\" does not exist.", templateTableContext.toString()));
            }
            if (!templateTableObjectType.equalsIgnoreCase("TABLE")) {
                throw new RuntimeException(String.format("The specified Oracle template table \"%s\" is not an Oracle table, it's a %s.", templateTableContext.toString(), templateTableObjectType));
            }
            if (conf.getBoolean("oraoop.drop.table", false)) {
                OraOopOracleQueries.dropTable(connection, oraOopConnManager.getOracleTableContext());
            }
            if ((newTableObjectType = OraOopOracleQueries.getOracleObjectType(connection, oraOopConnManager.getOracleTableContext())) != null) {
                throw new RuntimeException(String.format("%s cannot create a new Oracle table named %s as a \"%s\" with this name already exists.", "Data Connector for Oracle and Hadoop", oraOopConnManager.getOracleTableContext().toString(), newTableObjectType));
            }
        } else if (updateKeyCol != null && !updateKeyCol.isEmpty()) {
            String[] updateKeyColumns = OraOopUtilities.getExportUpdateKeyColumnNames(sqoopOptions);
            if (!OraOopOracleQueries.doesIndexOnColumnsExist(connection, oraOopConnManager.getOracleTableContext(), updateKeyColumns)) {
                String msg = String.format("\n*****************************************************************************************************************************\n\tThe table %1$s does not have a valid index on the column(s) %2$s.\n\tAs a consequence, this export may take a long time to complete.\n\tIf performance is unacceptable, consider reattempting this job after creating an index on this table via the SQL...\n\t\tcreate index <index_name> on %1$s(%2$s);\n*****************************************************************************************************************************", oraOopConnManager.getOracleTableContext().toString(), OraOopUtilities.stringArrayToCSV(updateKeyColumns));
                messagesToDisplayAfterWelcome.add(new OraOopLogMessage(OraOopConstants.Logging.Level.WARN, msg));
            }
        }
        if (OraOopUtilities.userWantsToCreatePartitionedExportTableFromTemplate(conf)) {
            String[] subPartitionNames = OraOopUtilities.generateExportTableSubPartitionNames(numMappers, sysDateTime, conf);
            String tableStorageClause = OraOopUtilities.getExportTableStorageClause(conf);
            OraOopOracleQueries.createExportTableFromTemplateWithPartitioning(connection, oraOopConnManager.getOracleTableContext(), tableStorageClause, templateTableContext, noLoggingOnNewTable, partitionName, sysDateTime, sqoopOptions.getNumMappers(), subPartitionNames);
            return;
        }
        if (OraOopUtilities.userWantsToCreateNonPartitionedExportTableFromTemplate(conf)) {
            String tableStorageClause = OraOopUtilities.getExportTableStorageClause(conf);
            OraOopOracleQueries.createExportTableFromTemplate(connection, oraOopConnManager.getOracleTableContext(), tableStorageClause, templateTableContext, noLoggingOnNewTable);
            return;
        }
        OracleTablePartitions tablePartitions = OraOopOracleQueries.getPartitions(connection, oraOopConnManager.getOracleTableContext());
        OracleTablePartition oraOopPartition = tablePartitions.findPartitionByRegEx("^ORAOOP_");
        if (tablePartitions.size() > 0 && oraOopPartition == null) {
            for (int idx = 0; idx < tablePartitions.size(); ++idx) {
                messagesToDisplayAfterWelcome.add(new OraOopLogMessage(OraOopConstants.Logging.Level.INFO, String.format("The Oracle table %s has a partition named \"%s\".", oraOopConnManager.getOracleTableContext().toString(), ((OracleTablePartition)tablePartitions.get(idx)).getName())));
            }
            messagesToDisplayAfterWelcome.add(new OraOopLogMessage(OraOopConstants.Logging.Level.WARN, String.format("The Oracle table %s is partitioned.\nThese partitions were not created by %s.", oraOopConnManager.getOracleTableContext().toString(), "Data Connector for Oracle and Hadoop")));
        }
        if (oraOopPartition != null) {
            conf.setBoolean("oraoop.export.table.has.oraoop.partitions", true);
            messagesToDisplayAfterWelcome.add(new OraOopLogMessage(OraOopConstants.Logging.Level.INFO, String.format("The Oracle table %s is partitioned.\nThese partitions were created by %s, so additional partitions will now be created.\nThe name of the new partition will be \"%s\".", oraOopConnManager.getOracleTableContext().toString(), "Data Connector for Oracle and Hadoop", partitionName)));
            String[] subPartitionNames = OraOopUtilities.generateExportTableSubPartitionNames(numMappers, sysDateTime, conf);
            OraOopOracleQueries.createMoreExportTablePartitions(connection, oraOopConnManager.getOracleTableContext(), partitionName, sysDateTime, subPartitionNames);
            return;
        }
    }

    private void checkForOldOraOopTemporaryOracleTables(Connection connection, Object sysDateTime, String schema, List<OraOopLogMessage> messagesToDisplayAfterWelcome) {
        try {
            StringBuilder message = new StringBuilder();
            message.append(String.format("The following tables appear to be old temporary tables created by %s that have not been deleted.\nThey are probably left over from jobs that encountered an error and could not clean up after themselves.\nYou might want to drop these Oracle tables in order to reclaim Oracle storage space:\n", "Data Connector for Oracle and Hadoop"));
            boolean showMessage = false;
            String generatedTableName = OraOopUtilities.generateExportTableMapperTableName(0, sysDateTime, schema).getName();
            generatedTableName = generatedTableName.replaceAll("[0-9]", "%");
            generatedTableName = OraOopUtilities.replaceAll(generatedTableName, "%%", "%");
            Date sysDate = OraOopOracleQueries.oraDATEToDate(sysDateTime);
            List<OracleTable> tables = OraOopOracleQueries.getTablesWithTableNameLike(connection, schema, generatedTableName);
            for (OracleTable oracleTable : tables) {
                OraOopUtilities.DecodedExportMapperTableName tableName = OraOopUtilities.decodeExportTableMapperTableName(oracleTable);
                if (tableName == null) continue;
                Date tableDate = OraOopOracleQueries.oraDATEToDate(tableName.getTableDateTime());
                double daysApart = (sysDate.getTime() - tableDate.getTime()) / 86400000L;
                if (!(daysApart > 1.0)) continue;
                showMessage = true;
                message.append(String.format("\t%s\n", oracleTable.toString()));
            }
            if (showMessage) {
                messagesToDisplayAfterWelcome.add(new OraOopLogMessage(OraOopConstants.Logging.Level.INFO, message.toString()));
            }
        }
        catch (Exception ex) {
            messagesToDisplayAfterWelcome.add(new OraOopLogMessage(OraOopConstants.Logging.Level.WARN, String.format("%s was unable to check for the existance of old temporary Oracle tables.\nError:\n%s", "Data Connector for Oracle and Hadoop", ex.toString())));
        }
    }

    static {
        Configuration.addDefaultResource((String)"oraoop-site-template.xml");
        Configuration.addDefaultResource((String)"oraoop-site.xml");
    }
}

