/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import com.google.common.collect.Sets;
import java.util.Set;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.MySQLDatabaseMeta;

public class MariaDBDatabaseMeta
extends MySQLDatabaseMeta {
    private static final Set<String> SHORT_MESSAGE_EXCEPTIONS = Sets.newHashSet((Object[])new String[]{"org.mariadb.jdbc.internal.stream.MaxAllowedPacketException"});

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"mariadb-java-client-1.4.6.jar"};
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "org.mariadb.jdbc.Driver";
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + databaseName;
        }
        if (Const.isEmpty(port)) {
            return "jdbc:mariadb://" + hostname + "/" + databaseName;
        }
        return "jdbc:mariadb://" + hostname + ":" + port + "/" + databaseName;
    }

    @Override
    public boolean fullExceptionLog(Exception e) {
        Throwable cause = e == null ? null : e.getCause();
        return cause == null || !SHORT_MESSAGE_EXCEPTIONS.contains(cause.getClass().getName());
    }
}

