/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import org.pentaho.di.i18n.BaseMessages;

public enum LogLevel {
    NOTHING(0, "Nothing"),
    ERROR(1, "Error"),
    MINIMAL(2, "Minimal"),
    BASIC(3, "Basic"),
    DETAILED(4, "Detailed"),
    DEBUG(5, "Debug"),
    ROWLEVEL(6, "Rowlevel");

    private static Class<?> PKG;
    public static final String[] logLevelDescriptions;
    private int level;
    private String code;

    private LogLevel(int level, String code) {
        this.level = level;
        this.code = code;
    }

    public int getLevel() {
        return this.level;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return logLevelDescriptions[this.level];
    }

    public static LogLevel getLogLevelForCode(String code) {
        for (LogLevel logLevel : LogLevel.values()) {
            if (!logLevel.getCode().equals(code)) continue;
            return logLevel;
        }
        return BASIC;
    }

    public boolean isVisible(LogLevel filterLogLevel) {
        return this.getLevel() <= filterLogLevel.getLevel();
    }

    public boolean isError() {
        return this == ERROR;
    }

    public boolean isNothing() {
        return this.level >= LogLevel.NOTHING.level;
    }

    public boolean isMinimal() {
        return this.level >= LogLevel.MINIMAL.level;
    }

    public boolean isBasic() {
        return this.level >= LogLevel.BASIC.level;
    }

    public boolean isDetailed() {
        return this.level >= LogLevel.DETAILED.level;
    }

    public boolean isDebug() {
        return this.level >= LogLevel.DEBUG.level;
    }

    public boolean isRowlevel() {
        return this.level >= LogLevel.ROWLEVEL.level;
    }

    public static String[] getLogLevelDescriptions() {
        return logLevelDescriptions;
    }

    public static String[] logLogLevelCodes() {
        String[] codes = new String[LogLevel.values().length];
        for (int i = 0; i < codes.length; ++i) {
            codes[i] = LogLevel.values()[i].getCode();
        }
        return codes;
    }

    static {
        PKG = LogLevel.class;
        logLevelDescriptions = new String[]{BaseMessages.getString(PKG, "LogWriter.Level.Nothing.LongDesc", new String[0]), BaseMessages.getString(PKG, "LogWriter.Level.Error.LongDesc", new String[0]), BaseMessages.getString(PKG, "LogWriter.Level.Minimal.LongDesc", new String[0]), BaseMessages.getString(PKG, "LogWriter.Level.Basic.LongDesc", new String[0]), BaseMessages.getString(PKG, "LogWriter.Level.Detailed.LongDesc", new String[0]), BaseMessages.getString(PKG, "LogWriter.Level.Debug.LongDesc", new String[0]), BaseMessages.getString(PKG, "LogWriter.Level.Rowlevel.LongDesc", new String[0])};
    }
}

