/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.plugins.BasePluginType;
import org.pentaho.di.core.plugins.KettleURLClassLoader;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.plugins.PluginTypeListener;

public abstract class BaseFragmentType
extends BasePluginType {
    BaseFragmentType(Class<? extends Annotation> pluginType, String id, String name, Class<? extends PluginTypeInterface> typeToTrack) {
        super(pluginType, id, name);
        this.populateFolders(null);
        this.initListeners(this.getClass(), typeToTrack);
    }

    protected void initListeners(Class<? extends PluginTypeInterface> aClass, Class<? extends PluginTypeInterface> typeToTrack) {
        this.registry.addPluginListener(aClass, new FragmentTypeListener(this.registry, (Class)typeToTrack){

            @Override
            void mergePlugin(PluginInterface fragment, PluginInterface plugin) {
                if (plugin != null) {
                    plugin.merge(fragment);
                }
            }
        });
        this.registry.addPluginListener(typeToTrack, new FragmentTypeListener(this.registry, (Class)aClass){

            @Override
            void mergePlugin(PluginInterface plugin, PluginInterface fragment) {
                if (plugin != null) {
                    plugin.merge(fragment);
                }
            }
        });
    }

    @Override
    public boolean isFragment() {
        return true;
    }

    @Override
    protected URLClassLoader createUrlClassLoader(URL jarFileUrl, ClassLoader classLoader) {
        return new KettleURLClassLoader(new URL[]{jarFileUrl}, classLoader);
    }

    @Override
    protected void registerNatives() throws KettlePluginException {
    }

    @Override
    protected void registerXmlPlugins() throws KettlePluginException {
    }

    @Override
    protected String extractName(Annotation annotation) {
        return null;
    }

    @Override
    protected String extractDesc(Annotation annotation) {
        return null;
    }

    @Override
    protected String extractCategory(Annotation annotation) {
        return null;
    }

    @Override
    protected boolean extractSeparateClassLoader(Annotation annotation) {
        return false;
    }

    @Override
    protected String extractI18nPackageName(Annotation annotation) {
        return null;
    }

    @Override
    protected void addExtraClasses(Map<Class<?>, String> classMap, Class<?> clazz, Annotation annotation) {
    }

    protected abstract class FragmentTypeListener
    implements PluginTypeListener {
        private final PluginRegistry registry;
        private final Class<? extends PluginTypeInterface> typeToTrack;

        FragmentTypeListener(PluginRegistry registry, Class<? extends PluginTypeInterface> typeToTrack) {
            this.registry = registry;
            this.typeToTrack = typeToTrack;
        }

        abstract void mergePlugin(PluginInterface var1, PluginInterface var2);

        @Override
        public void pluginAdded(Object serviceObject) {
            PluginInterface left = (PluginInterface)serviceObject;
            PluginInterface right = this.registry.findPluginWithId(this.typeToTrack, left.getIds()[0]);
            this.mergePlugin(left, right);
        }

        @Override
        public void pluginRemoved(Object serviceObject) {
        }

        @Override
        public void pluginChanged(Object serviceObject) {
            this.pluginAdded(serviceObject);
        }
    }
}

