/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.mapr.AbstractHTable;
import org.apache.hadoop.hbase.client.mapr.AbstractMapRClusterConnection;
import org.apache.hadoop.hbase.client.mapr.BaseTableMappingRules;
import org.apache.hadoop.hbase.client.mapr.TableMappingRulesFactory;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BufferedMutatorImpl
implements BufferedMutator {
    private static final Log LOG = LogFactory.getLog(BufferedMutatorImpl.class);
    private final BufferedMutator.ExceptionListener listener;
    protected ClusterConnection connection;
    private final TableName tableName;
    private AbstractHTable maprTable_ = null;
    private volatile Configuration conf;
    private List<Row> writeAsyncBuffer = new LinkedList<Row>();
    private long writeBufferSize;
    private final int maxKeyValueSize;
    protected long currentWriteBufferSize = 0L;
    private boolean closed = false;
    private final boolean cleanupPoolOnClose_;
    private final ExecutorService pool;
    protected AsyncProcess ap = null;

    public BufferedMutatorImpl(ClusterConnection conn, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcFactory, BufferedMutatorParams params) {
        this(conn, rpcCallerFactory, rpcFactory, params, true);
    }

    public BufferedMutatorImpl(ClusterConnection conn, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcFactory, BufferedMutatorParams params, boolean cleanupPoolOnClose) {
        if (conn == null || conn.isClosed()) {
            throw new IllegalArgumentException("Connection is null or closed.");
        }
        this.tableName = params.getTableName();
        if (this.tableName == null) {
            LOG.warn((Object)"BufferedMutator is constructed with tableName as null");
        }
        this.connection = conn;
        this.conf = this.connection.getConfiguration();
        if (this.conf == null) {
            LOG.warn((Object)"BufferedMutator is constructed with conf as null");
        }
        this.cleanupPoolOnClose_ = cleanupPoolOnClose;
        this.pool = params.getPool();
        this.listener = params.getListener();
        if (this.listener != null && this.pool == null) {
            throw new IllegalArgumentException("BufferedMutator for " + this.tableName + " has a listener, but does not have a pool");
        }
        ConnectionConfiguration tableConf = new ConnectionConfiguration(this.conf);
        this.writeBufferSize = params.getWriteBufferSize() != -1L ? params.getWriteBufferSize() : tableConf.getWriteBufferSize();
        int n = this.maxKeyValueSize = params.getMaxKeyValueSize() != -1 ? params.getMaxKeyValueSize() : tableConf.getMaxKeyValueSize();
        if (!BaseTableMappingRules.isInHBaseService()) {
            if (this.connection instanceof AbstractMapRClusterConnection) {
                this.maprTable_ = AbstractMapRClusterConnection.createAbstractMapRTable(this.connection.getConfiguration(), this.tableName, this, this.listener, this.pool);
                if (this.maprTable_ == null) {
                    throw new IllegalArgumentException("Could not find table " + this.tableName + " through MapRClusterConnection.");
                }
            } else if (this.connection instanceof ConnectionManager.HConnectionImplementation) {
                BaseTableMappingRules tableMappingRule = null;
                try {
                    tableMappingRule = TableMappingRulesFactory.create(this.connection.getConfiguration());
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Could not get tableMappingRule for table " + this.tableName + " through HConnection. Reason:" + e.getStackTrace());
                }
                if (tableMappingRule != null && tableMappingRule.isMapRTable(this.tableName)) {
                    this.maprTable_ = HTable.createMapRTable(this.connection.getConfiguration(), this.tableName, this, this.listener, this.pool);
                }
            } else {
                LOG.warn((Object)"Unknown connection type!");
            }
        }
        if (this.maprTable_ == null) {
            this.ap = new AsyncProcess(this.connection, this.conf, this.pool, rpcCallerFactory, true, rpcFactory);
        } else {
            this.maprTable_.setAutoFlush(false);
        }
    }

    @Override
    public TableName getName() {
        return this.tableName;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public synchronized void mutate(Mutation m) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        this.doMutate(m);
    }

    @Override
    public synchronized void mutate(List<? extends Mutation> ms) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        for (Mutation mutation : ms) {
            this.doMutate(mutation);
        }
    }

    private void doMutate(Mutation m) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        if (this.closed) {
            throw new IllegalStateException("Cannot put when the BufferedMutator is closed.");
        }
        if (!(m instanceof Put) && !(m instanceof Delete)) {
            throw new IllegalArgumentException("Pass a Delete or a Put");
        }
        if (this.maprTable_ != null) {
            try {
                if (m instanceof Put) {
                    this.maprTable_.put((Put)m);
                }
                if (m instanceof Delete) {
                    this.maprTable_.delete((Delete)m);
                }
            }
            catch (IOException e) {
                throw new InterruptedIOException("Cannot put to this mapr table. Reason: " + e);
            }
            return;
        }
        if (this.ap.hasError()) {
            this.writeAsyncBuffer.add(m);
            this.backgroundFlushCommits(true);
        }
        if (m instanceof Put) {
            this.validatePut((Put)m);
        }
        this.currentWriteBufferSize += m.heapSize();
        this.writeAsyncBuffer.add(m);
        while (this.currentWriteBufferSize > this.writeBufferSize) {
            this.backgroundFlushCommits(false);
        }
    }

    public void validatePut(Put put) throws IllegalArgumentException {
        HTable.validatePut(put, this.maxKeyValueSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        block8: {
            if (this.closed) {
                return;
            }
            try {
                this.backgroundFlushCommits(true);
                if (this.maprTable_ != null) {
                    this.maprTable_.close();
                    this.maprTable_ = null;
                }
                if (!this.cleanupPoolOnClose_) break block8;
                this.pool.shutdown();
                boolean terminated = false;
                int loopCnt = 0;
                do {
                    terminated = this.pool.awaitTermination(60L, TimeUnit.SECONDS);
                    if (++loopCnt < 10) continue;
                    LOG.warn((Object)"close() failed to terminate pool after 10 minutes. Abandoning pool.");
                    break;
                } while (!terminated);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"waitForTermination interrupted");
            }
            finally {
                this.closed = true;
            }
        }
    }

    @Override
    public synchronized void flush() throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        this.backgroundFlushCommits(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backgroundFlushCommits(boolean synchronous) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        if (this.maprTable_ != null) {
            this.maprTable_.flushCommits();
            return;
        }
        try {
            if (!synchronous) {
                this.ap.submit(this.tableName, this.writeAsyncBuffer, true, null, false);
                if (this.ap.hasError()) {
                    LOG.debug((Object)(this.tableName + ": One or more of the operations have failed -" + " waiting for all operation in progress to finish (successfully or not)"));
                }
            }
            if (synchronous || this.ap.hasError()) {
                while (!this.writeAsyncBuffer.isEmpty()) {
                    this.ap.submit(this.tableName, this.writeAsyncBuffer, true, null, false);
                }
                RetriesExhaustedWithDetailsException error = this.ap.waitForAllPreviousOpsAndReset(null, this.tableName.getNameAsString());
                if (error != null) {
                    if (this.listener == null) {
                        throw error;
                    }
                    this.listener.onException(error, this);
                }
            }
        }
        finally {
            this.currentWriteBufferSize = 0L;
            for (Row mut : this.writeAsyncBuffer) {
                if (!(mut instanceof Mutation)) continue;
                this.currentWriteBufferSize += ((Mutation)mut).heapSize();
            }
        }
    }

    @Deprecated
    public void setWriteBufferSize(long writeBufferSize) throws RetriesExhaustedWithDetailsException, InterruptedIOException {
        if (this.maprTable_ != null) {
            try {
                this.maprTable_.setWriteBufferSize(writeBufferSize);
            }
            catch (IOException e) {
                throw new InterruptedIOException("Cannot set write buffer size for this mapr table. Reason:" + e);
            }
            return;
        }
        this.writeBufferSize = writeBufferSize;
        if (this.currentWriteBufferSize > writeBufferSize) {
            this.flush();
        }
    }

    @Override
    public long getWriteBufferSize() {
        if (this.maprTable_ != null) {
            return this.maprTable_.getWriteBufferSize();
        }
        return this.writeBufferSize;
    }

    @Deprecated
    public List<Row> getWriteBuffer() {
        if (this.maprTable_ != null) {
            return null;
        }
        return this.writeAsyncBuffer;
    }
}

